/**
 ********************************************************************************
 *** ExportUserDatasAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessapplicationdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserDataSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.anoaccessapplicationdata.bean.UserDataListItemBeanSortType;

public class ExportUserDatasAction extends BaseUserDataAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"UserData";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"UserData";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportUserDatasAction.class);
	private Sorter<UserData> sorter;

	private DocumentFilter userIdFilterAZ;

	public ExportUserDatasAction(){
		super();
		sorter = new QuickSorter<UserData>();
		try{ 
			userIdFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = UserDataListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = UserDataListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = UserDataListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				UserDataListItemBeanSortType.ASC : UserDataListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		UserDataListItemBeanSortType sessionSortType  = null;
		UserDataSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new UserDataListItemBeanSortType(sortMethod, sortOrder);
			sortType = new UserDataSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (UserDataListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new UserDataSortType(sortMethod, sortOrder) : new UserDataSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new UserDataListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<UserData> _unfiltered_userdatas = getAnoAccessApplicationDataService().getUserDatas();
		List<UserData> userdatas = new ArrayList<UserData>();
		for (UserData element : _unfiltered_userdatas ){
			boolean mayPass = true;
			mayPass = mayPass && (userIdFilterAZ.mayPass( element, "userId", filterParameter0));
			if (mayPass)
				userdatas.add(element);
		}
		userdatas = sorter.sort(userdatas, sortType);

		addBeanToRequest(req, "userdatas", userdatas);

		XMLNode beans = getAnoAccessApplicationDataService().exportUserDatasToXML(userdatas);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "userdatasXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "userdatasCSV", userdatas);
		addBeanToRequest(req, "userIdFilterAZ", userIdFilterAZ.getTriggerer(""));
		return mapping.success();
	}

}
