/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.regexparser.AbstractCharClassNode;
import net.amygdalum.regexparser.DefinedCharNode;
import net.amygdalum.regexparser.RegexNodeVisitor;

public class SpecialCharClassNode
extends AbstractCharClassNode {
    private char symbol;
    private List<DefinedCharNode> charNodes;

    public SpecialCharClassNode(char symbol, DefinedCharNode ... charNodes) {
        this(symbol, Arrays.asList(charNodes));
    }

    public SpecialCharClassNode(char symbol, List<DefinedCharNode> charNodes) {
        this.symbol = symbol;
        this.charNodes = charNodes;
    }

    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public List<DefinedCharNode> toCharNodes() {
        return this.charNodes;
    }

    @Override
    public SpecialCharClassNode invert(List<DefinedCharNode> allnodes) {
        return new SpecialCharClassNode(Character.toUpperCase(this.symbol), SpecialCharClassNode.computeComplement(this.charNodes, allnodes));
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitSpecialCharClass(this);
    }

    @Override
    public SpecialCharClassNode clone() {
        return (SpecialCharClassNode)super.clone();
    }

    public String toString() {
        return "\\" + this.symbol;
    }
}

