/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.regexparser.CharNode;

public abstract class DefinedCharNode
extends CharNode
implements Comparable<DefinedCharNode> {
    public abstract char getFrom();

    public abstract char getTo();

    @Override
    public List<DefinedCharNode> toCharNodes() {
        return Arrays.asList(this);
    }

    public int size() {
        char to = this.getTo();
        char from = this.getFrom();
        return to - from + 1;
    }

    public char[] chars() {
        char to = this.getTo();
        char from = this.getFrom();
        char[] chars = new char[to - from + 1];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(from + i);
        }
        return chars;
    }

    @Override
    public int compareTo(DefinedCharNode o) {
        int result = this.getFrom() - o.getFrom();
        if (result == 0) {
            result = this.getTo() - o.getTo();
        }
        return result;
    }

    public boolean cuts(DefinedCharNode node) {
        if (node.getFrom() == this.getFrom() && node.getTo() == this.getTo()) {
            return false;
        }
        return this.overlaps(node) || this.subsumes(node) || node.subsumes(this);
    }

    public boolean overlaps(DefinedCharNode node) {
        return this.getFrom() < node.getFrom() && node.getFrom() <= this.getTo() && this.getTo() < node.getTo() || node.getFrom() < this.getFrom() && this.getFrom() <= node.getTo() && node.getTo() < this.getTo();
    }

    public boolean subsumes(DefinedCharNode node) {
        return this.getFrom() <= node.getFrom() && node.getTo() <= this.getTo();
    }

    public abstract String toInlinedString();
}

