/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.regexparser.DefinedCharNode;
import net.amygdalum.regexparser.RangeCharNode;
import net.amygdalum.regexparser.RegexNode;
import net.amygdalum.util.text.CharUtils;

public abstract class CharNode
implements RegexNode {
    public abstract List<DefinedCharNode> toCharNodes();

    @Override
    public CharNode clone() {
        try {
            return (CharNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static List<DefinedCharNode> computeComplement(List<? extends DefinedCharNode> nodes, List<DefinedCharNode> allnodes) {
        LinkedList<DefinedCharNode> remainderNodes = new LinkedList<DefinedCharNode>();
        if (allnodes.isEmpty()) {
            return remainderNodes;
        }
        Collections.sort(nodes);
        Collections.sort(allnodes);
        Iterator<DefinedCharNode> allnodeIterator = allnodes.iterator();
        DefinedCharNode currentRange = allnodeIterator.next();
        for (DefinedCharNode definedCharNode : nodes) {
            while (!definedCharNode.cuts(currentRange) && allnodeIterator.hasNext()) {
                remainderNodes.add(currentRange);
                currentRange = allnodeIterator.next();
            }
            if (!definedCharNode.cuts(currentRange)) continue;
            if (currentRange.getFrom() < definedCharNode.getFrom()) {
                remainderNodes.add(new RangeCharNode(currentRange.getFrom(), CharUtils.before((char)definedCharNode.getFrom())));
            }
            if (definedCharNode.getTo() < currentRange.getTo()) {
                currentRange = new RangeCharNode(CharUtils.after((char)definedCharNode.getTo()), currentRange.getTo());
                continue;
            }
            if (allnodeIterator.hasNext()) {
                currentRange = allnodeIterator.next();
                continue;
            }
            currentRange = null;
            break;
        }
        while (allnodeIterator.hasNext()) {
            remainderNodes.add(currentRange);
            currentRange = allnodeIterator.next();
        }
        if (currentRange != null) {
            remainderNodes.add(currentRange);
        }
        return remainderNodes;
    }
}

