/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.amygdalum.regexparser.AbstractCharClassNode;
import net.amygdalum.regexparser.CharNode;
import net.amygdalum.regexparser.RangeCharNode;
import net.amygdalum.regexparser.SpecialCharClassNode;

public class CharClassBuilder {
    private char min;
    private char max;
    private Map<Character, CharNode> charClasses = new LinkedHashMap<Character, CharNode>();

    public CharClassBuilder(char min, char max) {
        this.min = min;
        this.max = max;
    }

    public CharClassBuilder add(char symbol, CharNode node) {
        this.charClasses.put(Character.valueOf(symbol), node);
        return this;
    }

    public CharClassBuilder add(SpecialCharClassNode specialCharClass) {
        this.charClasses.put(Character.valueOf(specialCharClass.getSymbol()), specialCharClass);
        AbstractCharClassNode invertedCharClass = specialCharClass.invert((List)Arrays.asList(new RangeCharNode(this.min, this.max)));
        this.charClasses.put(Character.valueOf(((SpecialCharClassNode)invertedCharClass).getSymbol()), invertedCharClass);
        return this;
    }

    public Map<Character, CharNode> build() {
        return this.charClasses;
    }
}

