/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.regexparser;

import java.util.Arrays;
import java.util.List;
import net.amygdalum.regexparser.CharNode;
import net.amygdalum.regexparser.DefinedCharNode;
import net.amygdalum.regexparser.RangeCharNode;
import net.amygdalum.regexparser.RegexNodeVisitor;
import net.amygdalum.regexparser.SingleCharNode;

public class AnyCharNode
extends CharNode {
    private List<DefinedCharNode> charNodes;

    private AnyCharNode(DefinedCharNode ... charNodes) {
        this(Arrays.asList(charNodes));
    }

    private AnyCharNode(List<DefinedCharNode> charNodes) {
        this.charNodes = charNodes;
    }

    public static AnyCharNode dotAll(char min, char max) {
        return new AnyCharNode(new RangeCharNode(min, max));
    }

    public static AnyCharNode dotDefault(char min, char max) {
        return new AnyCharNode(AnyCharNode.computeDefault(min, max));
    }

    private static DefinedCharNode[] computeDefault(char min, char max) {
        return AnyCharNode.computeComplement(Arrays.asList(new SingleCharNode('\n'), new SingleCharNode('\r'), new SingleCharNode('\u0085'), new RangeCharNode('\u2028', '\u2029')), Arrays.asList(new RangeCharNode(min, max))).toArray(new DefinedCharNode[0]);
    }

    @Override
    public List<DefinedCharNode> toCharNodes() {
        return this.charNodes;
    }

    @Override
    public <T> T accept(RegexNodeVisitor<T> visitor) {
        return visitor.visitAnyChar(this);
    }

    @Override
    public AnyCharNode clone() {
        return (AnyCharNode)super.clone();
    }

    public String toString() {
        return ".";
    }
}

