/*
 * Decompiled with CFR 0.152.
 */
package net.amrhassan.sqlbuilder.restrictions;

import java.util.Arrays;
import java.util.Collection;
import net.amrhassan.sqlbuilder.SelectSqlStatement;
import net.amrhassan.sqlbuilder.restrictions.AndSqlRestriction;
import net.amrhassan.sqlbuilder.restrictions.BetweenSqlRestriction;
import net.amrhassan.sqlbuilder.restrictions.EqualsSqlRestriction;
import net.amrhassan.sqlbuilder.restrictions.GreaterThanOrEqualSqlRestriction;
import net.amrhassan.sqlbuilder.restrictions.GreaterThanSqlRestriction;
import net.amrhassan.sqlbuilder.restrictions.InSqlRestriction;
import net.amrhassan.sqlbuilder.restrictions.LessThanOrEqualSqlRestriction;
import net.amrhassan.sqlbuilder.restrictions.LessThanSqlRestriction;
import net.amrhassan.sqlbuilder.restrictions.SqlRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlRestrictions {
    private SqlRestrictions() {
    }

    public static SqlRestriction eq(String field) {
        return new EqualsSqlRestriction(field, "?");
    }

    public static SqlRestriction eq(String lhs, String rhs) {
        return new EqualsSqlRestriction(lhs, rhs);
    }

    public static SqlRestriction and(SqlRestriction ... restrictions) {
        return new AndSqlRestriction(Arrays.asList(restrictions));
    }

    public static SqlRestriction and(Collection<SqlRestriction> restrictions) {
        if (restrictions.isEmpty()) {
            return null;
        }
        return new AndSqlRestriction(restrictions);
    }

    public static SqlRestriction between(String field) {
        return new BetweenSqlRestriction(field, "?", "?");
    }

    public static SqlRestriction between(String field, String lowerBound, String upperBound) {
        return new BetweenSqlRestriction(field, lowerBound, upperBound);
    }

    public static SqlRestriction in(String field, int operandCount) {
        Object[] values = new String[operandCount];
        Arrays.fill(values, "?");
        return new InSqlRestriction(field, (String[])values);
    }

    public static SqlRestriction in(String field, SelectSqlStatement selectStatement) {
        return new InSqlRestriction(field, new String[]{selectStatement.toString()});
    }

    public static SqlRestriction lte(String field) {
        return new LessThanOrEqualSqlRestriction(field, "?");
    }

    public static SqlRestriction lt(String field) {
        return new LessThanSqlRestriction(field, "?");
    }

    public static SqlRestriction gte(String field) {
        return new GreaterThanOrEqualSqlRestriction(field, "?");
    }

    public static SqlRestriction gt(String field) {
        return new GreaterThanSqlRestriction(field, "?");
    }
}

