/* 
 * Copyright (c) 2013 Amr Hassan <amr.hassan@gmail.com>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining 
 * a copy of this software and associated documentation files (the 
 * "Software"), to deal in the Software without restriction, including 
 * without limitation the rights to use, copy, modify, merge, publish, 
 * distribute, sublicense, and/or sell copies of the Software, and to 
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be 
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


package net.amrhassan.sqlbuilder.sources;

import net.amrhassan.sqlbuilder.restrictions.SqlRestriction;

final class JoinSqlSource implements SqlSource {
	
	private SqlSource source1, source2;
	private SqlRestriction restriction;
	private Type type;
	
	enum Type {
		INNER, LEFT, RIGHT, FULL;
	}
	
	JoinSqlSource(Type type, SqlSource source1, SqlSource source2, SqlRestriction restriction) {
		this.type = type;
		this.source1 = source1;
		this.source2 = source2;
		this.restriction = restriction;
	}
	
	JoinSqlSource(SqlSource source1, SqlSource source2, SqlRestriction restriction) {
		this(Type.INNER, source1, source2, restriction);
	}
	
	@Override
	public String toString() {
		
		String joinPhrase = null;
		
		if (type == Type.INNER)
			joinPhrase = "JOIN";
		else if (type == Type.LEFT)
			joinPhrase = "LEFT JOIN";
		else if (type == Type.RIGHT)
			joinPhrase = "RIGHT JOIN";
		else if (type == Type.FULL)
			joinPhrase = "FULL JOIN";
		
		return String.format("(%s %s %s ON (%s))",
				source1, joinPhrase, source2, restriction);
	}
}
