/*
 * Decompiled with CFR 0.152.
 */
package net.amrhassan.sqlbuilder.sources;

import net.amrhassan.sqlbuilder.restrictions.SqlRestriction;
import net.amrhassan.sqlbuilder.sources.SqlSource;

final class JoinSqlSource
implements SqlSource {
    private SqlSource source1;
    private SqlSource source2;
    private SqlRestriction restriction;
    private Type type;

    JoinSqlSource(Type type, SqlSource source1, SqlSource source2, SqlRestriction restriction) {
        this.type = type;
        this.source1 = source1;
        this.source2 = source2;
        this.restriction = restriction;
    }

    JoinSqlSource(SqlSource source1, SqlSource source2, SqlRestriction restriction) {
        this(Type.INNER, source1, source2, restriction);
    }

    public String toString() {
        String joinPhrase = null;
        if (this.type == Type.INNER) {
            joinPhrase = "JOIN";
        } else if (this.type == Type.LEFT) {
            joinPhrase = "LEFT JOIN";
        } else if (this.type == Type.RIGHT) {
            joinPhrase = "RIGHT JOIN";
        } else if (this.type == Type.FULL) {
            joinPhrase = "FULL JOIN";
        }
        return String.format("(%s %s %s ON (%s))", this.source1, joinPhrase, this.source2, this.restriction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

