/*
 * Decompiled with CFR 0.152.
 */
package net.amrhassan.sqlbuilder.sources;

import net.amrhassan.sqlbuilder.restrictions.SqlRestriction;
import net.amrhassan.sqlbuilder.sources.SqlSource;
import net.amrhassan.sqlbuilder.sources.TableSqlSource;

final class JoinSqlSource
implements SqlSource {
    private TableSqlSource table1;
    private TableSqlSource table2;
    private SqlRestriction restriction;
    private Type type;

    JoinSqlSource(Type type, TableSqlSource table1, TableSqlSource table2, SqlRestriction restriction) {
        this.type = type;
        this.table1 = table1;
        this.table2 = table2;
        this.restriction = restriction;
    }

    JoinSqlSource(TableSqlSource table1, TableSqlSource table2, SqlRestriction restriction) {
        this.type = Type.INNER;
        this.table1 = table1;
        this.table2 = table2;
        this.restriction = restriction;
    }

    public String toString() {
        String joinPhrase = null;
        if (this.type == Type.INNER) {
            joinPhrase = "JOIN";
        } else if (this.type == Type.LEFT) {
            joinPhrase = "LEFT JOIN";
        } else if (this.type == Type.RIGHT) {
            joinPhrase = "RIGHT JOIN";
        } else if (this.type == Type.FULL) {
            joinPhrase = "FULL JOIN";
        }
        return String.format("%s %s %s ON (%s)", this.table1, joinPhrase, this.table2, this.restriction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

