/*
 * Decompiled with CFR 0.152.
 */
package net.amrhassan.sqlbuilder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.amrhassan.sqlbuilder.SqlStatement;
import net.amrhassan.sqlbuilder.restrictions.SqlRestriction;
import net.amrhassan.sqlbuilder.sources.SqlSource;
import net.amrhassan.sqlbuilder.utils.StringUtils;

public final class SelectSqlStatement
implements SqlStatement {
    private boolean distinct = false;
    private List<String> fields = new LinkedList<String>();
    private List<SqlSource> sources = new LinkedList<SqlSource>();
    private SqlRestriction restriction;
    private List<String> orderByFields = new LinkedList<String>();
    private Order order;
    private List<String> groupByFields = new LinkedList<String>();

    public void enableDistinct() {
        this.distinct = true;
    }

    public void disableDistinct() {
        this.distinct = false;
    }

    public void addSource(SqlSource source) {
        this.sources.add(source);
    }

    public void addFieldAs(String name, String alias) {
        this.fields.add(String.format("%s AS %s", name, alias));
    }

    public void addFields(String ... names) {
        for (String name : names) {
            this.fields.add(name);
        }
    }

    public void addOrderBy(String ... fields) {
        this.orderByFields.addAll(Arrays.asList(fields));
    }

    public void addOrderBy(Order order, String ... fields) {
        this.addOrderBy(fields);
        this.order = order;
    }

    public void addGroupByFields(String ... fields) {
        for (String field : fields) {
            this.groupByFields.add(field);
        }
    }

    public void setRestriction(SqlRestriction restriction) {
        this.restriction = restriction;
    }

    public String toString() {
        LinkedList<String> segments = new LinkedList<String>();
        segments.add("SELECT");
        if (this.distinct) {
            segments.add("DISTINCT");
        }
        segments.add(StringUtils.join(", ", this.fields));
        segments.add("FROM");
        segments.add(StringUtils.join(", ", this.sources));
        if (this.restriction != null) {
            segments.add("WHERE");
            segments.add(this.restriction.toString());
        }
        if (!this.orderByFields.isEmpty()) {
            segments.add("ORDER BY");
            segments.add(StringUtils.join(", ", this.orderByFields));
            if (this.order != null) {
                if (this.order == Order.DESCENDING) {
                    segments.add("DESC");
                } else {
                    segments.add("ASC");
                }
            }
        }
        if (!this.groupByFields.isEmpty()) {
            segments.add("GROUP BY");
            segments.add(StringUtils.join(", ", this.groupByFields));
        }
        return StringUtils.join(" ", segments) + ";";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        ASCENDING,
        DESCENDING;

    }
}

