package net.amrhassan.sqlbuilder.utils;

import java.util.Arrays;
import java.util.Collection;

/**
 * Helper utility class that is used internally by the sqlbuilder
 * sub-packages
 *
 */
public final class StringUtils {
	
	private StringUtils() {
		// Private constructor to prevent instantiation
	}
	
	/**
	 * Join the String representation of several objects with by the separator
	 * String in between them.
	 * 
	 * The Object.toString() method will be used to obtain the String representation
	 * of each object.
	 */
	public static <T> String join(String separator, T... objects) {
		return join(separator, Arrays.asList(objects));
	}
	
	/**
	 * Join the String representation of several objects with by the separator
	 * String in between them.
	 * 
	 * The Object.toString() method will be used to obtain the String representation
	 * of each object.
	 */
	public static <T> String join(String separator, Collection<T> objects) {
		StringBuilder builder = new StringBuilder();
		
		int i = 0;
		for (T object : objects) {
			builder.append(object.toString());
			
			if (i++ != (objects.size() - 1))
				builder.append(separator);
		}
		
		return builder.toString();
	}
}
