/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.ml.prediction;

import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.matrices.ml.AbstractMLPredict;
import net.algart.executors.modules.opencv.matrices.ml.MLKind;
import net.algart.executors.modules.opencv.matrices.ml.MLPredictor;
import net.algart.executors.modules.opencv.matrices.ml.MLSamplesType;

public final class MLPredict
extends AbstractMLPredict {
    private MLKind.StatModelBased defaultPredictor = MLKind.StatModelBased.SVM;

    private MLPredict(MLSamplesType samplesType) {
        super(samplesType);
    }

    public static MLPredict newPredictNumbers() {
        return new MLPredict(MLSamplesType.NUMBERS);
    }

    public static MLPredict newPredictPixels() {
        return new MLPredict(MLSamplesType.PIXELS);
    }

    public MLKind.StatModelBased getDefaultPredictor() {
        return this.defaultPredictor;
    }

    public MLPredict setDefaultPredictor(MLKind.StatModelBased defaultPredictor) {
        this.defaultPredictor = (MLKind.StatModelBased)MLPredict.nonNull((Object)defaultPredictor);
        return this;
    }

    public boolean isPredictionDTreesSum() {
        return this.getPredictionFlagByMask(256);
    }

    public MLPredict setPredictionDTreesSum(boolean predictionDTreesSum) {
        this.setPredictionFlagByMask(256, predictionDTreesSum);
        return this;
    }

    public boolean isPredictionDTreesMaxVote() {
        return this.getPredictionFlagByMask(512);
    }

    public MLPredict setPredictionDTreesMaxVote(boolean predictionDTreesMaxVote) {
        this.setPredictionFlagByMask(512, predictionDTreesMaxVote);
        return this;
    }

    public void process() {
        try (MLPredictor predictor = this.readStandardPredictor(this.defaultPredictor);){
            this.setPredictionFlags(predictor);
            this.predict(predictor);
        }
    }

    public static SNumbers predict(MLPredictor predictor, SNumbers samples, boolean selectIndexesOfMaximalResponses, boolean useGPU) {
        try (MLPredict predict = MLPredict.newPredictNumbers();){
            predict.setSelectIndexesOfMaximalResponses(selectIndexesOfMaximalResponses);
            predict.setUseGPU(useGPU);
            SNumbers sNumbers = predict.predictNumbers(predictor, samples);
            return sNumbers;
        }
    }

    public static SMat predict(MLPredictor predictor, SMat samples, boolean selectIndexesOfMaximalResponses, boolean useGPU) {
        try (MLPredict predict = MLPredict.newPredictPixels();){
            predict.setSelectIndexesOfMaximalResponses(selectIndexesOfMaximalResponses);
            predict.setUseGPU(useGPU);
            SMat sMat = predict.predictPixels(predictor, samples);
            return sMat;
        }
    }
}

