/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessorForFloat;
import net.algart.executors.modules.cv.matrices.objects.labels.SingleObjectProcessor;

abstract class LabelledObjectsProcessorForFloat1Channels
extends LabelledObjectsProcessorForFloat {
    LabelledObjectsProcessorForFloat1Channels(int[] lists, int[] listHeads, SingleObjectProcessor processor) {
        super(lists, listHeads, processor, 1);
    }

    static class ForDoubles
    extends LabelledObjectsProcessorForFloat1Channels {
        private final double[] data;

        public ForDoubles(int[] lists, int[] listHeads, SingleObjectProcessor processor, double[] data) {
            super(lists, listHeads, processor);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForDoubles.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                    }
                    objectData0[pixelCount++] = (float)this.data[index];
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForFloats
    extends LabelledObjectsProcessorForFloat1Channels {
        private final float[] data;

        public ForFloats(int[] lists, int[] listHeads, SingleObjectProcessor processor, float[] data) {
            super(lists, listHeads, processor);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForFloats.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                    }
                    objectData0[pixelCount++] = this.data[index];
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForInts
    extends LabelledObjectsProcessorForFloat1Channels {
        private final int[] data;

        public ForInts(int[] lists, int[] listHeads, SingleObjectProcessor processor, int[] data) {
            super(lists, listHeads, processor);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForInts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                    }
                    objectData0[pixelCount++] = this.data[index];
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForShorts
    extends LabelledObjectsProcessorForFloat1Channels {
        private final short[] data;

        public ForShorts(int[] lists, int[] listHeads, SingleObjectProcessor processor, short[] data) {
            super(lists, listHeads, processor);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForShorts.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                    }
                    objectData0[pixelCount++] = this.data[index] & 0xFFFF;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForBytes
    extends LabelledObjectsProcessorForFloat1Channels {
        private final byte[] data;

        public ForBytes(int[] lists, int[] listHeads, SingleObjectProcessor processor, byte[] data) {
            super(lists, listHeads, processor);
            this.data = data;
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int label;
            float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            int labelMax = label + count;
            for (label = p; label < labelMax; ++label) {
                int index = this.listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ForBytes.ensureCapacityForPixels(objectData, this.lists.length, pixelCount);
                        objectData0 = objectData[0];
                    }
                    objectData0[pixelCount++] = this.data[index] & 0xFF;
                    index = this.lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }
}

