/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.arrays.Array;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundariesScanner;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.SimpleIntPseudoStack;
import net.algart.matrices.scanning.Boundary2DScanner;

class LabelsDrawer {
    private final BoundariesScanner scanner;
    private final Boundary2DScanner boundaryScanner;
    private final int[] labels;
    private final byte[] brackets;
    private final int dimX;
    private final int dimY;

    LabelsDrawer(BoundariesScanner scanner) {
        Matrix<? extends PFixedArray> scannedMatrix = scanner.objects();
        if (scannedMatrix.size() > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Cannot create labels for " + scannedMatrix + ": it is too large");
        }
        this.scanner = scanner;
        this.boundaryScanner = scanner.getBoundaryScanner();
        this.dimX = (int)scannedMatrix.dimX();
        this.dimY = (int)scannedMatrix.dimY();
        this.labels = new int[scannedMatrix.size32()];
        this.brackets = new byte[this.labels.length];
    }

    LabelsDrawer(long dimX, long dimY) {
        if (dimX < 0L || dimY < 0L) {
            throw new IllegalArgumentException("Negative dimX or dimY");
        }
        if (dimX > Integer.MAX_VALUE || dimY > Integer.MAX_VALUE || dimX * dimY > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Cannot create labels for matrix " + dimX + "x" + dimY + ": it is too large");
        }
        this.scanner = null;
        this.boundaryScanner = null;
        this.dimX = (int)dimX;
        this.dimY = (int)dimY;
        this.labels = new int[(int)(dimX * dimY)];
        this.brackets = new byte[this.labels.length];
    }

    public int dimX() {
        return this.dimX;
    }

    public int dimY() {
        return this.dimY;
    }

    void drawBracket(long objectLabel, boolean internalBoundary) {
        this.drawBracket(objectLabel, (int)this.boundaryScanner.currentIndexInArray(), this.boundaryScanner.side(), internalBoundary);
    }

    void drawBracket(long objectLabel, int currentIndexInArray, Boundary2DScanner.Side side, boolean internalBoundary) {
        assert (objectLabel >= 0L);
        if (objectLabel < Integer.MAX_VALUE) {
            int value = (int)objectLabel + 1;
            if (!internalBoundary) {
                switch (side) {
                    case X_MINUS: {
                        this.setOpeningBracket(currentIndexInArray, value);
                        break;
                    }
                    case X_PLUS: {
                        this.setClosingBracket(currentIndexInArray, value);
                    }
                }
            } else {
                switch (side) {
                    case X_MINUS: {
                        assert (this.boundaryScanner == null || this.boundaryScanner.x() > 0L);
                        this.setClosingBracket(currentIndexInArray - 1, value);
                        break;
                    }
                    case X_PLUS: {
                        this.setOpeningBracket(currentIndexInArray + 1, value);
                    }
                }
            }
        }
    }

    void buildLabels() {
        int dimX = this.dimX;
        int dimY = this.dimY;
        SimpleIntPseudoStack pseudoStack = new SimpleIntPseudoStack(dimX);
        int disp = 0;
        for (int y = 0; y < dimY; ++y) {
            int filler = 0;
            int x = 0;
            while (x < dimX) {
                if (this.isNoBrackets(disp)) {
                    this.labels[disp] = filler;
                } else if (this.isOnlyOpeningBracket(disp)) {
                    filler = this.getValue(disp);
                    pseudoStack.push(filler);
                } else if (this.isOnlyClosingBracket(disp)) {
                    filler = pseudoStack.remove(this.getValue(disp), 0);
                }
                ++x;
                ++disp;
            }
            assert (pseudoStack.size() == 0) : "unbalanced brackets (line " + y + ")";
        }
    }

    Matrix<? extends PArray> getLabels() {
        return Matrices.matrix((Array)IntArray.as((int[])this.labels), (long[])new long[]{this.dimX, this.dimY});
    }

    void debuggingPrintLabels() {
        int disp = 0;
        for (int y = 0; y < this.dimY; ++y) {
            System.out.printf("%n~~y=%-3d", y);
            int x = 0;
            while (x < this.dimX) {
                System.out.printf(" %3d%s", this.getValue(disp), this.labels[disp] < 0 ? "]" : " ");
                ++x;
                ++disp;
            }
        }
        System.out.println();
    }

    private void setOpeningBracket(int index, int value) {
        int previous = this.labels[index];
        assert (previous == 0 || previous == value) : "invalid " + previous + " and " + value + " at " + index;
        this.labels[index] = value;
        int n = index;
        this.brackets[n] = (byte)(this.brackets[n] | 1);
    }

    private void setClosingBracket(int index, int value) {
        int previous = this.labels[index];
        assert (previous == 0 || previous == value) : "invalid " + previous + " and " + value + " at " + index;
        this.labels[index] = value;
        int n = index;
        this.brackets[n] = (byte)(this.brackets[n] | 2);
    }

    private int getValue(int index) {
        return this.labels[index];
    }

    private boolean isNoBrackets(int index) {
        return this.brackets[index] == 0;
    }

    private boolean isOnlyOpeningBracket(int index) {
        return this.brackets[index] == 1;
    }

    private boolean isOnlyClosingBracket(int index) {
        return this.brackets[index] == 2;
    }
}

