/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelsAnalyser;
import net.algart.executors.modules.cv.matrices.objects.markers.PaintLabelledObjects;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class ValuesAtLabelledObjects
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_LABELS = "labels";
    public static final String INPUT_MASK = "mask";
    public static final String INPUT_LEVEL = "level";
    public static final String OUTPUT_PAINT_LABELLED = "paint_labelled";
    private static final boolean OPTIMIZE = true;
    private static final Map<String, ObjectParameter> OUTPUT_STATISTICS = new LinkedHashMap<String, ObjectParameter>();
    private boolean rawValues = false;
    private double[] lowPercentile = new double[]{0.2};
    private double[] highPercentile = new double[0];
    private double[] percentileA = new double[0];
    private double[] percentileB = new double[0];
    private double[] percentileC = new double[0];
    private boolean channelPercentiles = false;
    private int[] separateChannelPercentilesList = new int[0];
    private int levelChannel = 0;
    private ObjectParameter paintedParameter = ObjectParameter.MEAN;
    private boolean paintLabelledOnSource = false;
    private boolean visiblePaintLabelled = false;
    private final LabelsAnalyser analyser = new LabelsAnalyser();

    public ValuesAtLabelledObjects() {
        this.addInputMat(DEFAULT_INPUT_PORT);
        this.addInputMat(INPUT_LABELS);
        this.addInputMat(INPUT_MASK);
        this.addInputMat(INPUT_LEVEL);
        this.setDefaultOutputNumbers(ObjectParameter.MEAN.outputPort);
        for (ObjectParameter parameter : ObjectParameter.values()) {
            this.addOutputNumbers(parameter.outputPort);
        }
        this.addOutputMat(OUTPUT_PAINT_LABELLED);
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public ValuesAtLabelledObjects setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        return this;
    }

    public double[] getLowPercentile() {
        return (double[])this.lowPercentile.clone();
    }

    public ValuesAtLabelledObjects setLowPercentile(double ... lowPercentile) {
        this.lowPercentile = (double[])ValuesAtLabelledObjects.checkPercentileLevels(lowPercentile).clone();
        return this;
    }

    public ValuesAtLabelledObjects setLowPercentile(String lowPercentile) {
        return this.setLowPercentile(new SScalar((String)ValuesAtLabelledObjects.nonNull((Object)lowPercentile)).toDoubles());
    }

    public double[] getHighPercentile() {
        return (double[])this.highPercentile.clone();
    }

    public ValuesAtLabelledObjects setHighPercentile(double ... highPercentile) {
        this.highPercentile = (double[])ValuesAtLabelledObjects.checkPercentileLevels(highPercentile).clone();
        return this;
    }

    public ValuesAtLabelledObjects setHighPercentile(String highPercentile) {
        return this.setHighPercentile(new SScalar((String)ValuesAtLabelledObjects.nonNull((Object)highPercentile)).toDoubles());
    }

    public double[] getPercentileA() {
        return (double[])this.percentileA.clone();
    }

    public ValuesAtLabelledObjects setPercentileA(double[] percentileA) {
        this.percentileA = (double[])ValuesAtLabelledObjects.checkPercentileLevels(percentileA).clone();
        return this;
    }

    public ValuesAtLabelledObjects setPercentileA(String percentileA) {
        return this.setPercentileA(new SScalar((String)ValuesAtLabelledObjects.nonNull((Object)percentileA)).toDoubles());
    }

    public double[] getPercentileB() {
        return (double[])this.percentileB.clone();
    }

    public ValuesAtLabelledObjects setPercentileB(double[] percentileB) {
        this.percentileB = (double[])ValuesAtLabelledObjects.checkPercentileLevels(percentileB).clone();
        return this;
    }

    public ValuesAtLabelledObjects setPercentileB(String percentileB) {
        return this.setPercentileB(new SScalar((String)ValuesAtLabelledObjects.nonNull((Object)percentileB)).toDoubles());
    }

    public double[] getPercentileC() {
        return (double[])this.percentileC.clone();
    }

    public ValuesAtLabelledObjects setPercentileC(double[] percentileC) {
        this.percentileC = (double[])ValuesAtLabelledObjects.checkPercentileLevels(percentileC).clone();
        return this;
    }

    public ValuesAtLabelledObjects setPercentileC(String percentileC) {
        return this.setPercentileC(new SScalar((String)ValuesAtLabelledObjects.nonNull((Object)percentileC)).toDoubles());
    }

    public boolean isChannelPercentiles() {
        return this.channelPercentiles;
    }

    public ValuesAtLabelledObjects setChannelPercentiles(boolean channelPercentiles) {
        this.channelPercentiles = channelPercentiles;
        return this;
    }

    public int[] getSeparateChannelPercentilesList() {
        return (int[])this.separateChannelPercentilesList.clone();
    }

    public ValuesAtLabelledObjects setSeparateChannelPercentilesList(int[] separateChannelPercentilesList) {
        this.separateChannelPercentilesList = (int[])((int[])ValuesAtLabelledObjects.nonNull((Object)separateChannelPercentilesList)).clone();
        return this;
    }

    public ValuesAtLabelledObjects setSeparateChannelPercentilesList(String separateChannelPercentilesList) {
        return this.setSeparateChannelPercentilesList(new SScalar((String)ValuesAtLabelledObjects.nonNull((Object)separateChannelPercentilesList)).toInts());
    }

    public int getLevelChannel() {
        return this.levelChannel;
    }

    public ValuesAtLabelledObjects setLevelChannel(int levelChannel) {
        this.levelChannel = ValuesAtLabelledObjects.nonNegative((int)levelChannel);
        return this;
    }

    public ObjectParameter getPaintedParameter() {
        return this.paintedParameter;
    }

    public ValuesAtLabelledObjects setPaintedParameter(ObjectParameter paintedParameter) {
        this.paintedParameter = (ObjectParameter)((Object)ValuesAtLabelledObjects.nonNull((Object)((Object)paintedParameter)));
        return this;
    }

    public boolean isPaintLabelledOnSource() {
        return this.paintLabelledOnSource;
    }

    public ValuesAtLabelledObjects setPaintLabelledOnSource(boolean paintLabelledOnSource) {
        this.paintLabelledOnSource = paintLabelledOnSource;
        return this;
    }

    public boolean isVisiblePaintLabelled() {
        return this.visiblePaintLabelled;
    }

    public ValuesAtLabelledObjects setVisiblePaintLabelled(boolean visiblePaintLabelled) {
        this.visiblePaintLabelled = visiblePaintLabelled;
        return this;
    }

    public ValuesAtLabelledObjects requestPaintLabelled() {
        this.requestOutput(new String[]{OUTPUT_PAINT_LABELLED});
        return this;
    }

    public SMat resultPaintLabelled() {
        return this.getMat(OUTPUT_PAINT_LABELLED);
    }

    public void process() {
        MultiMatrix2D sourceMatrix = this.getInputMat().toMultiMatrix2D();
        MultiMatrix2D labelsMatrix = this.getInputMat(INPUT_LABELS).toMultiMatrix2D();
        MultiMatrix2D maskMatrix = this.getInputMat(INPUT_MASK, true).toMultiMatrix2D();
        Map<ObjectParameter, SNumbers> resultStatistics = ValuesAtLabelledObjects.convertMap(this.allOutputContainers(SNumbers.class, true));
        this.setStartProcessingTimeStamp();
        this.analyse(resultStatistics, sourceMatrix, labelsMatrix, maskMatrix);
        for (Map.Entry<ObjectParameter, SNumbers> result : resultStatistics.entrySet()) {
            this.getNumbers(result.getKey().outputPort).setTo(result.getValue());
        }
        this.setEndProcessingTimeStamp();
    }

    public void analyse(Map<ObjectParameter, SNumbers> results, MultiMatrix2D sourceMatrix, MultiMatrix2D labelsMatrix, MultiMatrix2D maskMatrix) {
        this.analyse(results, sourceMatrix, labelsMatrix, maskMatrix, this.getInputMat(INPUT_LEVEL, true).toMultiMatrix2D());
    }

    public void analyse(Map<ObjectParameter, SNumbers> results, MultiMatrix2D sourceMatrix, MultiMatrix2D labelsMatrix, MultiMatrix2D maskMatrix, MultiMatrix2D levelMatrix) {
        long t2;
        Objects.requireNonNull(sourceMatrix, "Null source");
        Objects.requireNonNull(labelsMatrix, "Null labels");
        long t1 = ValuesAtLabelledObjects.debugTime();
        sourceMatrix.checkDimensionEquality((MultiMatrix)labelsMatrix, "source", INPUT_LABELS);
        sourceMatrix.checkDimensionEquality((MultiMatrix)maskMatrix, "source", INPUT_MASK);
        sourceMatrix.checkDimensionEquality((MultiMatrix)levelMatrix, "source", INPUT_LEVEL);
        boolean paintLabelledRequested = this.isOutputNecessary(OUTPUT_PAINT_LABELLED);
        if (paintLabelledRequested) {
            results.putIfAbsent(this.paintedParameter, new SNumbers());
        }
        HashMap<ObjectParameter, Integer> percentileIndexes = new HashMap<ObjectParameter, Integer>();
        double[][] percentileLevelsByChannels = this.percentileLevels(results, sourceMatrix.numberOfChannels(), percentileIndexes);
        boolean needPercentiles = percentileLevelsByChannels[0].length > 0;
        boolean channelPercentiles = this.channelPercentiles || levelMatrix == null && sourceMatrix.isMono();
        int numberOfChannels = sourceMatrix.numberOfChannels();
        this.analyser.setLabels(labelsMatrix, maskMatrix);
        if (needPercentiles && !channelPercentiles) {
            if (levelMatrix == null) {
                levelMatrix = sourceMatrix;
            }
            Matrix levels = levelMatrix.channel(Math.min(this.levelChannel, levelMatrix.numberOfChannels() - 1));
            this.analyser.setImageAndLevelMatrix(sourceMatrix, (Matrix<? extends PArray>)levels, this.rawValues);
            this.analyser.setSeparateChannelPercentilesSet(this.separateChannelPercentilesSet(sourceMatrix));
        } else {
            this.analyser.setImage(sourceMatrix, this.rawValues);
        }
        long t3 = t2 = ValuesAtLabelledObjects.debugTime();
        if (results.containsKey((Object)ObjectParameter.STANDARD_DEVIATION) || results.containsKey((Object)ObjectParameter.MEAN_SQUARE)) {
            this.analyser.findMeansAndStandardDeviationsAndCardinalities();
        } else if (results.containsKey((Object)ObjectParameter.MEAN)) {
            this.analyser.findMeansAndCardinalities();
        }
        if (needPercentiles) {
            this.analyser.setPercentileLevelByChannels(percentileLevelsByChannels);
            this.analyser.setNeedTruncatedMeans(results.containsKey((Object)ObjectParameter.TRUNCATED_MEAN));
            this.analyser.setLowTruncatedMeanIndex(0);
            this.analyser.setHighTruncatedMeanIndex(Math.min(1, percentileLevelsByChannels[0].length - 1));
            this.analyser.prepareLists();
            t3 = ValuesAtLabelledObjects.debugTime();
            this.analyser.findPercentilesAndCardinalities();
        }
        if (results.containsKey((Object)ObjectParameter.FIRST_NON_ZERO)) {
            this.analyser.findFirstNonZeroPixels();
        }
        if (!this.analyser.isReadyCardinalities() && results.containsKey((Object)ObjectParameter.CARDINALITY)) {
            this.analyser.findCardinalities();
        }
        long t4 = ValuesAtLabelledObjects.debugTime();
        if (results.containsKey((Object)ObjectParameter.CARDINALITY)) {
            assert (this.analyser.isReadyCardinalities());
            results.get((Object)ObjectParameter.CARDINALITY).setTo(this.analyser.cardinalities(), 1);
        }
        if (results.containsKey((Object)ObjectParameter.MEAN)) {
            assert (this.analyser.isReadySums());
            results.get((Object)ObjectParameter.MEAN).setTo(this.analyser.means(), numberOfChannels);
        }
        if (results.containsKey((Object)ObjectParameter.MEAN_SQUARE)) {
            assert (this.analyser.isReadySumsOfSquares());
            results.get((Object)ObjectParameter.MEAN_SQUARE).setTo(this.analyser.meanSquares(), numberOfChannels);
        }
        if (results.containsKey((Object)ObjectParameter.STANDARD_DEVIATION)) {
            assert (this.analyser.isReadySumsOfSquares());
            results.get((Object)ObjectParameter.STANDARD_DEVIATION).setTo(this.analyser.standardDeviations(), numberOfChannels);
        }
        if (needPercentiles) {
            assert (this.analyser.isReadyPercentiles());
            for (ObjectParameter percentileParameter : ObjectParameter.ALL_PERCENTILES) {
                Integer levelIndex = (Integer)percentileIndexes.get((Object)percentileParameter);
                if (levelIndex == null) continue;
                ValuesAtLabelledObjects.setResultTo(results, percentileParameter, this.analyser.groupedPercentilesByLevel(levelIndex), numberOfChannels);
            }
            if (results.containsKey((Object)ObjectParameter.PERCENTILES_RANGE)) {
                ValuesAtLabelledObjects.setResultTo(results, ObjectParameter.PERCENTILES_RANGE, this.analyser.percentilesRange(0, 1), numberOfChannels);
            }
            ValuesAtLabelledObjects.setResultTo(results, ObjectParameter.TRUNCATED_MEAN, this.analyser.truncatedMeans(), numberOfChannels);
        }
        if (results.containsKey((Object)ObjectParameter.FIRST_NON_ZERO)) {
            assert (this.analyser.isReadyFirstNonZeroInformation());
            if (this.rawValues) {
                results.get((Object)ObjectParameter.FIRST_NON_ZERO).setToArray(this.analyser.firstNonZeroValues(), numberOfChannels);
            } else {
                results.get((Object)ObjectParameter.FIRST_NON_ZERO).setTo(this.analyser.firstNonZeroFloatValues(true), numberOfChannels);
            }
        }
        long t5 = ValuesAtLabelledObjects.debugTime();
        if (LOGGABLE_DEBUG) {
            ValuesAtLabelledObjects.logDebug((String)String.format(Locale.US, "Values at %d labelled objects at %s calculated in %.3f ms: %.3f reading/masking matrices, %.3f processing labels%s, %.3f making results %s", this.analyser.maxLabel(), sourceMatrix, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t4 - t2) * 1.0E-6, needPercentiles ? String.format(Locale.US, " (%.3f for lists + %.3f for %d percentiles: [%s])", (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, percentileIndexes.size(), ValuesAtLabelledObjects.percentileLevelsToString(percentileLevelsByChannels)) : "", (double)(t5 - t4) * 1.0E-6, results.keySet()));
        }
        if (paintLabelledRequested) {
            this.getMat(OUTPUT_PAINT_LABELLED).setTo((MultiMatrix)ValuesAtLabelledObjects.paintLabelledObjects(results.get((Object)this.paintedParameter), sourceMatrix, labelsMatrix, null, this.paintedParameter == ObjectParameter.CARDINALITY, this.paintLabelledOnSource));
        }
    }

    private void analyseStable(Map<ObjectParameter, SNumbers> results, MultiMatrix2D sourceMatrix, MultiMatrix2D labelsMatrix, MultiMatrix2D maskMatrix, MultiMatrix2D levelMatrix) {
        int k;
        float[][] values;
        int channelIndex;
        float[] result;
        Objects.requireNonNull(sourceMatrix, "Null source");
        Objects.requireNonNull(labelsMatrix, "Null labels");
        sourceMatrix.checkDimensionEquality((MultiMatrix)labelsMatrix, "source", INPUT_LABELS);
        sourceMatrix.checkDimensionEquality((MultiMatrix)maskMatrix, "source", INPUT_MASK);
        sourceMatrix.checkDimensionEquality((MultiMatrix)levelMatrix, "source", INPUT_LEVEL);
        boolean paintLabelledRequested = this.isOutputNecessary(OUTPUT_PAINT_LABELLED);
        if (paintLabelledRequested) {
            results.putIfAbsent(this.paintedParameter, new SNumbers());
        }
        if (this.lowPercentile.length == 0) {
            throw new IllegalArgumentException("At least one low percentile must be specified");
        }
        double lowPercentile = this.lowPercentile[0];
        double highPercentileCorrected = this.highPercentile.length == 0 ? 1.0 - lowPercentile : this.highPercentile[0];
        long t1 = ValuesAtLabelledObjects.debugTime();
        MultiMatrix2D maskedLabels = ValuesAtLabelledObjects.maskedLabels(labelsMatrix, maskMatrix);
        long t2 = ValuesAtLabelledObjects.debugTime();
        int numberOfChannels = sourceMatrix.numberOfChannels();
        double scale = this.rawValues ? 1.0 : 1.0 / sourceMatrix.maxPossibleValue();
        int[] labels = maskedLabels.channelToIntArray(0);
        long t3 = ValuesAtLabelledObjects.debugTime();
        int[] cardinalities = ValuesAtLabelledObjects.findLabelCardinalities(labels);
        if (results.containsKey((Object)ObjectParameter.CARDINALITY)) {
            results.get((Object)ObjectParameter.CARDINALITY).setTo(cardinalities, 1);
        }
        SNumbers.checkDimensions((long)labels.length, (long)numberOfChannels);
        long t4 = ValuesAtLabelledObjects.debugTime();
        if (results.containsKey((Object)ObjectParameter.MEAN)) {
            result = new float[numberOfChannels * cardinalities.length];
            for (channelIndex = 0; channelIndex < numberOfChannels; ++channelIndex) {
                values = ValuesAtLabelledObjects.splitByLabels(cardinalities, labels, sourceMatrix.channelToFloatArray(channelIndex));
                for (k = 0; k < values.length; ++k) {
                    result[k * numberOfChannels + channelIndex] = (float)(ValuesAtLabelledObjects.average(values[k]) * scale);
                }
            }
            results.get((Object)ObjectParameter.MEAN).setTo(result, numberOfChannels);
        }
        if (results.containsKey((Object)ObjectParameter.STANDARD_DEVIATION)) {
            result = new float[numberOfChannels * cardinalities.length];
            for (channelIndex = 0; channelIndex < numberOfChannels; ++channelIndex) {
                values = ValuesAtLabelledObjects.splitByLabels(cardinalities, labels, sourceMatrix.channelToFloatArray(channelIndex));
                for (k = 0; k < values.length; ++k) {
                    double average = ValuesAtLabelledObjects.average(values[k]);
                    double standardDeviation = ValuesAtLabelledObjects.standardDeviation(values[k], average);
                    result[k * numberOfChannels + channelIndex] = (float)(standardDeviation * scale);
                }
            }
            results.get((Object)ObjectParameter.STANDARD_DEVIATION).setTo(result, numberOfChannels);
        }
        if (results.containsKey((Object)ObjectParameter.LOW_PERCENTILE) || results.containsKey((Object)ObjectParameter.HIGH_PERCENTILE) || results.containsKey((Object)ObjectParameter.PERCENTILES_RANGE) || results.containsKey((Object)ObjectParameter.TRUNCATED_MEAN)) {
            if (!this.channelPercentiles) {
                levelMatrix = levelMatrix == null ? sourceMatrix.asMono() : levelMatrix.asMono();
            }
            float[] levels = this.channelPercentiles ? null : levelMatrix.channelToFloatArray(0);
            long t5 = ValuesAtLabelledObjects.debugTime();
            PercentilePairs levelsPercentiles = this.channelPercentiles ? null : new PercentilePairs(labels, cardinalities, levels, lowPercentile, highPercentileCorrected);
            long t6 = ValuesAtLabelledObjects.debugTime();
            Stream channelStream = Arrays.SystemSettings.cpuCount() == 1 ? sourceMatrix.allChannels().stream() : sourceMatrix.allChannels().parallelStream();
            List allChannelsResults = channelStream.map(m -> {
                float[][] values;
                float[] array = Matrices.toFloatJavaArray((Matrix)m);
                PercentilePairs percentiles = this.channelPercentiles ? new PercentilePairs(labels, cardinalities, array, lowPercentile, highPercentileCorrected) : levelsPercentiles;
                float[][] fArray = values = this.channelPercentiles ? percentiles.dataByLabels : ValuesAtLabelledObjects.splitByLabels(cardinalities, labels, array);
                assert (values.length == cardinalities.length);
                ChannelStatistics stat = new ChannelStatistics(cardinalities.length, results.keySet());
                for (int k = 0; k < values.length; ++k) {
                    double low = this.channelPercentiles ? percentiles.lowPercentiles[k] : ValuesAtLabelledObjects.averageEqual(percentiles.dataByLabels[k], percentiles.lowPercentiles[k], values[k]);
                    double high = this.channelPercentiles ? percentiles.highPercentiles[k] : ValuesAtLabelledObjects.averageEqual(percentiles.dataByLabels[k], percentiles.highPercentiles[k], values[k]);
                    stat.lowPercentiles[k] = (float)(low * scale);
                    stat.highPercentiles[k] = (float)(high * scale);
                    if (stat.percentilesRange != null) {
                        stat.percentilesRange[k] = (float)((high - low) * scale);
                    }
                    if (stat.truncatedMean == null) continue;
                    stat.truncatedMean[k] = (float)(ValuesAtLabelledObjects.averageInRange(percentiles.dataByLabels[k], percentiles.lowPercentiles[k], percentiles.highPercentiles[k], values[k]) * scale);
                }
                return stat;
            }).collect(Collectors.toList());
            long t7 = ValuesAtLabelledObjects.debugTime();
            for (ObjectParameter parameter : ChannelStatistics.calculatedParameters(results.keySet())) {
                SNumbers result2 = results.get((Object)parameter);
                if (result2 == null) {
                    result2 = new SNumbers();
                    results.put(parameter, result2);
                }
                float[] array = new float[numberOfChannels * cardinalities.length];
                for (int channelIndex2 = 0; channelIndex2 < numberOfChannels; ++channelIndex2) {
                    float[] channelArray = ((ChannelStatistics)allChannelsResults.get(channelIndex2)).result(parameter);
                    assert (channelArray != null);
                    for (int k2 = 0; k2 < cardinalities.length; ++k2) {
                        array[k2 * numberOfChannels + channelIndex2] = channelArray[k2];
                    }
                }
                result2.setTo(array, numberOfChannels);
            }
            long t8 = ValuesAtLabelledObjects.debugTime();
            ValuesAtLabelledObjects.logDebug(() -> String.format(Locale.US, "Values at %d labelled objects calculated in %.3f ms: %.3f masking, %.3f reading labels, %.3f counting labels, %.3f making level, %.3f splitting + sorting pixels, %.3f calculating statistics, %.3f making result", cardinalities.length, (double)(t8 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)(t6 - t5) * 1.0E-6, (double)(t7 - t6) * 1.0E-6, (double)(t8 - t7) * 1.0E-6));
        } else {
            long t5 = ValuesAtLabelledObjects.debugTime();
            ValuesAtLabelledObjects.logDebug(() -> String.format(Locale.US, "Values at %d labelled objects calculated in %.3f ms: %.3f masking, %.3f reading labels, %.3f counting labels, %.3f calculating statistics", cardinalities.length, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
        }
        if (results.containsKey((Object)ObjectParameter.FIRST_NON_ZERO)) {
            UpdatableBitArray nonZero = ((BitArray)sourceMatrix.nonZeroAnyChannelMatrix().array()).updatableClone((MemoryModel)net.algart.arrays.Arrays.SMM);
            if (this.rawValues && !sourceMatrix.isFloatingPoint()) {
                int[] result3 = new int[numberOfChannels * cardinalities.length];
                for (int channelIndex3 = 0; channelIndex3 < numberOfChannels; ++channelIndex3) {
                    int[] firstValues = ValuesAtLabelledObjects.firstNonZeroValueForLabels((BitArray)nonZero, cardinalities.length, labels, sourceMatrix.channelToIntArray(channelIndex3));
                    for (int k3 = 0; k3 < firstValues.length; ++k3) {
                        result3[k3 * numberOfChannels + channelIndex3] = firstValues[k3];
                    }
                }
                results.get((Object)ObjectParameter.FIRST_NON_ZERO).setTo(result3, numberOfChannels);
            } else {
                float[] result4 = new float[numberOfChannels * cardinalities.length];
                for (int channelIndex4 = 0; channelIndex4 < numberOfChannels; ++channelIndex4) {
                    float[] firstValues = ValuesAtLabelledObjects.firstNonZeroValueForLabels((BitArray)nonZero, cardinalities.length, labels, sourceMatrix.channelToFloatArray(channelIndex4));
                    for (int k4 = 0; k4 < firstValues.length; ++k4) {
                        result4[k4 * numberOfChannels + channelIndex4] = (float)((double)firstValues[k4] * scale);
                    }
                }
                results.get((Object)ObjectParameter.FIRST_NON_ZERO).setTo(result4, numberOfChannels);
            }
        }
        if (paintLabelledRequested) {
            this.getMat(OUTPUT_PAINT_LABELLED).setTo((MultiMatrix)ValuesAtLabelledObjects.paintLabelledObjects(results.get((Object)this.paintedParameter), sourceMatrix, labelsMatrix, null, this.paintedParameter == ObjectParameter.CARDINALITY, this.paintLabelledOnSource));
        }
    }

    public String visibleOutputPortName() {
        return this.visiblePaintLabelled ? OUTPUT_PAINT_LABELLED : this.paintedParameter.outputPort;
    }

    public static MultiMatrix2D paintLabelledObjects(SNumbers statistics, MultiMatrix2D sourceMatrix, MultiMatrix2D labelsMatrix, MultiMatrix2D maskMatrix, boolean intElementType, boolean paintLabelledOnSource) {
        return new PaintLabelledObjects().setRawValues(intElementType).setElementType(intElementType ? Integer.TYPE : sourceMatrix.elementType()).process(ValuesAtLabelledObjects.maskedLabels(labelsMatrix, maskMatrix), (MultiMatrix2D)(paintLabelledOnSource ? sourceMatrix : null), statistics);
    }

    private double[][] percentileLevels(Map<ObjectParameter, SNumbers> requested, int numberOfChannels, Map<ObjectParameter, Integer> levelIndexes) {
        boolean needRange = requested.containsKey((Object)ObjectParameter.PERCENTILES_RANGE);
        boolean needTruncatedMean = requested.containsKey((Object)ObjectParameter.TRUNCATED_MEAN);
        boolean needLowPercentile = requested.containsKey((Object)ObjectParameter.LOW_PERCENTILE);
        boolean needHighPercentile = requested.containsKey((Object)ObjectParameter.HIGH_PERCENTILE);
        double[][] result = new double[numberOfChannels][];
        for (int c = 0; c < numberOfChannels; ++c) {
            double[] levels = new double[16];
            int count = 0;
            if (needLowPercentile || needRange || needTruncatedMean) {
                levelIndexes.put(ObjectParameter.LOW_PERCENTILE, count);
                levels[count++] = ValuesAtLabelledObjects.percentileLevel(c, this.lowPercentile, "low percentile");
            }
            if (needHighPercentile || needRange || needTruncatedMean) {
                levelIndexes.put(ObjectParameter.HIGH_PERCENTILE, count);
                levels[count++] = ValuesAtLabelledObjects.percentileLevel(c, this.highPercentile, () -> 1.0 - ValuesAtLabelledObjects.percentileLevel(0, this.lowPercentile, "low percentile"));
            }
            if (requested.containsKey((Object)ObjectParameter.PERCENTILE_A)) {
                levelIndexes.put(ObjectParameter.PERCENTILE_A, count);
                levels[count++] = ValuesAtLabelledObjects.percentileLevel(c, this.percentileA, "percentile A");
            }
            if (requested.containsKey((Object)ObjectParameter.PERCENTILE_B)) {
                levelIndexes.put(ObjectParameter.PERCENTILE_B, count);
                levels[count++] = ValuesAtLabelledObjects.percentileLevel(c, this.percentileB, "percentile B");
            }
            if (requested.containsKey((Object)ObjectParameter.PERCENTILE_C)) {
                levelIndexes.put(ObjectParameter.PERCENTILE_C, count);
                levels[count++] = ValuesAtLabelledObjects.percentileLevel(c, this.percentileC, "percentile C");
            }
            result[c] = JArrays.copyOfRange((double[])levels, (int)0, (int)count);
        }
        return result;
    }

    private boolean[] separateChannelPercentilesSet(MultiMatrix2D sourceMatrix) {
        boolean[] result = new boolean[sourceMatrix.numberOfChannels()];
        for (int c : this.separateChannelPercentilesList) {
            if (c < 0 || c >= result.length) continue;
            result[c] = true;
        }
        return result;
    }

    private static String percentileLevelsToString(double[][] percentileLevels) {
        int count;
        StringBuilder sb = new StringBuilder();
        for (count = percentileLevels.length; count > 1 && Arrays.equals(percentileLevels[count - 2], percentileLevels[count - 1]); --count) {
        }
        for (int i = 0; i < count; ++i) {
            double[] levels = percentileLevels[i];
            if (i > 0) {
                sb.append("; ");
            }
            for (int j = 0; j < levels.length; ++j) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(levels[j]);
            }
        }
        if (count < percentileLevels.length) {
            sb.append(";...");
        }
        return sb.toString();
    }

    private static double[] checkPercentileLevels(double[] levels) {
        ValuesAtLabelledObjects.nonNull((Object)levels);
        for (double p : levels) {
            ValuesAtLabelledObjects.inRange((double)p, (double)0.0, (double)1.0);
        }
        return levels;
    }

    private static double percentileLevel(int channelIndex, double[] levels, Supplier<Double> defaultValue) {
        return channelIndex < levels.length ? levels[channelIndex] : (levels.length > 0 ? levels[levels.length - 1] : defaultValue.get());
    }

    private static double percentileLevel(int channelIndex, double[] levels, String percentileName) {
        if (levels.length > 0) {
            return ValuesAtLabelledObjects.percentileLevel(channelIndex, levels, () -> Double.NaN);
        }
        throw new IllegalArgumentException("At least one " + percentileName + " must be specified");
    }

    private static void setResultTo(Map<ObjectParameter, SNumbers> results, ObjectParameter parameter, float[] array, int numberOfChannels) {
        if (array == null) {
            return;
        }
        SNumbers result = results.get((Object)parameter);
        if (result == null) {
            result = new SNumbers();
            results.put(parameter, result);
        }
        result.setTo(array, numberOfChannels);
    }

    private static MultiMatrix2D maskedLabels(MultiMatrix2D labelsMatrix, MultiMatrix2D maskMatrix) {
        return maskMatrix != null ? labelsMatrix.min(maskMatrix.nonZeroPixels(false)) : labelsMatrix;
    }

    private static int[] findLabelCardinalities(int[] labels) {
        int resultLength = 0;
        for (int label : labels) {
            resultLength = Math.max(resultLength, label);
        }
        int[] cardinalities = new int[resultLength];
        for (int label : labels) {
            if (label <= 0) continue;
            int n = label - 1;
            cardinalities[n] = cardinalities[n] + 1;
        }
        return cardinalities;
    }

    private static float[] firstNonZeroValueForLabels(BitArray nonZero, int numberOfLabels, int[] labels, float[] values) {
        float[] result = new float[numberOfLabels];
        for (int i = labels.length - 1; i >= 0; --i) {
            int label = labels[i];
            if (label <= 0 || !nonZero.getBit((long)i)) continue;
            result[label - 1] = values[i];
        }
        return result;
    }

    private static int[] firstNonZeroValueForLabels(BitArray nonZero, int numberOfLabels, int[] labels, int[] values) {
        int[] result = new int[numberOfLabels];
        for (int i = labels.length - 1; i >= 0; --i) {
            int label = labels[i];
            if (label <= 0 || !nonZero.getBit((long)i)) continue;
            result[label - 1] = values[i];
        }
        return result;
    }

    private static float[][] splitByLabels(int[] cardinalities, int[] labels, float[] values) {
        float[][] result = new float[cardinalities.length][];
        for (int k = 0; k < result.length; ++k) {
            result[k] = new float[cardinalities[k]];
        }
        int[] labelIndexes = new int[cardinalities.length];
        for (int i = 0; i < labels.length; ++i) {
            int label = labels[i];
            if (label <= 0) continue;
            int n = label - 1;
            int n2 = labelIndexes[n];
            labelIndexes[n] = n2 + 1;
            result[label - 1][n2] = values[i];
        }
        return result;
    }

    private static float[] sortValues(float[] values) {
        values = (float[])values.clone();
        Arrays.sort(values);
        return values;
    }

    private static double findPercentile(float[] sortedValues, double percentile) {
        if (sortedValues.length == 0) {
            return Double.NaN;
        }
        int index = (int)Math.round(percentile * (double)(sortedValues.length - 1));
        if (index < 0) {
            index = 0;
        }
        if (index > sortedValues.length - 1) {
            index = sortedValues.length - 1;
        }
        return sortedValues[index];
    }

    private static double averageEqual(float[] levels, double selectedLevel, float[] valuesToAverage) {
        assert (levels.length == valuesToAverage.length);
        double sum = 0.0;
        int count = 0;
        for (int k = 0; k < levels.length; ++k) {
            if ((double)levels[k] != selectedLevel) continue;
            sum += (double)valuesToAverage[k];
            ++count;
        }
        return sum / (double)count;
    }

    private static double averageInRange(float[] levels, double lowLevel, double highLevel, float[] valuesToAverage) {
        assert (levels.length == valuesToAverage.length);
        double sum = 0.0;
        int count = 0;
        for (int k = 0; k < levels.length; ++k) {
            if (!((double)levels[k] >= lowLevel) || !((double)levels[k] <= highLevel)) continue;
            sum += (double)valuesToAverage[k];
            ++count;
        }
        return sum / (double)count;
    }

    private static double average(float[] valuesToAverage) {
        double sum = 0.0;
        for (int k = 0; k < valuesToAverage.length; ++k) {
            sum += (double)valuesToAverage[k];
        }
        return sum / (double)valuesToAverage.length;
    }

    private static double standardDeviation(float[] valuesToAverage, double average) {
        double sum = 0.0;
        for (int k = 0; k < valuesToAverage.length; ++k) {
            double diff = (double)valuesToAverage[k] - average;
            sum += diff * diff;
        }
        return Math.sqrt(sum / (double)valuesToAverage.length);
    }

    private static Map<ObjectParameter, SNumbers> convertMap(Map<String, SNumbers> statistics) {
        LinkedHashMap<ObjectParameter, SNumbers> result = new LinkedHashMap<ObjectParameter, SNumbers>();
        statistics.forEach((s, numbers) -> result.put(OUTPUT_STATISTICS.get(s), (SNumbers)numbers));
        return result;
    }

    static {
        for (ObjectParameter parameter : ObjectParameter.values()) {
            OUTPUT_STATISTICS.put(parameter.outputPort, parameter);
        }
    }

    public static enum ObjectParameter {
        MEAN("mean"),
        MEAN_SQUARE("mean_square"),
        STANDARD_DEVIATION("standard_deviation"),
        LOW_PERCENTILE("low_percentile"),
        HIGH_PERCENTILE("high_percentile"),
        PERCENTILE_A("percentile_A"),
        PERCENTILE_B("percentile_B"),
        PERCENTILE_C("percentile_C"),
        PERCENTILES_RANGE("percentiles_range"),
        TRUNCATED_MEAN("truncated_mean"),
        CARDINALITY("cardinality"),
        FIRST_NON_ZERO("first_non_zero");

        public static final EnumSet<ObjectParameter> ALL_PERCENTILES;
        final String outputPort;

        private ObjectParameter(String outputPort) {
            this.outputPort = outputPort;
        }

        static {
            ALL_PERCENTILES = EnumSet.of(LOW_PERCENTILE, HIGH_PERCENTILE, PERCENTILE_A, PERCENTILE_B, PERCENTILE_C);
        }
    }

    private static class PercentilePairs {
        final double[] lowPercentiles;
        final double[] highPercentiles;
        final float[][] dataByLabels;

        PercentilePairs(int[] labels, int[] cardinalities, float[] data, double lowPercentile, double highPercentile) {
            this.dataByLabels = ValuesAtLabelledObjects.splitByLabels(cardinalities, labels, data);
            List levelsByLabelsList = Arrays.asList(this.dataByLabels);
            Stream sortingStream = Arrays.SystemSettings.cpuCount() == 1 ? levelsByLabelsList.stream() : levelsByLabelsList.parallelStream();
            List<float[]> sortedLevelsByLabelsList = sortingStream.map(ValuesAtLabelledObjects::sortValues).toList();
            this.lowPercentiles = sortedLevelsByLabelsList.stream().map(sorted -> ValuesAtLabelledObjects.findPercentile(sorted, lowPercentile)).mapToDouble(Double::doubleValue).toArray();
            this.highPercentiles = sortedLevelsByLabelsList.stream().map(sorted -> ValuesAtLabelledObjects.findPercentile(sorted, highPercentile)).mapToDouble(Double::doubleValue).toArray();
        }
    }

    private static class ChannelStatistics {
        static final ObjectParameter[] PARAMETERS = new ObjectParameter[]{ObjectParameter.LOW_PERCENTILE, ObjectParameter.HIGH_PERCENTILE, ObjectParameter.PERCENTILES_RANGE, ObjectParameter.TRUNCATED_MEAN};
        final float[] lowPercentiles;
        final float[] highPercentiles;
        final float[] percentilesRange;
        final float[] truncatedMean;

        ChannelStatistics(int length, Set<ObjectParameter> requested) {
            this.lowPercentiles = new float[length];
            this.highPercentiles = new float[length];
            this.percentilesRange = new float[length];
            this.truncatedMean = requested.contains((Object)ObjectParameter.TRUNCATED_MEAN) ? new float[length] : null;
        }

        static Set<ObjectParameter> calculatedParameters(Set<ObjectParameter> requested) {
            HashSet<ObjectParameter> result = new HashSet<ObjectParameter>();
            result.add(ObjectParameter.LOW_PERCENTILE);
            result.add(ObjectParameter.HIGH_PERCENTILE);
            result.add(ObjectParameter.PERCENTILES_RANGE);
            if (requested.contains((Object)ObjectParameter.TRUNCATED_MEAN)) {
                result.add(ObjectParameter.TRUNCATED_MEAN);
            }
            return result;
        }

        float[] result(ObjectParameter parameter) {
            switch (parameter) {
                case LOW_PERCENTILE: {
                    return this.lowPercentiles;
                }
                case HIGH_PERCENTILE: {
                    return this.highPercentiles;
                }
                case PERCENTILES_RANGE: {
                    return this.percentilesRange;
                }
                case TRUNCATED_MEAN: {
                    return this.truncatedMean;
                }
            }
            return null;
        }
    }
}

