/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.HashMap;
import java.util.Map;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.GeneralizedBitProcessing;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannel2DFilter;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BinaryFilterParticlesOrPoresBySizes;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.matrices.scanning.ConnectivityType;

public final class FilterParticlesOrPoresBySizes
extends MultiMatrixChannel2DFilter {
    private double pixelSize = 1.0;
    private ConnectivityType connectivityType = ConnectivityType.STRAIGHT_AND_DIAGONAL;
    private BinaryFilterParticlesOrPoresBySizes.ParticlesOrPores particlesOrPores = BinaryFilterParticlesOrPoresBySizes.ParticlesOrPores.PORES;
    private Mode mode = Mode.REMOVE;
    private double maxSize = Double.POSITIVE_INFINITY;
    private double maxArea = Double.POSITIVE_INFINITY;
    private double maxPerimeter = Double.POSITIVE_INFINITY;
    private boolean ignoreZeros = false;
    private int numberOfSlices = 256;

    public double getPixelSize() {
        return this.pixelSize;
    }

    public FilterParticlesOrPoresBySizes setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
        return this;
    }

    public ConnectivityType getConnectivityType() {
        return this.connectivityType;
    }

    public ConnectivityType poresConnectivityType() {
        return BinaryFilterParticlesOrPoresBySizes.poresConnectivityType(this.connectivityType);
    }

    public FilterParticlesOrPoresBySizes setConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = (ConnectivityType)FilterParticlesOrPoresBySizes.nonNull((Object)connectivityType);
        return this;
    }

    public BinaryFilterParticlesOrPoresBySizes.ParticlesOrPores getParticlesOrPores() {
        return this.particlesOrPores;
    }

    public FilterParticlesOrPoresBySizes setParticlesOrPores(BinaryFilterParticlesOrPoresBySizes.ParticlesOrPores particlesOrPores) {
        this.particlesOrPores = (BinaryFilterParticlesOrPoresBySizes.ParticlesOrPores)((Object)FilterParticlesOrPoresBySizes.nonNull((Object)((Object)particlesOrPores)));
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public FilterParticlesOrPoresBySizes setMode(Mode mode) {
        this.mode = (Mode)((Object)FilterParticlesOrPoresBySizes.nonNull((Object)((Object)mode)));
        return this;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public FilterParticlesOrPoresBySizes setMaxSize(double maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public FilterParticlesOrPoresBySizes setMaxSize(String maxSize) {
        return this.setMaxSize(FilterParticlesOrPoresBySizes.doubleOrPositiveInfinity((String)maxSize));
    }

    public double getMaxArea() {
        return this.maxArea;
    }

    public FilterParticlesOrPoresBySizes setMaxArea(double maxArea) {
        this.maxArea = maxArea;
        return this;
    }

    public FilterParticlesOrPoresBySizes setMaxArea(String maxArea) {
        return this.setMaxArea(FilterParticlesOrPoresBySizes.doubleOrPositiveInfinity((String)maxArea));
    }

    public double getMaxPerimeter() {
        return this.maxPerimeter;
    }

    public FilterParticlesOrPoresBySizes setMaxPerimeter(double maxPerimeter) {
        this.maxPerimeter = maxPerimeter;
        return this;
    }

    public FilterParticlesOrPoresBySizes setMaxPerimeter(String maxPerimeter) {
        return this.setMaxPerimeter(FilterParticlesOrPoresBySizes.doubleOrPositiveInfinity((String)maxPerimeter));
    }

    public boolean isIgnoreZeros() {
        return this.ignoreZeros;
    }

    public FilterParticlesOrPoresBySizes setIgnoreZeros(boolean ignoreZeros) {
        this.ignoreZeros = ignoreZeros;
        return this;
    }

    public int getNumberOfSlices() {
        return this.numberOfSlices;
    }

    public void setNumberOfSlices(int numberOfSlices) {
        this.numberOfSlices = FilterParticlesOrPoresBySizes.positive((int)numberOfSlices);
    }

    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> matrix) {
        return this.filter(matrix);
    }

    public Matrix<? extends UpdatablePArray> filter(Matrix<? extends PArray> objects) {
        final boolean pores = this.particlesOrPores == BinaryFilterParticlesOrPoresBySizes.ParticlesOrPores.PORES;
        Range range = Arrays.rangeOf((PArray)((PArray)objects.array()));
        if (pores) {
            objects = BinaryFilterParticlesOrPoresBySizes.poresToParticlesWithExtending(objects, range.min());
            range = BinaryFilterParticlesOrPoresBySizes.poresToParticlesRange(objects, range);
        }
        final long[] dimensions = objects.dimensions();
        Matrix result = Arrays.SMM.newMatrix(UpdatablePArray.class, objects);
        int numberOfSlices = this.numberOfSlices;
        if (objects.array() instanceof PFixedArray) {
            numberOfSlices = Math.min(numberOfSlices, (int)(range.size() + 1.0));
        }
        final BinaryFilterParticlesOrPoresBySizes binaryFilter = new BinaryFilterParticlesOrPoresBySizes().setPixelSize(this.pixelSize).setConnectivityType(this.connectivityType).setParticlesOrPores(this.particlesOrPores).setMode(BinaryFilterParticlesOrPoresBySizes.Mode.REMOVE).setMaxSize(this.maxSize).setMaxArea(this.maxArea).setMaxPerimeter(this.maxPerimeter).setIgnoreZeros(this.ignoreZeros);
        final HashMap workMemoryPool = new HashMap();
        GeneralizedBitProcessing.SliceOperation sliceOperation = new GeneralizedBitProcessing.SliceOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processBits(ArrayContext context, UpdatableBitArray destBits, BitArray srcBits, long sliceIndex, int threadIndex, int numberOfThreads) {
                Matrix workMemory;
                Matrix result = Matrices.matrix((Array)destBits, (long[])dimensions);
                Matrix source = Matrices.matrix((Array)srcBits, (long[])dimensions);
                Map map = workMemoryPool;
                synchronized (map) {
                    workMemory = workMemoryPool.computeIfAbsent(threadIndex, k -> Arrays.SMM.newBitMatrix(dimensions));
                }
                binaryFilter.filterParticles((Matrix<? extends UpdatableBitArray>)result, (Matrix<? extends BitArray>)source, (Matrix<? extends UpdatableBitArray>)workMemory, pores ? FilterParticlesOrPoresBySizes.this.poresConnectivityType() : FilterParticlesOrPoresBySizes.this.getConnectivityType(), pores);
            }

            public boolean isInPlaceProcessingAllowed() {
                return false;
            }
        };
        GeneralizedBitProcessing generalizedBitProcessing = GeneralizedBitProcessing.getInstance(null, (GeneralizedBitProcessing.SliceOperation)sliceOperation, (GeneralizedBitProcessing.RoundingMode)GeneralizedBitProcessing.RoundingMode.ROUND_UP);
        generalizedBitProcessing.process((UpdatablePArray)result.array(), (PArray)objects.array(), range, (long)numberOfSlices);
        if (objects.elementType() != Boolean.TYPE && this.mode == Mode.REMOVE) {
            Matrices.applyFunc(null, (Func)Func.MIN, (Matrix)result, (Matrix)result, objects);
        }
        if (this.mode == Mode.FIND) {
            Matrices.applyFunc(null, (Func)Func.X_MINUS_Y, (Matrix)result, objects, (Matrix)result);
        }
        if (pores) {
            return BinaryFilterParticlesOrPoresBySizes.particlesToPoresWithReducing((Matrix<? extends UpdatablePArray>)result, this.mode == Mode.REMOVE);
        }
        return result;
    }

    public static enum Mode {
        REMOVE,
        FIND;

    }
}

