/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.derivatives;

import java.util.List;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HessianOperation {
    LAMBDA_1{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenValueFunc(true, orderEigenValues);
        }
    }
    ,
    LAMBDA_2{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenValueFunc(false, orderEigenValues);
        }
    }
    ,
    LAMBDA_1_PLUS{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenValuePlusFunc(true, orderEigenValues);
        }
    }
    ,
    LAMBDA_2_PLUS{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenValuePlusFunc(false, orderEigenValues);
        }
    }
    ,
    LAMBDA_1_MINUS{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenValueMinusFunc(true, orderEigenValues);
        }
    }
    ,
    LAMBDA_2_MINUS{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenValueMinusFunc(false, orderEigenValues);
        }
    }
    ,
    VECTOR_1_X{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenVectorFunc(true, true, orderEigenValues, stableSignumX, normalizeEigenVectors);
        }
    }
    ,
    VECTOR_1_Y{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenVectorFunc(true, false, orderEigenValues, stableSignumX, normalizeEigenVectors);
        }
    }
    ,
    VECTOR_2_X{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenVectorFunc(false, true, orderEigenValues, stableSignumX, normalizeEigenVectors);
        }
    }
    ,
    VECTOR_2_Y{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenVectorFunc(false, false, orderEigenValues, stableSignumX, normalizeEigenVectors);
        }
    }
    ,
    VECTOR_1_SCALAR_PRODUCT{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenVectorScalarProductFunc(true, orderEigenValues, stableSignumX, normalizeEigenVectors);
        }
    }
    ,
    VECTOR_2_SCALAR_PRODUCT{

        @Override
        Func funcOfSecondDerivatives(boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
            return new EigenVectorScalarProductFunc(false, orderEigenValues, stableSignumX, normalizeEigenVectors);
        }
    };

    private static final double DEFAULT_HESSIAN_D2DXDY_NORMALIZING_THRESHOLD = 1.0E-7;
    private static final double COMPUTER_EPSILON = 1.0E-10;

    abstract Func funcOfSecondDerivatives(boolean var1, boolean var2, boolean var3);

    public boolean additionalVectorRequired() {
        return this == VECTOR_1_SCALAR_PRODUCT || this == VECTOR_2_SCALAR_PRODUCT;
    }

    public <T extends PArray> Matrix<? extends T> asOperation(Class<? extends T> requiredType, Matrix<? extends PArray> d2dx2, Matrix<? extends PArray> d2dy2, Matrix<? extends PArray> d2dxdy, Matrix<? extends PArray> vectorX, Matrix<? extends PArray> vectorY, boolean orderEigenValues, boolean stableSignumX, boolean normalizeEigenVectors) {
        List arguments = this.additionalVectorRequired() ? Matrices.several(PArray.class, (Matrix[])new Matrix[]{d2dx2, d2dy2, d2dxdy, vectorX, vectorY}) : Matrices.several(PArray.class, (Matrix[])new Matrix[]{d2dx2, d2dy2, d2dxdy});
        return Matrices.asFuncMatrix((Func)this.funcOfSecondDerivatives(orderEigenValues, stableSignumX, normalizeEigenVectors), requiredType, (List)arguments);
    }

    private static class EigenVectorScalarProductFunc
    extends AbstractFunc {
        private final boolean firstValue;
        private final boolean orderedByDecreasingLambdaMagnitude;
        private final boolean stableSignumX;
        private final boolean normalize;

        private EigenVectorScalarProductFunc(boolean firstValue, boolean orderedByDecreasingLambdaMagnitude, boolean stableSignumX, boolean normalize) {
            this.firstValue = firstValue;
            this.orderedByDecreasingLambdaMagnitude = orderedByDecreasingLambdaMagnitude;
            this.stableSignumX = stableSignumX;
            this.normalize = normalize;
        }

        public double get(double ... x) {
            return this.get(x[0], x[1], x[2], x[3], x[4]);
        }

        public double get(double a, double b, double c, double vX, double vY) {
            double y;
            double x;
            double lambda2Doubled;
            double lambda1Doubled;
            double abAbs = Math.abs(a - b);
            double cAbs = Math.abs(c);
            double d = Math.sqrt(abAbs * abAbs + 4.0 * c * c);
            boolean useFirst = this.firstValue;
            if (this.orderedByDecreasingLambdaMagnitude && (lambda1Doubled = a + b + d) * lambda1Doubled < (lambda2Doubled = a + b - d) * lambda2Doubled) {
                boolean bl = useFirst = !useFirst;
            }
            if (this.stableSignumX) {
                double x2;
                double y2;
                if (useFirst) {
                    y2 = 2.0 * c;
                    double d2 = a > b ? abAbs + d : (x2 = d > 1.0E-10 ? y2 * y2 / (d + abAbs) : 0.0);
                    if (this.normalize) {
                        if (cAbs < 1.0E-7) {
                            return vX;
                        }
                        double norm = Math.sqrt(x2 * x2 + y2 * y2);
                        return (x2 * vX + y2 * vY) / norm;
                    }
                    return x2 * vX + y2 * vY;
                }
                y2 = 2.0 * c;
                double d3 = a > b ? -y2 * y2 / (d + abAbs) : (x2 = d > 1.0E-10 ? -abAbs - d : -0.0);
                if (this.normalize) {
                    if (cAbs < 1.0E-7) {
                        return -vX;
                    }
                    double norm = Math.sqrt(x2 * x2 + y2 * y2);
                    return (x2 * vX + y2 * vY) / norm;
                }
                return x2 * vX + y2 * vY;
            }
            if (useFirst) {
                x = a >= b ? a - b + d : 2.0 * c;
                double d4 = y = a >= b ? 2.0 * c : b - a + d;
                if (this.normalize) {
                    if (cAbs < 1.0E-7) {
                        return a >= b ? vX : vY;
                    }
                    double norm = Math.sqrt(x * x + y * y);
                    return (x * vX + y * vY) / norm;
                }
                return x * vX + y * vY;
            }
            x = a >= b ? 2.0 * c : a - b - d;
            double d5 = y = a >= b ? b - a - d : 2.0 * c;
            if (this.normalize) {
                if (cAbs < 1.0E-7) {
                    return a >= b ? -vY : -vX;
                }
                double norm = Math.sqrt(x * x + y * y);
                return (x * vX + y * vY) / norm;
            }
            return x * vX + y * vY;
        }
    }

    private static class EigenVectorFunc
    extends AbstractFunc {
        private final boolean firstValue;
        private final boolean xComponent;
        private final boolean orderedByDecreasingLambdaMagnitude;
        private final boolean stableSignumX;
        private final boolean normalize;

        private EigenVectorFunc(boolean firstValue, boolean xComponent, boolean orderedByDecreasingLambdaMagnitude, boolean stableSignumX, boolean normalize) {
            this.firstValue = firstValue;
            this.xComponent = xComponent;
            this.orderedByDecreasingLambdaMagnitude = orderedByDecreasingLambdaMagnitude;
            this.stableSignumX = stableSignumX;
            this.normalize = normalize;
        }

        public double get(double ... x) {
            return this.get(x[0], x[1], x[2]);
        }

        public double get(double a, double b, double c) {
            double y;
            double x;
            double lambda2Doubled;
            double lambda1Doubled;
            double abAbs = Math.abs(a - b);
            double cAbs = Math.abs(c);
            double d = Math.sqrt(abAbs * abAbs + 4.0 * c * c);
            boolean useFirst = this.firstValue;
            if (this.orderedByDecreasingLambdaMagnitude && (lambda1Doubled = a + b + d) * lambda1Doubled < (lambda2Doubled = a + b - d) * lambda2Doubled) {
                boolean bl = useFirst = !useFirst;
            }
            if (this.stableSignumX) {
                double x2;
                double y2;
                if (useFirst) {
                    y2 = 2.0 * c;
                    double d2 = a > b ? abAbs + d : (x2 = d > 1.0E-10 ? y2 * y2 / (d + abAbs) : 0.0);
                    if (this.normalize) {
                        if (cAbs < 1.0E-7) {
                            return this.xComponent ? 1.0 : 0.0;
                        }
                        double norm = Math.sqrt(x2 * x2 + y2 * y2);
                        return this.xComponent ? x2 / norm : y2 / norm;
                    }
                    return this.xComponent ? x2 : y2;
                }
                y2 = 2.0 * c;
                double d3 = a > b ? -y2 * y2 / (d + abAbs) : (x2 = d > 1.0E-10 ? -abAbs - d : -0.0);
                if (this.normalize) {
                    if (cAbs < 1.0E-7) {
                        return this.xComponent ? -1.0 : 0.0;
                    }
                    double norm = Math.sqrt(x2 * x2 + y2 * y2);
                    return this.xComponent ? x2 / norm : y2 / norm;
                }
                return this.xComponent ? x2 : y2;
            }
            if (useFirst) {
                x = a >= b ? a - b + d : 2.0 * c;
                double d4 = y = a >= b ? 2.0 * c : b - a + d;
                if (this.normalize) {
                    if (cAbs < 1.0E-7) {
                        x = a >= b ? 1.0 : 0.0;
                        y = a >= b ? 0.0 : 1.0;
                        return this.xComponent ? x : y;
                    }
                    double norm = Math.sqrt(x * x + y * y);
                    return this.xComponent ? x / norm : y / norm;
                }
                return this.xComponent ? x : y;
            }
            x = a >= b ? 2.0 * c : a - b - d;
            double d5 = y = a >= b ? b - a - d : 2.0 * c;
            if (this.normalize) {
                if (cAbs < 1.0E-7) {
                    x = a >= b ? 0.0 : -1.0;
                    y = a >= b ? -1.0 : 0.0;
                    return this.xComponent ? x : y;
                }
                double norm = Math.sqrt(x * x + y * y);
                return this.xComponent ? x / norm : y / norm;
            }
            return this.xComponent ? x : y;
        }
    }

    private static class EigenValueMinusFunc
    extends AbstractFunc {
        private final boolean firstValue;
        private final boolean orderedByDecreasingLambdaMagnitude;

        private EigenValueMinusFunc(boolean firstValue, boolean orderedByDecreasingLambdaMagnitude) {
            this.firstValue = firstValue;
            this.orderedByDecreasingLambdaMagnitude = orderedByDecreasingLambdaMagnitude;
        }

        public double get(double ... x) {
            return this.get(x[0], x[1], x[2]);
        }

        public double get(double a, double b, double c) {
            if (this.orderedByDecreasingLambdaMagnitude) {
                if (this.firstValue) {
                    double d = Math.sqrt((a - b) * (a - b) + 4.0 * c * c);
                    double lambda1 = 0.5 * (a + b + d);
                    double lambda2 = 0.5 * (a + b - d);
                    if (lambda2 >= 0.0) {
                        return lambda2;
                    }
                    if (lambda1 <= 0.0) {
                        return lambda1;
                    }
                    return 0.0;
                }
                double d = Math.sqrt((a - b) * (a - b) + 4.0 * c * c);
                double lambda1 = 0.5 * (a + b + d);
                double lambda2 = 0.5 * (a + b - d);
                if (lambda2 >= 0.0 || lambda1 <= 0.0) {
                    return 0.0;
                }
                return lambda1 >= -lambda2 ? lambda2 : lambda1;
            }
            double d = Math.sqrt((a - b) * (a - b) + 4.0 * c * c);
            double lambda1 = 0.5 * (a + b + d);
            double lambda2 = 0.5 * (a + b - d);
            double result = this.firstValue ? lambda1 : lambda2;
            return result <= 0.0 ? result : 0.0;
        }
    }

    private static class EigenValuePlusFunc
    extends AbstractFunc {
        private final boolean firstValue;
        private final boolean orderedByDecreasingLambdaMagnitude;

        private EigenValuePlusFunc(boolean firstValue, boolean orderedByDecreasingLambdaMagnitude) {
            this.firstValue = firstValue;
            this.orderedByDecreasingLambdaMagnitude = orderedByDecreasingLambdaMagnitude;
        }

        public double get(double ... x) {
            return this.get(x[0], x[1], x[2]);
        }

        public double get(double a, double b, double c) {
            double d = Math.sqrt((a - b) * (a - b) + 4.0 * c * c);
            if (this.orderedByDecreasingLambdaMagnitude) {
                if (this.firstValue) {
                    double lambda1 = 0.5 * (a + b + d);
                    double lambda2 = 0.5 * (a + b - d);
                    if (lambda1 * lambda1 >= lambda2 * lambda2) {
                        return lambda1;
                    }
                    return lambda2;
                }
                return 0.0;
            }
            double result = this.firstValue ? 0.5 * (a + b + d) : 0.5 * (a + b - d);
            return result >= 0.0 ? result : 0.0;
        }
    }

    private static class EigenValueFunc
    extends AbstractFunc {
        private final boolean firstValue;
        private final boolean orderedByDecreasingLambdaMagnitude;

        private EigenValueFunc(boolean firstValue, boolean orderedByDecreasingLambdaMagnitude) {
            this.firstValue = firstValue;
            this.orderedByDecreasingLambdaMagnitude = orderedByDecreasingLambdaMagnitude;
        }

        public double get(double ... x) {
            return this.get(x[0], x[1], x[2]);
        }

        public double get(double a, double b, double c) {
            double d = Math.sqrt((a - b) * (a - b) + 4.0 * c * c);
            if (this.orderedByDecreasingLambdaMagnitude) {
                double lambda1 = 0.5 * (a + b + d);
                double lambda2 = 0.5 * (a + b - d);
                boolean firstLess = lambda1 * lambda1 < lambda2 * lambda2;
                return this.firstValue == firstLess ? lambda2 : lambda1;
            }
            return this.firstValue ? 0.5 * (a + b + d) : 0.5 * (a + b - d);
        }
    }
}

