/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.util;

import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.SystemEnvironment;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.common.ChannelOperation;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Scalar4f;
import org.bytedeco.opencv.opencv_core.Scalar4i;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.TermCriteria;
import org.bytedeco.opencv.opencv_core.UMat;
import org.bytedeco.opencv.opencv_imgproc.Vec4fVector;
import org.bytedeco.opencv.opencv_imgproc.Vec4iVector;

public final class OTools {
    public static final String USE_GPU_PROPERTY_NAME = "net.algart.executors.modules.opencv.useGPU";
    private static final boolean GPU_OPTIMIZATION_ENABLED = SystemEnvironment.getBooleanProperty((String)"net.algart.executors.modules.opencv.useGPU", (boolean)true) && opencv_core.haveOpenCL();
    private static final Scalar zeroScalar = new Scalar(0.0, 0.0, 0.0, 0.0);

    private OTools() {
    }

    public static boolean isGPUOptimizationEnabled() {
        return GPU_OPTIMIZATION_ENABLED;
    }

    public static String openCVVersion() {
        return opencv_core.getVersionMajor() + "." + opencv_core.getVersionMinor();
    }

    public static SMat.Depth depth(int openCVDepth) {
        return SMat.Depth.valueOf((int)openCVDepth);
    }

    public static SMat.Depth depth(Mat mat) {
        return SMat.Depth.valueOf((int)mat.depth());
    }

    public static SMat.Depth depth(UMat mat) {
        return SMat.Depth.valueOf((int)mat.depth());
    }

    public static Class<?> elementType(Mat mat) {
        return OTools.depth(mat).elementType();
    }

    public static Class<?> elementType(UMat mat) {
        return OTools.depth(mat).elementType();
    }

    public static double maxPossibleValue(int depth) {
        switch (depth) {
            case 0: {
                return 255.0;
            }
            case 1: {
                return 127.0;
            }
            case 2: {
                return 65535.0;
            }
            case 3: {
                return 32767.0;
            }
            case 4: {
                return 2.147483647E9;
            }
        }
        return 1.0;
    }

    public static boolean isFloatingPoint(int depth) {
        return depth == 7 || depth == 5 || depth == 6;
    }

    public static double maxPossibleValue(Mat mat) {
        Objects.requireNonNull(mat, "Null mat");
        return OTools.maxPossibleValue(mat.depth());
    }

    public static double maxPossibleValue(UMat mat) {
        Objects.requireNonNull(mat, "Null mat");
        return OTools.maxPossibleValue(mat.depth());
    }

    public static long sizeOfInBytes(Mat mat) {
        return mat.total() * mat.elemSize();
    }

    public static long sizeOfInBytes(UMat mat) {
        return mat.total() * mat.elemSize();
    }

    public static boolean isPackedBits(SMat m) {
        return m.getDepth() == SMat.Depth.BIT && m.getNumberOfChannels() == 1;
    }

    public static Scalar scalarBGR(double value) {
        return new Scalar(value, value, value, 0.0);
    }

    public static Scalar scalarBGR(Color color, double maxValue) {
        return new Scalar((double)color.getBlue() / 255.0 * maxValue, (double)color.getGreen() / 255.0 * maxValue, (double)color.getRed() / 255.0 * maxValue, (double)color.getAlpha() / 255.0 * maxValue);
    }

    public static Scalar scalarBGRA(String color, double maxValue) {
        double[] rgba = ChannelOperation.decodeRGBA((String)color, (double)maxValue);
        return new Scalar(rgba[2], rgba[1], rgba[0], rgba[3]);
    }

    public static Scalar scalarBGRA(double value, double alpha) {
        return new Scalar(value, value, value, alpha);
    }

    public static Point toPoint(IPoint point) {
        Objects.requireNonNull(point, "Null point");
        if (point.coordCount() != 2) {
            throw new IllegalArgumentException("point is not 2-dimensional: " + point);
        }
        long x = point.x();
        long y = point.y();
        if (x != (long)((int)x) || y != (long)((int)y)) {
            throw new IllegalArgumentException("point is too large and cannot be represented by 32 bits: " + point);
        }
        return new Point((int)x, (int)y);
    }

    public static IPoint toIPoint(Point point) {
        return IPoint.valueOf((long)point.x(), (long)point.y());
    }

    public static Rect toRect(IRectangularArea rectangularArea) {
        Objects.requireNonNull(rectangularArea, "Null rectangularArea");
        if (rectangularArea.coordCount() != 2) {
            throw new IllegalArgumentException("rectangularArea is not 2-dimensional: " + rectangularArea);
        }
        long minX = rectangularArea.minX();
        long minY = rectangularArea.minY();
        long maxX = rectangularArea.maxX();
        long maxY = rectangularArea.maxY();
        long sizeX = rectangularArea.sizeX();
        long sizeY = rectangularArea.sizeY();
        if (minX != (long)((int)minX) || minY != (long)((int)minY) || maxX != (long)((int)maxX) || maxY != (long)((int)maxY) || sizeX != (long)((int)sizeX) || sizeY != (long)((int)sizeY)) {
            throw new IllegalArgumentException("rectangularArea is too large and cannot be represented by 32 bits: " + rectangularArea);
        }
        return new Rect((int)minX, (int)minY, (int)sizeX, (int)sizeY);
    }

    public static IRectangularArea toIRectangularArea(Rect rect) {
        int minX = rect.x();
        int minY = rect.y();
        int maxX = minX + rect.width() - 1;
        int maxY = minY + rect.height() - 1;
        return minX <= maxX && minY <= maxY ? IRectangularArea.valueOf((long)minX, (long)minY, (long)maxX, (long)maxY) : null;
    }

    public static int[] toIntArray(Vec4iVector vector) {
        long n = vector.size();
        if (n > 0x1FFFFFFFL) {
            throw new TooLargeArrayException("Too large Vec4iVector");
        }
        int[] result = new int[4 * (int)n];
        int k = 0;
        while ((long)k < n) {
            try (Scalar4i scalar = vector.get((long)k);){
                scalar.get(result, 4 * k, 4);
            }
            ++k;
        }
        return result;
    }

    public static float[] toFloatArray(Vec4fVector vector) {
        long n = vector.size();
        if (n > 0x1FFFFFFFL) {
            throw new TooLargeArrayException("Too large Vec4iVector");
        }
        float[] result = new float[4 * (int)n];
        int k = 0;
        while ((long)k < n) {
            try (Scalar4f scalar = vector.get((long)k);){
                scalar.get(result, 4 * k, 4);
            }
            ++k;
        }
        return result;
    }

    public static Mat clone(Mat m) {
        Mat clone = new Mat(m.rows(), m.cols(), m.type());
        m.copyTo(clone);
        return clone;
    }

    public static UMat clone(UMat u) {
        UMat clone = new UMat(u.rows(), u.cols(), u.type());
        u.copyTo(clone);
        return clone;
    }

    public static Mat toMat(UMat u) {
        Mat clone = new Mat(u.rows(), u.cols(), u.type());
        u.copyTo(clone);
        return clone;
    }

    public static UMat toUMat(Mat m) {
        UMat clone = new UMat(m.rows(), m.cols(), m.type());
        m.copyTo(clone);
        return clone;
    }

    public static Mat newCompatibleMat(Mat mat) {
        return OTools.newCompatibleMat(mat, mat.type());
    }

    public static Mat newCompatibleMat(Mat mat, int newType) {
        try (Size size = mat.size();){
            Mat mat2 = new Mat(size, newType);
            return mat2;
        }
    }

    public static UMat newCompatibleMat(UMat mat) {
        return OTools.newCompatibleUMat(mat, mat.type());
    }

    public static UMat newCompatibleUMat(UMat mat, int newType) {
        try (Size size = mat.size();){
            UMat uMat = new UMat(size, newType);
            return uMat;
        }
    }

    public static Mat newCompatibleZeros(Mat mat) {
        try (Size size = mat.size();){
            Mat mat2 = new Mat(size, mat.type(), zeroScalar);
            return mat2;
        }
    }

    public static UMat newCompatibleZeros(UMat mat) {
        try (Size size = mat.size();){
            UMat uMat = new UMat(size, mat.type(), zeroScalar);
            return uMat;
        }
    }

    public static Mat constantMat8U(int dimX, int dimY, Color color) {
        try (Scalar scalar = OTools.scalarBGR(color, 255.0);){
            Mat mat = new Mat(dimY, dimX, opencv_core.CV_8UC3, scalar);
            return mat;
        }
    }

    public static Mat constantMonoMat8U(int dimX, int dimY, int filler) {
        try (Scalar scalar = new Scalar((double)filler);){
            Mat mat = new Mat(dimY, dimX, opencv_core.CV_8UC1, scalar);
            return mat;
        }
    }

    public static Mat to8UIfNot(Mat mat) {
        if (mat.depth() == 0) {
            return mat;
        }
        Mat result = new Mat();
        mat.convertTo(result, 0, 255.0 / OTools.maxPossibleValue(mat), 0.0);
        return result;
    }

    public static UMat to8UIfNot(UMat mat) {
        if (mat.depth() == 0) {
            return mat;
        }
        UMat result = new UMat();
        mat.convertTo(result, 0, 255.0 / OTools.maxPossibleValue(mat), 0.0);
        return result;
    }

    public static Mat to32FIfNot(Mat mat) {
        if (mat.depth() == 5) {
            return mat;
        }
        Mat result = new Mat();
        mat.convertTo(result, 5, 1.0 / OTools.maxPossibleValue(mat), 0.0);
        return result;
    }

    public static UMat to32FIfNot(UMat mat) {
        if (mat.depth() == 5) {
            return mat;
        }
        UMat result = new UMat();
        mat.convertTo(result, 5, 1.0 / OTools.maxPossibleValue(mat), 0.0);
        return result;
    }

    public static void make32FIfNot(Mat mat) {
        if (mat.depth() == 5) {
            return;
        }
        mat.convertTo(mat, 5, 1.0 / OTools.maxPossibleValue(mat), 0.0);
    }

    public static void make32FIfNot(UMat mat) {
        if (mat.depth() == 5) {
            return;
        }
        mat.convertTo(mat, 5, 1.0 / OTools.maxPossibleValue(mat), 0.0);
    }

    public static void makeMonoIfNot(Mat mat) {
        if (mat.channels() == 1) {
            return;
        }
        opencv_imgproc.cvtColor((Mat)mat, (Mat)mat, (int)6);
    }

    public static void makeMonoIfNot(UMat mat) {
        if (mat.channels() == 1) {
            return;
        }
        opencv_imgproc.cvtColor((UMat)mat, (UMat)mat, (int)6);
    }

    public static Mat toMonoIfNot(Mat mat) {
        if (mat.channels() <= 1) {
            return mat;
        }
        Mat result = new Mat();
        opencv_imgproc.cvtColor((Mat)mat, (Mat)result, (int)6);
        return result;
    }

    public static UMat toMonoIfNot(UMat mat) {
        if (mat.channels() <= 1) {
            return mat;
        }
        UMat result = new UMat();
        opencv_imgproc.cvtColor((UMat)mat, (UMat)result, (int)6);
        return result;
    }

    public static Mat toMono32FIfNot(Mat mat) {
        if (mat.channels() <= 1 && mat.depth() == 5) {
            return mat;
        }
        Mat result = OTools.to32FIfNot(mat);
        if (result == mat) {
            return OTools.toMonoIfNot(mat);
        }
        if (mat.channels() > 1) {
            opencv_imgproc.cvtColor((Mat)result, (Mat)result, (int)6);
        }
        return result;
    }

    public static UMat toMono32FIfNot(UMat mat) {
        if (mat.channels() <= 1 && mat.depth() == 5) {
            return mat;
        }
        UMat result = OTools.to32FIfNot(mat);
        if (result == mat) {
            return OTools.toMonoIfNot(mat);
        }
        if (mat.channels() > 1) {
            opencv_imgproc.cvtColor((UMat)result, (UMat)result, (int)6);
        }
        return result;
    }

    public static Mat toMono8UIfNot(Mat mat) {
        if (mat.channels() <= 1 && mat.depth() == 0) {
            return mat;
        }
        Mat result = OTools.to8UIfNot(mat);
        if (result == mat) {
            return OTools.toMonoIfNot(mat);
        }
        if (mat.channels() > 1) {
            opencv_imgproc.cvtColor((Mat)result, (Mat)result, (int)6);
        }
        return result;
    }

    public static UMat toMono8UIfNot(UMat mat) {
        if (mat.channels() <= 1 && mat.depth() == 0) {
            return mat;
        }
        UMat result = OTools.to8UIfNot(mat);
        if (result == mat) {
            return OTools.toMonoIfNot(mat);
        }
        if (mat.channels() > 1) {
            opencv_imgproc.cvtColor((UMat)result, (UMat)result, (int)6);
        }
        return result;
    }

    public static void closeFirstIfDiffersFromSecond(Mat mat, Mat referenceToCompare) {
        if (mat != referenceToCompare) {
            mat.close();
        }
    }

    public static void closeFirstIfDiffersFromSecond(UMat mat, UMat referenceToCompare) {
        if (mat != referenceToCompare) {
            mat.close();
        }
    }

    public static TermCriteria termCriteria(int terminationMaxCount, double terminationEpsilon, boolean nullAllowed) {
        if (terminationMaxCount != 0 || terminationEpsilon != 0.0) {
            int type = (terminationMaxCount != 0 ? 1 : 0) + (terminationEpsilon != 0.0 ? 2 : 0);
            return new TermCriteria(type, terminationMaxCount, terminationEpsilon);
        }
        if (nullAllowed) {
            return null;
        }
        throw new IllegalArgumentException("Termination max count or epsilon must be non-zero");
    }

    public static void flipRBChannels(Mat mat) {
        int n = mat.channels();
        if (n == 3 || n == 4) {
            opencv_imgproc.cvtColor((Mat)mat, (Mat)mat, (int)(n == 3 ? 4 : 5));
        }
    }

    public static void flipRBChannels(UMat mat) {
        int n = mat.channels();
        if (n == 3 || n == 4) {
            opencv_imgproc.cvtColor((UMat)mat, (UMat)mat, (int)(n == 3 ? 4 : 5));
        }
    }

    public static Mat drawBitMaskOnMat(Mat mat, Mat mask, Color color) {
        Mat result = new Mat();
        mat.convertTo(result, 0, 255.0 / OTools.maxPossibleValue(mat), 0.0);
        if (result.channels() == 1) {
            opencv_imgproc.cvtColor((Mat)result, (Mat)result, (int)8);
        } else if (result.channels() == 4) {
            opencv_imgproc.cvtColor((Mat)result, (Mat)result, (int)1);
        }
        try (Mat constant = OTools.constantMat8U(mat.cols(), mat.rows(), color);){
            Mat mask8U = OTools.to8UIfNot(mask);
            constant.copyTo(result, mask8U);
            if (mask8U != mask) {
                mask8U.close();
            }
        }
        return result;
    }

    public static void drawBitMaskOnMatByWhite(Mat mat, Mat mask) {
        if (mat.depth() != mask.depth()) {
            mask.convertTo(mask, mat.depth(), OTools.maxPossibleValue(mat) / OTools.maxPossibleValue(mask), 0.0);
        }
        if (mask.channels() > 1) {
            opencv_imgproc.cvtColor((Mat)mask, (Mat)mask, (int)6);
        }
        if (mat.channels() > 1) {
            opencv_imgproc.cvtColor((Mat)mask, (Mat)mask, (int)8, (int)mat.channels());
        }
        opencv_core.bitwise_or((Mat)mat, (Mat)mask, (Mat)mask);
    }

    public static void morphology(Mat mat, int op, int shape, int patternSize) {
        if (patternSize > 0) {
            try (Size size = new Size(patternSize, patternSize);
                 Mat element = opencv_imgproc.getStructuringElement((int)shape, (Size)size);){
                opencv_imgproc.morphologyEx((Mat)mat, (Mat)mat, (int)op, (Mat)element);
            }
        }
    }

    public static void morphology(UMat mat, int op, int shape, int patternSize) {
        if (patternSize > 0) {
            try (Size size = new Size(patternSize, patternSize);
                 Mat element = opencv_imgproc.getStructuringElement((int)shape, (Size)size);
                 UMat elementUMat = OTools.toUMat(element);){
                opencv_imgproc.morphologyEx((UMat)mat, (UMat)mat, (int)op, (UMat)elementUMat);
            }
        }
    }

    public static byte[] toByteArray(Mat m) {
        ByteBuffer byteBuffer = OTools.asByteBuffer(m).duplicate();
        byte[] result = new byte[byteBuffer.capacity()];
        byteBuffer.get(result);
        return result;
    }

    public static ByteBuffer toByteBuffer(Mat m) {
        return SMat.cloneByteBuffer((ByteBuffer)OTools.asByteBuffer(m));
    }

    public static ByteBuffer toByteBuffer(UMat u) {
        long size = OTools.sizeOfInBytes(u);
        if (size > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Cannot convert UMat to ByteBuffer: it's length " + size + " > Integer.MAX_VALUE (" + u + ")");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)size);
        byteBuffer.order(ByteOrder.nativeOrder());
        Mat m = OTools.asMat(u.cols(), u.rows(), u.type(), byteBuffer);
        u.copyTo(m);
        return byteBuffer;
    }

    public static Mat asMat(int width, int height, int type, ByteBuffer byteBuffer) {
        return new Mat(height, width, type, (Pointer)new BytePointer(byteBuffer.duplicate()));
    }

    public static Mat toMat(int width, int height, int type, ByteBuffer byteBuffer) {
        Mat result = new Mat(height, width, type);
        byteBuffer = byteBuffer.duplicate();
        byteBuffer.position(0);
        OTools.asByteBuffer(result).put(byteBuffer);
        return result;
    }

    public static Mat toMat(int width, int height, int type, byte[] byteArray) {
        Mat result = new Mat(height, width, type);
        OTools.asByteBuffer(result).put(byteArray);
        return result;
    }

    public static UMat toUMat(int width, int height, int type, ByteBuffer byteBuffer) {
        return OTools.toUMat(OTools.asMat(width, height, type, byteBuffer));
    }

    public static UMat toUMat(int width, int height, int type, byte[] byteArray) {
        return OTools.toUMat(width, height, type, ByteBuffer.wrap(byteArray));
    }

    public static void checkDimensionOfNonNullMatEquality(List<? extends Mat> matrices) {
        Objects.requireNonNull(matrices);
        Mat first = null;
        int firstIndex = -1;
        int index = -1;
        for (Mat mat : matrices) {
            ++index;
            if (mat == null) continue;
            if (first == null) {
                first = mat;
                firstIndex = index;
                continue;
            }
            if (mat.cols() == first.cols() && mat.rows() == first.rows()) continue;
            throw new SizeMismatchException("The OpenCV matrix #" + index + " and #" + firstIndex + " dimensions mismatch: #" + index + " is " + mat + ", #" + firstIndex + " is " + first);
        }
    }

    public static void checkDimensionOfNonNullUMatEquality(List<? extends UMat> matrices) {
        Objects.requireNonNull(matrices);
        UMat first = null;
        int firstIndex = -1;
        int index = -1;
        for (UMat uMat : matrices) {
            ++index;
            if (uMat == null) continue;
            if (first == null) {
                first = uMat;
                firstIndex = index;
                continue;
            }
            if (uMat.cols() == first.cols() && uMat.rows() == first.rows()) continue;
            throw new SizeMismatchException("The OpenCV matrix #" + index + " and #" + firstIndex + " dimensions mismatch: #" + index + " is " + OTools.toString(uMat) + ", #" + firstIndex + " is " + OTools.toString(first));
        }
    }

    public static void checkDimensionOfNonNullMatEquality(Mat ... m) {
        OTools.checkDimensionOfNonNullMatEquality(Arrays.asList(m));
    }

    public static void checkDimensionOfNonNullMatEquality(UMat ... m) {
        OTools.checkDimensionOfNonNullUMatEquality(Arrays.asList(m));
    }

    public static String toString(Mat mat) {
        return mat == null ? null : String.format(Locale.US, "%s (address 0x%x, %.2f MB)", mat, mat.address(), (double)OTools.sizeOfInBytes(mat) / 1048576.0);
    }

    public static String toString(UMat mat) {
        return mat == null ? null : String.format(Locale.US, "UMat[%dbit %dx%dx%d]: %s (%.2f MB)", 8L * mat.elemSize1(), mat.channels(), mat.cols(), mat.rows(), mat, (double)OTools.sizeOfInBytes(mat) / 1048576.0);
    }

    public static String toString(TermCriteria termCriteria) {
        return termCriteria == null ? null : "termCriteria: type=" + termCriteria.type() + ", maxCount=" + termCriteria.maxCount() + ", epsilon=" + termCriteria.epsilon();
    }

    private static ByteBuffer asByteBuffer(Mat m) {
        Objects.requireNonNull(m, "Null Mat");
        long arraySize = m.arraySize();
        if (arraySize > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Cannot convert Mat to ByteBuffer: it's length " + arraySize + " > Integer.MAX_VALUE (" + m + ")");
        }
        return m.data().position(0L).capacity(arraySize).asByteBuffer();
    }
}

