/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.util;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.executors.api.data.ConvertibleByteBufferMatrix;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.util.ConvertibleMat;
import net.algart.executors.modules.opencv.util.ConvertibleUMat;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class O2SMat {
    public static int ML_LAYOUT = 0;
    private static final boolean OPTIMIZE_COPYING = true;

    private O2SMat() {
    }

    public static Mat toMat(MultiMatrix2D multiMatrix) {
        if (multiMatrix.elementType() == Boolean.TYPE) {
            multiMatrix = multiMatrix.asPrecision(Byte.TYPE);
        }
        return O2SMat.toMat(SMat.valueOf((MultiMatrix)multiMatrix));
    }

    public static UMat toUMat(MultiMatrix2D multiMatrix) {
        if (multiMatrix.elementType() == Boolean.TYPE) {
            multiMatrix = multiMatrix.asPrecision(Byte.TYPE);
        }
        return O2SMat.toUMat(SMat.valueOf((MultiMatrix)multiMatrix));
    }

    public static MultiMatrix2D toMultiMatrix(Mat mat) {
        return O2SMat.setTo(new SMat(), mat, true).toMultiMatrix2D(true);
    }

    public static MultiMatrix2D toMultiMatrix(UMat mat) {
        return O2SMat.setTo(new SMat(), mat, true).toMultiMatrix2D(true);
    }

    public static MultiMatrix2D toBinaryMatrix(Mat mat) {
        return O2SMat.toMultiMatrix(mat).asMono().asPrecision(Boolean.TYPE).clone();
    }

    public static MultiMatrix2D toBinaryMatrix(UMat mat) {
        try (Mat m = OTools.toMat(mat);){
            MultiMatrix2D multiMatrix2D = O2SMat.toBinaryMatrix(m);
            return multiMatrix2D;
        }
    }

    public static Mat toMat(SMat m) {
        return O2SMat.toMat(m, false);
    }

    public static Mat toMat(SMat m, boolean autoConvertPackedBits) {
        if (!m.isInitialized()) {
            return null;
        }
        SMat.Convertible pointer = m.getPointer();
        if (pointer instanceof ConvertibleMat) {
            return ((ConvertibleMat)pointer).mat();
        }
        m = O2SMat.prepareForOpenCV(m, autoConvertPackedBits);
        int type = opencv_core.CV_MAKE_TYPE((int)m.getDepth().code(), (int)m.getNumberOfChannels());
        ByteBuffer byteBuffer = m.getByteBuffer();
        Mat result = OTools.toMat((int)m.getDimX(), (int)m.getDimY(), type, byteBuffer);
        return result;
    }

    public static UMat toUMat(SMat m) {
        return O2SMat.toUMat(m, false);
    }

    public static UMat toUMat(SMat m, boolean autoConvertPackedBits) {
        if (!m.isInitialized()) {
            return null;
        }
        SMat.Convertible pointer = m.getPointer();
        if (pointer instanceof ConvertibleUMat) {
            return ((ConvertibleUMat)pointer).mat();
        }
        m = O2SMat.prepareForOpenCV(m, autoConvertPackedBits);
        int type = opencv_core.CV_MAKE_TYPE((int)m.getDepth().code(), (int)m.getNumberOfChannels());
        return OTools.toUMat((int)m.getDimX(), (int)m.getDimY(), type, m.getByteBuffer());
    }

    public static Mat toMat(Matrix<? extends PArray> packedChannels) {
        return O2SMat.toMat(packedChannels, false);
    }

    public static Mat toMat(Matrix<? extends PArray> packedChannels, boolean autoConvertPackedBits) {
        return O2SMat.toMat(SMat.valueOfPackedMatrix(packedChannels), autoConvertPackedBits);
    }

    public static UMat toUMat(Matrix<? extends PArray> packedChannels) {
        return O2SMat.toUMat(packedChannels, false);
    }

    public static UMat toUMat(Matrix<? extends PArray> packedChannels, boolean autoConvertPackedBits) {
        return O2SMat.toUMat(SMat.valueOfPackedMatrix(packedChannels), autoConvertPackedBits);
    }

    public static SMat toSMat(Mat mat) {
        return O2SMat.setTo(new SMat(), mat);
    }

    public static SMat toSMat(UMat mat) {
        return O2SMat.setTo(new SMat(), mat, false);
    }

    public static PArray toRawArray(Mat mat) {
        Objects.requireNonNull(mat, "Null mat");
        if (mat.rows() == 0 || mat.cols() == 0) {
            return Arrays.nPCopies((long)0L, OTools.elementType(mat), (double)0.0);
        }
        return (PArray)O2SMat.toSMat(mat).toPackedMatrix(true).array();
    }

    public static PArray toRawArray(UMat mat) {
        Objects.requireNonNull(mat, "Null mat");
        if (mat.rows() == 0 || mat.cols() == 0) {
            return Arrays.nPCopies((long)0L, OTools.elementType(mat), (double)0.0);
        }
        return (PArray)O2SMat.toSMat(mat).toPackedMatrix(true).array();
    }

    public static SNumbers toRawNumbers(Mat mat, int blockLength) {
        PArray array = O2SMat.toRawArray(mat);
        if (array.isEmpty()) {
            return SNumbers.zeros((Class)array.elementType(), (int)0, (int)Math.max(blockLength, 1));
        }
        Object javaArray = Arrays.toJavaArray((Array)array);
        return SNumbers.valueOfArray((Object)javaArray, (int)blockLength);
    }

    public static SNumbers toRawNumbers(UMat mat, int blockLength) {
        PArray array = O2SMat.toRawArray(mat);
        if (array.isEmpty()) {
            return SNumbers.zeros((Class)array.elementType(), (int)0, (int)Math.max(blockLength, 1));
        }
        Object javaArray = Arrays.toJavaArray((Array)array);
        return SNumbers.valueOfArray((Object)javaArray, (int)blockLength);
    }

    public static SMat setToOrRemove(SMat result, Mat mat) {
        if (mat == null || mat.cols() == 0 || mat.rows() == 0) {
            result.remove();
            return result;
        }
        return O2SMat.setTo(result, mat);
    }

    public static SMat setToOrRemove(SMat result, UMat mat) {
        if (mat == null || mat.cols() == 0 || mat.rows() == 0) {
            result.remove();
            return result;
        }
        return O2SMat.setTo(result, mat);
    }

    public static SMat setTo(SMat result, Mat mat) {
        return O2SMat.setTo(result, mat, false);
    }

    public static SMat setTo(SMat result, UMat mat) {
        return O2SMat.setTo(result, mat, false);
    }

    public static Mat matrixToMlSamplesOrResponsesMat(SMat values, boolean intResult) {
        return O2SMat.toMat(O2SMat.matrixToMlSamplesOrResponsesSMat(values, intResult));
    }

    public static UMat matrixToMlSamplesOrResponsesUMat(SMat values, boolean intResult) {
        return O2SMat.toUMat(O2SMat.matrixToMlSamplesOrResponsesSMat(values, intResult));
    }

    public static Mat numbersToMulticolumnMat(SNumbers values) {
        Objects.requireNonNull(values, "Null values");
        if (!values.isInitialized()) {
            throw new IllegalArgumentException("Not initialized values");
        }
        return O2SMat.toMat((Matrix<? extends PArray>)Matrices.matrix((Array)PArray.as((Object)values.getArray()), (long[])new long[]{1L, values.getBlockLength(), values.n()}));
    }

    public static UMat numbersToMulticolumnUMat(SNumbers values) {
        Objects.requireNonNull(values, "Null values");
        if (!values.isInitialized()) {
            throw new IllegalArgumentException("Not initialized values");
        }
        return O2SMat.toUMat((Matrix<? extends PArray>)Matrices.matrix((Array)PArray.as((Object)values.getArray()), (long[])new long[]{1L, values.getBlockLength(), values.n()}));
    }

    public static Mat numbersToMulticolumn32BitMat(SNumbers values, boolean intResult) {
        return O2SMat.toMat(O2SMat.numbersToMulticolumn32BitSMat(values, intResult));
    }

    public static UMat numbersToMulticolumn32BitUMat(SNumbers values, boolean intResult) {
        return O2SMat.toUMat(O2SMat.numbersToMulticolumn32BitSMat(values, intResult));
    }

    public static SMat mlResultsToMatrix(Mat packedByRows, long dimX, long dimY) {
        Objects.requireNonNull(packedByRows, "Null packed mat");
        if (dimX * dimY != (long)packedByRows.rows()) {
            throw new IllegalArgumentException("Number of rows of ML mat " + packedByRows.rows() + " is not equal to required number of pixels " + dimX + "*" + dimY);
        }
        if (packedByRows.channels() != 1) {
            throw new IllegalArgumentException("Number of channels of ML mat " + packedByRows.channels() + " must be 1");
        }
        int numberOfChannels = packedByRows.cols();
        return SMat.valueOf((long)dimX, (long)dimY, (SMat.Depth)SMat.Depth.valueOf((int)packedByRows.depth()), (int)numberOfChannels, (ByteBuffer)OTools.toByteBuffer(packedByRows));
    }

    public static SMat mlResultsToMatrix(UMat packedByRows, long dimX, long dimY) {
        Objects.requireNonNull(packedByRows, "Null packed mat");
        if (dimX * dimY != (long)packedByRows.rows()) {
            throw new IllegalArgumentException("Number of rows of ML mat " + packedByRows.rows() + " is not equal to required number of pixels " + dimX + "*" + dimY);
        }
        if (packedByRows.channels() != 1) {
            throw new IllegalArgumentException("Number of channels of ML mat " + packedByRows.channels() + " must be 1");
        }
        int numberOfChannels = packedByRows.cols();
        return SMat.valueOf((long)dimX, (long)dimY, (SMat.Depth)SMat.Depth.valueOf((int)packedByRows.depth()), (int)numberOfChannels, (ByteBuffer)OTools.toByteBuffer(packedByRows));
    }

    public static SNumbers multicolumnMatToNumbers(Mat packedByRows) {
        Objects.requireNonNull(packedByRows, "Null packed mat");
        if (packedByRows.channels() != 1) {
            throw new IllegalArgumentException("ML mat must contain only 1 channel, but it contains " + packedByRows.channels() + " channels: " + packedByRows);
        }
        return O2SMat.toRawNumbers(packedByRows, packedByRows.cols());
    }

    public static SNumbers multicolumnMatToNumbers(UMat packedByRows) {
        try (Mat m = OTools.toMat(packedByRows);){
            SNumbers sNumbers = O2SMat.multicolumnMatToNumbers(m);
            return sNumbers;
        }
    }

    private static SMat matrixToMlSamplesOrResponsesSMat(SMat values, boolean intResult) {
        Objects.requireNonNull(values, "Null values");
        if (!values.isInitialized()) {
            throw new IllegalArgumentException("Not initialized values");
        }
        if (!values.isChannelsOrderCompatibleWithMultiMatrix()) {
            MultiMatrix2D multiMatrix = values.toMultiMatrix2D(true);
            values = SMat.valueOf((MultiMatrix)multiMatrix, (SMat.ChannelOrder)SMat.ChannelOrder.ORDER_IN_PACKED_BYTE_BUFFER);
        }
        Matrix packed3d = Matrices.asPrecision((Matrix)values.toPackedMatrix(true), intResult ? Integer.TYPE : Float.TYPE);
        assert (packed3d.dimCount() == 3);
        Matrix packedByRows = Matrices.matrix((Array)((PArray)packed3d.array()), (long[])new long[]{1L, packed3d.dim(0), packed3d.dim(1) * packed3d.dim(2)});
        return SMat.valueOfPackedMatrix((Matrix)packedByRows);
    }

    private static SMat numbersToMulticolumn32BitSMat(SNumbers values, boolean intResult) {
        Objects.requireNonNull(values, "Null values");
        if (!values.isInitialized()) {
            throw new IllegalArgumentException("Not initialized values");
        }
        UpdatableIntArray array = intResult ? IntArray.as((int[])values.toIntArray()) : FloatArray.as((float[])values.toFloatArray());
        return SMat.valueOfPackedMatrix((Matrix)Matrices.matrix((Array)array, (long[])new long[]{1L, values.getBlockLength(), values.n()}));
    }

    private static SMat setTo(SMat result, Mat mat, boolean serializeData) {
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(mat, "Null mat");
        long dimX = mat.cols();
        long dimY = mat.rows();
        SMat.Depth depth = SMat.Depth.valueOf((int)mat.depth());
        int channels = mat.channels();
        ConvertibleMat pointer = !serializeData ? new ConvertibleMat(mat) : new ConvertibleByteBufferMatrix(OTools.toByteBuffer(mat));
        return result.setAll(new long[]{dimX, dimY}, depth, channels, (SMat.Convertible)pointer);
    }

    private static SMat setTo(SMat result, UMat mat, boolean serializeData) {
        Objects.requireNonNull(result, "Null result");
        Objects.requireNonNull(mat, "Null mat");
        long dimX = mat.cols();
        long dimY = mat.rows();
        SMat.Depth depth = SMat.Depth.valueOf((int)mat.depth());
        int channels = mat.channels();
        ConvertibleUMat pointer = !serializeData ? new ConvertibleUMat(mat) : new ConvertibleByteBufferMatrix(OTools.toByteBuffer(mat));
        return result.setAll(new long[]{dimX, dimY}, depth, channels, (SMat.Convertible)pointer);
    }

    private static SMat prepareForOpenCV(SMat m, boolean autoConvertPackedBits) {
        if (!m.getDepth().isOpenCVCompatible()) {
            if (autoConvertPackedBits && OTools.isPackedBits(m)) {
                m = SMat.valueOf((MultiMatrix)m.toMultiMatrix().toPrecisionIfNot(Byte.TYPE));
            } else {
                throw new IllegalArgumentException("Matrix element depth " + (String)(m.getNumberOfChannels() == 1 ? "" : "for " + m.getNumberOfChannels() + " channels ") + "is not supported: " + m);
            }
        }
        if (m.getDimX() > Integer.MAX_VALUE || m.getDimY() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large matrix sizes (>=2^31): " + m);
        }
        return m;
    }

    static {
        Class<OTools> clazz = OTools.class;
    }
}

