/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.util;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.opencv_core.Mat;

public final class ConvertibleMat
extends SMat.Convertible {
    private volatile Mat mat;
    private AtomicBoolean disposed = new AtomicBoolean(false);

    public ConvertibleMat(Mat mat) {
        this.mat = Objects.requireNonNull(mat, "Null mat");
    }

    public Mat mat() {
        this.checkMat();
        return this.mat;
    }

    public SMat.Convertible copy() {
        this.checkMat();
        return new ConvertibleMat(this.mat.clone());
    }

    public SMat.Convertible copyToMemoryAndDisposePrevious() {
        return this;
    }

    public ByteBuffer toByteBuffer(SMat thisMatrix) {
        this.checkMat();
        return OTools.toByteBuffer(this.mat);
    }

    public void dispose() {
        if (this.disposed.getAndSet(true)) {
            return;
        }
        this.mat.close();
        this.mat = null;
    }

    public String toString() {
        return "reference to " + this.mat;
    }

    private void checkMat() {
        if (this.disposed.get()) {
            throw new IllegalStateException("mat is already deallocated");
        }
    }
}

