/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class CLAHE
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    private int tileGridSize = 8;
    private double clipLimit = 40.0;
    private boolean autoConvertToGrayscale = false;

    public int getTileGridSize() {
        return this.tileGridSize;
    }

    public void setTileGridSize(int tileGridSize) {
        this.tileGridSize = CLAHE.positive((int)tileGridSize);
    }

    public double getClipLimit() {
        return this.clipLimit;
    }

    public void setClipLimit(double clipLimit) {
        this.clipLimit = clipLimit;
    }

    public boolean isAutoConvertToGrayscale() {
        return this.autoConvertToGrayscale;
    }

    public void setAutoConvertToGrayscale(boolean autoConvertToGrayscale) {
        this.autoConvertToGrayscale = autoConvertToGrayscale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Mat result, Mat source) {
        Mat mat = source;
        try {
            if (this.autoConvertToGrayscale) {
                mat = OTools.toMonoIfNot(mat);
            }
            try (Size size = new Size(this.tileGridSize, this.tileGridSize);
                 org.bytedeco.opencv.opencv_imgproc.CLAHE clahe = opencv_imgproc.createCLAHE((double)this.clipLimit, (Size)size);){
                CLAHE.logDebug(() -> "CLAHE: grid tile " + this.tileGridSize + "x" + this.tileGridSize + ", clipLimit " + this.clipLimit + " (source: " + source + ")");
                clahe.apply(mat, result);
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(UMat result, UMat source) {
        UMat mat = source;
        try {
            if (this.autoConvertToGrayscale) {
                mat = OTools.toMonoIfNot(mat);
            }
            try (Size size = new Size(this.tileGridSize, this.tileGridSize);
                 org.bytedeco.opencv.opencv_imgproc.CLAHE clahe = opencv_imgproc.createCLAHE((double)this.clipLimit, (Size)size);){
                CLAHE.logDebug(() -> "CLAHE (GPU): grid tile " + this.tileGridSize + "x" + this.tileGridSize + ", clipLimit " + this.clipLimit + " (source: " + source + ")");
                clahe.apply(mat, result);
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }
}

