/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.features;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Canny
extends VoidResultUMatFilter
implements ReadOnlyExecutionInput {
    private double thresholdLower = 0.1;
    private double thresholdUpper = 0.3;
    private int kernelSizeSobel = 3;
    private boolean moreAccurateGradient = false;

    public double getThresholdLower() {
        return this.thresholdLower;
    }

    public void setThresholdLower(double thresholdLower) {
        this.thresholdLower = Canny.nonNegative((double)thresholdLower);
    }

    public double getThresholdUpper() {
        return this.thresholdUpper;
    }

    public void setThresholdUpper(double thresholdUpper) {
        this.thresholdUpper = Canny.nonNegative((double)thresholdUpper);
    }

    public int getKernelSizeSobel() {
        return this.kernelSizeSobel;
    }

    public void setKernelSizeSobel(int kernelSizeSobel) {
        this.kernelSizeSobel = Canny.positive((int)kernelSizeSobel);
    }

    public boolean isMoreAccurateGradient() {
        return this.moreAccurateGradient;
    }

    public void setMoreAccurateGradient(boolean moreAccurateGradient) {
        this.moreAccurateGradient = moreAccurateGradient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Mat result, Mat source) {
        Mat mat = source;
        try {
            mat = OTools.to8UIfNot(mat);
            double scale = OTools.maxPossibleValue(mat);
            opencv_imgproc.Canny((Mat)mat, (Mat)result, (double)(this.thresholdLower * scale), (double)(this.thresholdUpper * scale), (int)this.kernelSizeSobel, (boolean)this.moreAccurateGradient);
        }
        finally {
            if (mat != source) {
                mat.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(UMat result, UMat source) {
        UMat mat = source;
        try {
            mat = OTools.to8UIfNot(mat);
            double scale = OTools.maxPossibleValue(mat);
            opencv_imgproc.Canny((UMat)mat, (UMat)result, (double)(this.thresholdLower * scale), (double)(this.thresholdUpper * scale), (int)this.kernelSizeSobel, (boolean)this.moreAccurateGradient);
        }
        finally {
            if (mat != source) {
                mat.close();
            }
        }
    }
}

