/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.copying;

import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.UMat;

public final class FillMat
extends UMatFilter {
    private String color = "#FFFFFF";
    private double grayscaleValue = 0.0;
    private boolean rawGrayscaleValue = false;

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = (String)FillMat.nonNull((Object)color);
    }

    public double getGrayscaleValue() {
        return this.grayscaleValue;
    }

    public void setGrayscaleValue(double grayscaleValue) {
        this.grayscaleValue = grayscaleValue;
    }

    public boolean isRawGrayscaleValue() {
        return this.rawGrayscaleValue;
    }

    public void setRawGrayscaleValue(boolean rawGrayscaleValue) {
        this.rawGrayscaleValue = rawGrayscaleValue;
    }

    @Override
    public UMat process(UMat source) {
        double maxPossibleValue = OTools.maxPossibleValue(source);
        try (Scalar scalar = this.color.trim().isEmpty() ? OTools.scalarBGR(this.rawGrayscaleValue ? this.grayscaleValue : this.grayscaleValue * maxPossibleValue) : OTools.scalarBGRA(this.color, maxPossibleValue);){
            source.put(scalar);
            UMat uMat = source;
            return uMat;
        }
    }

    @Override
    public Mat process(Mat source) {
        double maxPossibleValue = OTools.maxPossibleValue(source);
        try (Scalar scalar = this.color.trim().isEmpty() ? OTools.scalarBGR(this.rawGrayscaleValue ? this.grayscaleValue : this.grayscaleValue * maxPossibleValue) : OTools.scalarBGRA(this.color, maxPossibleValue);){
            source.put(scalar);
            Mat mat = source;
            return mat;
        }
    }
}

