/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.markers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.core.matrices.arithmetic.CheckMatrixEquality;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class LabelPaintedMarkers
extends MultiMatrix2DFilter {
    public static final String INPUT_PALETTE = "palette";
    public static final String INPUT_IMAGE_WITH_MARKERS = "image_with_markers";
    public static final String INPUT_IMAGE_WITHOUT_MARKERS = "image_without_markers";
    public static final String OUTPUT_PALETTE = "palette";
    public static final String OUTPUT_LABELS = "labels";

    public LabelPaintedMarkers() {
        this.useVisibleResultParameter();
        this.addInputNumbers("palette");
        this.setDefaultInputMat(INPUT_IMAGE_WITH_MARKERS);
        this.addInputMat(INPUT_IMAGE_WITHOUT_MARKERS);
        this.setDefaultOutputMat(OUTPUT_LABELS);
        this.addOutputNumbers("palette");
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        SNumbers colorMap = this.getInputNumbers("palette", true);
        SMat imageWithoutMarkers = this.getInputMat(INPUT_IMAGE_WITHOUT_MARKERS, true);
        MultiMatrix2D result = this.process(source, imageWithoutMarkers.toMultiMatrix2D(), colorMap);
        this.getNumbers("palette").setTo(colorMap);
        return result;
    }

    public MultiMatrix2D process(MultiMatrix2D imageWithMarkers, MultiMatrix2D imageWithoutMarkers, SNumbers colorMap) {
        Objects.requireNonNull(imageWithMarkers, "Null imageWithMarkers");
        Objects.requireNonNull(colorMap, "Null colorMap");
        imageWithMarkers.checkDimensionEquality((MultiMatrix)imageWithoutMarkers, "image with markers", "image without markers");
        int numberOfChannels = imageWithMarkers.numberOfChannels();
        if (colorMap.isInitialized() && colorMap.getBlockLength() < numberOfChannels) {
            throw new IllegalArgumentException("Too little blocks in colorMap: at least " + numberOfChannels + " columns required");
        }
        if (imageWithoutMarkers != null) {
            try (CheckMatrixEquality checkMatrixEquality = new CheckMatrixEquality();){
                imageWithMarkers = checkMatrixEquality.setOperation(CheckMatrixEquality.Operation.E0_NX).process(new MultiMatrix[]{imageWithMarkers, imageWithoutMarkers}).asMultiMatrix2D();
            }
        }
        assert (imageWithMarkers.numberOfChannels() == numberOfChannels);
        UpdatableBitArray nonZerosArray = ((BitArray)imageWithMarkers.nonZeroRGBMatrix().array()).updatableClone((MemoryModel)Arrays.SMM);
        imageWithMarkers = imageWithMarkers.asPrecision(Double.TYPE);
        HashMap<MultiMatrix.PixelValue, Integer> map = new HashMap<MultiMatrix.PixelValue, Integer>();
        int markerCount = 0;
        if (colorMap.isInitialized()) {
            double[] channels = null;
            int n = colorMap.n();
            for (int k = 0; k < n; ++k) {
                MultiMatrix.PixelValue pixel = MultiMatrix.PixelValue.valueOf((Object)(channels = colorMap.getBlockDoubleValues(k, channels)));
                if (map.putIfAbsent(pixel, markerCount + 1) != null) continue;
                ++markerCount;
            }
        }
        UpdatableIntArray result = Arrays.SMM.newUnresizableIntArray(nonZerosArray.length());
        long n = nonZerosArray.length();
        for (long index = 0L; index < n; ++index) {
            if (!nonZerosArray.getBit(index)) continue;
            MultiMatrix.PixelValue pixel = imageWithMarkers.getPixel(index);
            assert (pixel.numberOfChannels() == imageWithMarkers.numberOfChannels());
            Integer currentMarkerIndex = map.putIfAbsent(pixel, markerCount + 1);
            if (currentMarkerIndex != null) {
                result.setInt(index, currentMarkerIndex.intValue());
                continue;
            }
            result.setInt(index, markerCount + 1);
            ++markerCount;
        }
        assert (markerCount == map.size());
        colorMap.setToZeros(Double.TYPE, markerCount, numberOfChannels);
        for (Map.Entry entry : map.entrySet()) {
            int markerIndex = (Integer)entry.getValue();
            assert (markerIndex - 1 < markerCount);
            colorMap.setBlockValues(markerIndex - 1, (Object)((MultiMatrix.PixelValue)entry.getKey()).getDoubleChannels());
        }
        return MultiMatrix.valueOf2DMono((Matrix)Matrices.matrix((Array)result, (long[])imageWithMarkers.dimensions()));
    }
}

