/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.BitArray;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.IntArray;
import net.algart.arrays.IntJArrayHolder;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator;
import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesCalculator;
import net.algart.executors.modules.cv.matrices.objects.labels.FirstNonZeroCalculator;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelledObjectsProcessor;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelsListsBuilder;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinder;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderByLastChannel;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinderForSeparateChannels;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class LabelsAnalyser {
    private int[] labels;
    private boolean labelsMustBeImmutable;
    private Object[] channels;
    private Object[] channelsForPercentiles;
    private double[][] percentileLevelByChannels = new double[0][0];
    private int maxNumberOfPercentileLevels = 0;
    private boolean needTruncatedMeans = false;
    private boolean useCommonLevelChannelForPercentiles = false;
    private boolean[] separateChannelPercentilesSet = new boolean[0];
    private int lowTruncatedMeanIndex = 0;
    private int highTruncatedMeanIndex = 0;
    private Class<?> elementType;
    private double scale;
    private int maxLabel = Integer.MIN_VALUE;
    private int[] cardinalities;
    private double[] sums;
    private double[] sumsOfSquares;
    private int[] lists;
    private int[] listHeads;
    private float[][][] percentilesByChannels;
    private float[][] groupedPercentilesByLevels;
    private float[] truncatedMeans;
    private int[] firstNonZeroIndexes;
    private int[] firstNonZeroIntValues;
    private float[] firstNonZeroFloatValues;
    private IntJArrayHolder labelsHolder = new IntJArrayHolder();
    private IntJArrayHolder listsHolder = new IntJArrayHolder();

    public LabelsAnalyser setLabels(MultiMatrix2D labelsMatrix) {
        return this.setLabels(labelsMatrix, null);
    }

    public LabelsAnalyser setLabels(MultiMatrix2D labelsMatrix, MultiMatrix2D maskMatrix) {
        boolean labelsMustBeImmutable;
        DirectAccessible da;
        Objects.requireNonNull(labelsMatrix, "Null labelsMatrix");
        labelsMatrix.checkDimensionEquality((MultiMatrix)maskMatrix, "labels", "mask");
        Matrix labelsChannel = labelsMatrix.channel(0);
        int[] labels = null;
        PArray labelsArray = (PArray)labelsChannel.array();
        if (labelsArray.elementType() == Integer.TYPE && labelsArray instanceof DirectAccessible && (da = (DirectAccessible)labelsArray).hasJavaArray() && da.javaArrayOffset() == 0) {
            labels = (int[])da.javaArray();
        }
        boolean bl = labelsMustBeImmutable = labels != null;
        if (labels == null) {
            labels = Matrices.toIntJavaArray((int[])this.labelsHolder.quickNew(labelsChannel), (Matrix)labelsChannel);
        }
        if (maskMatrix != null) {
            BitArray maskArray = (BitArray)maskMatrix.nonZeroPixelsMatrix(false).array();
            if (labelsMustBeImmutable) {
                labels = this.labelsHolder.quickClone(labels);
                labelsMustBeImmutable = false;
            }
            net.algart.arrays.Arrays.unpackZeroBits((UpdatablePArray)IntArray.as((int[])labels), (BitArray)maskArray, (double)0.0);
        }
        this.labels = labels;
        this.labelsMustBeImmutable = labelsMustBeImmutable;
        return this;
    }

    public LabelsAnalyser setImage(MultiMatrix2D image, boolean rawValues) {
        Objects.requireNonNull(image, "Null image");
        this.channels = LabelsAnalyser.retrieveChannelsOrFloats(image);
        this.channelsForPercentiles = this.channels;
        this.useCommonLevelChannelForPercentiles = false;
        this.elementType = this.channels[0].getClass().getComponentType();
        this.scale = rawValues ? 1.0 : 1.0 / image.maxPossibleValue();
        return this;
    }

    public LabelsAnalyser setImageAndLevelMatrix(MultiMatrix2D image, Matrix<? extends PArray> levels, boolean rawValues) {
        Objects.requireNonNull(image, "Null image");
        Objects.requireNonNull(levels, "Null levels");
        image.checkDimensionEquality((MultiMatrix)MultiMatrix.valueOf2DMono(levels), "image", "levels");
        ArrayList<Matrix<? extends PArray>> channelList = new ArrayList<Matrix<? extends PArray>>(image.allChannels());
        channelList.add(levels);
        channelList.add(levels);
        boolean forceFloat = levels.elementType() != image.elementType();
        this.channelsForPercentiles = LabelsAnalyser.retrieveChannelsOrFloats(channelList, forceFloat);
        this.channels = Arrays.copyOfRange(this.channelsForPercentiles, 0, this.channelsForPercentiles.length - 2);
        this.useCommonLevelChannelForPercentiles = true;
        this.elementType = this.channels[0].getClass().getComponentType();
        this.scale = rawValues ? 1.0 : 1.0 / image.maxPossibleValue();
        return this;
    }

    public LabelsAnalyser setSeparateChannelPercentilesSet(boolean[] separateChannelPercentilesSet) {
        Objects.requireNonNull(separateChannelPercentilesSet, "Null separateChannelPercentilesSet");
        this.separateChannelPercentilesSet = (boolean[])separateChannelPercentilesSet.clone();
        return this;
    }

    public void findCardinalities() {
        this.checkInitialized();
        try (CardinalitiesCalculator processor = new CardinalitiesCalculator(this.labels);){
            processor.process();
            this.maxLabel = processor.maxLabel;
            this.cardinalities = processor.cardinalities;
        }
    }

    public void findMeansAndCardinalities() {
        this.checkImageInitialized();
        try (CardinalitiesAndSumsCalculator processor = CardinalitiesAndSumsCalculator.getInstance(this.labels, this.channels);){
            processor.process();
            this.maxLabel = processor.maxLabel;
            this.cardinalities = processor.cardinalities;
            this.sums = processor.sums;
            LabelsAnalyser.scaleValues(this.sums, this.scale);
        }
    }

    public void findMeansAndStandardDeviationsAndCardinalities() {
        this.checkImageInitialized();
        try (CardinalitiesAndSumsOfSquaresCalculator processor = CardinalitiesAndSumsOfSquaresCalculator.getInstance(this.labels, this.channels);){
            processor.process();
            this.maxLabel = processor.maxLabel;
            this.cardinalities = processor.cardinalities;
            this.sums = processor.sums;
            this.sumsOfSquares = processor.sumsOfSquares;
            LabelsAnalyser.scaleValues(this.sums, this.scale);
            LabelsAnalyser.scaleValues(this.sumsOfSquares, this.scale * this.scale);
        }
    }

    public void prepareLists() {
        this.checkInitialized();
        this.lists = this.listsHolder.quickNew(this.labels.length);
        try (LabelsListsBuilder processor = LabelsListsBuilder.getInstance(this.labels, this.lists);){
            processor.process();
            this.maxLabel = processor.maxLabel();
            this.listHeads = processor.listHeads();
        }
    }

    public LabelsAnalyser setPercentileLevelByChannels(double[][] percentileLevelByChannels) {
        Objects.requireNonNull(percentileLevelByChannels, "Null percentileLevelsForChannels");
        this.percentileLevelByChannels = (double[][])percentileLevelByChannels.clone();
        int maxNumber = 0;
        for (int k = 0; k < percentileLevelByChannels.length; ++k) {
            this.percentileLevelByChannels[k] = (double[])this.percentileLevelByChannels[k].clone();
            maxNumber = Math.max(maxNumber, this.percentileLevelByChannels[k].length);
        }
        this.maxNumberOfPercentileLevels = maxNumber;
        return this;
    }

    public LabelsAnalyser setNeedTruncatedMeans(boolean needTruncatedMeans) {
        this.needTruncatedMeans = needTruncatedMeans;
        return this;
    }

    public LabelsAnalyser setLowTruncatedMeanIndex(int lowTruncatedMeanIndex) {
        this.lowTruncatedMeanIndex = lowTruncatedMeanIndex;
        return this;
    }

    public LabelsAnalyser setHighTruncatedMeanIndex(int highTruncatedMeanIndex) {
        this.highTruncatedMeanIndex = highTruncatedMeanIndex;
        return this;
    }

    public void findPercentilesAndCardinalities() {
        this.checkImageInitialized();
        this.checkListsInitialized();
        int lowTruncatedMeanIndex = this.needTruncatedMeans ? this.lowTruncatedMeanIndex : -1;
        int highTruncatedMeanIndex = this.needTruncatedMeans ? this.highTruncatedMeanIndex : -1;
        try (PercentilesFinder percentilesFinder = this.useCommonLevelChannelForPercentiles ? PercentilesFinderByLastChannel.getInstance(this.channelsForPercentiles.length, this.maxLabel, this.percentileLevelByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex, this.separateChannelPercentilesSet) : new PercentilesFinderForSeparateChannels(this.channelsForPercentiles.length, this.channelsForPercentiles.length, this.maxLabel, this.percentileLevelByChannels, lowTruncatedMeanIndex, highTruncatedMeanIndex);
             LabelledObjectsProcessor processor = LabelledObjectsProcessor.getInstance(this.lists, this.listHeads, percentilesFinder, this.channelsForPercentiles);){
            percentilesFinder.preprocess(this.elementType, processor.numberOfTasks());
            processor.process();
            this.cardinalities = processor.cardinalities;
            this.percentilesByChannels = percentilesFinder.percentilesByChannels();
            this.groupedPercentilesByLevels = new float[this.maxNumberOfPercentileLevels][];
            float[][] percentileForSingleLevel = new float[this.percentilesByChannels.length][];
            for (int p = 0; p < this.maxNumberOfPercentileLevels; ++p) {
                for (int c = 0; c < this.percentilesByChannels.length; ++c) {
                    if (p < this.percentilesByChannels[c].length) {
                        percentileForSingleLevel[c] = this.percentilesByChannels[c][p];
                        continue;
                    }
                    percentileForSingleLevel[c] = new float[this.maxLabel];
                    JArrays.fillFloatArray((float[])percentileForSingleLevel[c], (float)Float.NaN);
                }
                this.groupedPercentilesByLevels[p] = LabelsAnalyser.combineMultiChannel(percentileForSingleLevel, this.scale);
            }
            float[][] truncatedMeansByChannels = percentilesFinder.truncatedMeansByChannels();
            this.truncatedMeans = truncatedMeansByChannels != null ? LabelsAnalyser.combineMultiChannel(truncatedMeansByChannels, this.scale) : null;
        }
    }

    public void findFirstNonZeroPixels() {
        this.checkImageInitialized();
        try (FirstNonZeroCalculator processor = FirstNonZeroCalculator.getInstance(this.labels, this.channels);){
            processor.process();
            this.maxLabel = processor.maxLabel;
            this.cardinalities = processor.cardinalities;
            this.firstNonZeroIndexes = processor.firstNonZeroIndexes;
            this.firstNonZeroIntValues = processor.firstNonZeroIntValues;
            this.firstNonZeroFloatValues = processor.firstNonZeroFloatValues;
        }
    }

    public int maxLabel() {
        return this.maxLabel;
    }

    public int[] unsafeLabels() {
        return this.labels;
    }

    public boolean unsafeLabelsMustBeImmutable() {
        return this.labelsMustBeImmutable;
    }

    public int[] labelsWithCloningIfNecessary() {
        return this.labelsMustBeImmutable ? (int[])this.labels.clone() : this.labels;
    }

    public boolean isReadyCardinalities() {
        return this.cardinalities != null;
    }

    public int[] cardinalities() {
        return this.cardinalities;
    }

    public boolean isReadySums() {
        return this.sums != null;
    }

    public double[] sums() {
        return this.sums;
    }

    public float[] means() {
        return LabelsAnalyser.averageValues(this.sums, this.cardinalities, this.channels.length);
    }

    public boolean isReadySumsOfSquares() {
        return this.sumsOfSquares != null;
    }

    public double[] sumOfSquares() {
        return this.sumsOfSquares;
    }

    public float[] meanSquares() {
        return LabelsAnalyser.averageValues(this.sumsOfSquares, this.cardinalities, this.channels.length);
    }

    public float[] standardDeviations() {
        return LabelsAnalyser.standardDeviations(this.sums, this.sumsOfSquares, this.cardinalities, this.channels.length);
    }

    public boolean isReadyLists() {
        return this.lists != null;
    }

    public int[] lists() {
        return this.lists;
    }

    public int[] listHeads() {
        return this.listHeads;
    }

    public boolean isReadyPercentiles() {
        return this.percentilesByChannels != null;
    }

    public float[][][] percentilesByChannels() {
        return this.percentilesByChannels;
    }

    public float[][] percentiles(int channelIndex) {
        return this.percentilesByChannels[channelIndex];
    }

    public float[] groupedPercentilesByLevel(int levelIndex) {
        return levelIndex < this.groupedPercentilesByLevels.length ? this.groupedPercentilesByLevels[levelIndex] : null;
    }

    public float[] percentilesRange(int percentileIndex1, int percentileIndex2) {
        float[] percentiles1 = this.groupedPercentilesByLevel(percentileIndex1);
        float[] percentiles2 = this.groupedPercentilesByLevel(percentileIndex2);
        if (percentiles1 == null || percentiles2 == null) {
            return null;
        }
        assert (percentiles1.length == percentiles2.length);
        float[] result = new float[percentiles1.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = percentiles2[k] - percentiles1[k];
        }
        return result;
    }

    public boolean isReadyTruncatedMeans() {
        return this.truncatedMeans != null;
    }

    public float[] truncatedMeans() {
        return this.truncatedMeans;
    }

    public boolean isReadyFirstNonZeroInformation() {
        return this.firstNonZeroIndexes != null;
    }

    public int[] firstNonZeroIndexes() {
        return this.firstNonZeroIndexes;
    }

    public boolean isFirstNonZeroValuesInteger() {
        return this.firstNonZeroIntValues != null;
    }

    public int[] firstNonZeroIntValues() {
        return this.firstNonZeroIntValues;
    }

    public float[] firstNonZeroFloatValues() {
        return this.firstNonZeroFloatValues;
    }

    public Object firstNonZeroValues() {
        return this.firstNonZeroIntValues != null ? this.firstNonZeroIntValues : (int[])this.firstNonZeroFloatValues;
    }

    public float[] firstNonZeroFloatValues(boolean autoConvertFromIntValues) {
        if (autoConvertFromIntValues && this.firstNonZeroFloatValues == null) {
            float[] result = new float[this.firstNonZeroIntValues.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = (float)((double)this.firstNonZeroIntValues[k] * this.scale);
            }
            return result;
        }
        return this.firstNonZeroFloatValues;
    }

    private void checkInitialized() {
        if (this.labels == null) {
            throw new IllegalStateException("Object is not initialized: labels are not set");
        }
    }

    private void checkImageInitialized() {
        this.checkInitialized();
        if (this.channels == null) {
            throw new IllegalStateException("Object is not completely initialized: image for processing is not set");
        }
    }

    private void checkListsInitialized() {
        this.checkInitialized();
        if (!this.isReadyLists()) {
            throw new IllegalStateException("Lists of pixels are not built: prepareLists() was not called yet");
        }
    }

    private static Object[] retrieveChannelsOrFloats(MultiMatrix2D matrix) {
        return LabelsAnalyser.retrieveChannelsOrFloats(matrix.allChannels(), false);
    }

    private static Object[] retrieveChannelsOrFloats(List<Matrix<? extends PArray>> channels, boolean forceFloat) {
        boolean direct;
        boolean bl = direct = !forceFloat;
        if (!forceFloat) {
            for (Matrix<? extends PArray> channel : channels) {
                PArray array = (PArray)channel.array();
                direct &= array instanceof DirectAccessible && ((DirectAccessible)array).hasJavaArray() && ((DirectAccessible)array).javaArrayOffset() == 0 && CardinalitiesAndSumsCalculator.isArraySupported(((DirectAccessible)array).javaArray());
            }
        }
        Object[] result = new Object[channels.size()];
        if (direct) {
            for (int k = 0; k < result.length; ++k) {
                result[k] = ((DirectAccessible)channels.get(k).array()).javaArray();
            }
        } else {
            for (int k = 0; k < result.length; ++k) {
                Matrix<? extends PArray> m = channels.get(k);
                result[k] = !forceFloat && (m.elementType() == Boolean.TYPE || m.elementType() == Byte.TYPE) ? (Object)Matrices.toByteJavaArray(m) : (Object)Matrices.toFloatJavaArray(m);
            }
        }
        return result;
    }

    private static float[] combineMultiChannel(float[][] channelValues, double scale) {
        int length = channelValues[0].length;
        int numberOfChannels = channelValues.length;
        if ((long)length * (long)numberOfChannels > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large required array for " + numberOfChannels + " channels: more that 2^31-1 elements");
        }
        float[] result = new float[numberOfChannels * length];
        int k = 0;
        int disp = 0;
        while (k < length) {
            for (int c = 0; c < numberOfChannels; ++c) {
                result[disp + c] = (float)((double)channelValues[c][k] * scale);
            }
            ++k;
            disp += numberOfChannels;
        }
        return result;
    }

    private static void scaleValues(double[] values, double scale) {
        int k = 0;
        while (k < values.length) {
            int n = k++;
            values[n] = values[n] * scale;
        }
    }

    private static float[] averageValues(double[] values, int[] cardinalities, int numberOfChannels) {
        assert (numberOfChannels * cardinalities.length == values.length);
        float[] result = new float[values.length];
        int k = 0;
        int disp = 0;
        while (k < cardinalities.length) {
            for (int c = 0; c < numberOfChannels; ++c) {
                result[disp + c] = (float)(values[disp + c] / (double)cardinalities[k]);
            }
            ++k;
            disp += numberOfChannels;
        }
        return result;
    }

    private static float[] standardDeviations(double[] sums, double[] sumsOfSquares, int[] cardinalities, int numberOfChannels) {
        assert (numberOfChannels * cardinalities.length == sums.length);
        float[] result = new float[sums.length];
        int k = 0;
        int disp = 0;
        while (k < cardinalities.length) {
            for (int c = 0; c < numberOfChannels; ++c) {
                double mean = sums[disp + c] / (double)cardinalities[k];
                double meanSquare = sumsOfSquares[disp + c] / (double)cardinalities[k];
                double variance = Math.max(meanSquare - mean * mean, 0.0);
                result[disp + c] = (float)Math.sqrt(variance);
            }
            ++k;
            disp += numberOfChannels;
        }
        return result;
    }
}

