/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.components;

import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableBitArray;
import net.algart.matrices.scanning.ConnectedObjectScanner;
import net.algart.matrices.scanning.ConnectivityType;

public enum ConnectedObjectScanningAlgorithm {
    QUICKEN,
    BREADTH_FIRST,
    DEPTH_FIRST;

    public static final long MAX_MEMORY_FOR_QUICKEN_VERSION;

    public ConnectedObjectScanner connectedObjectScanner(Matrix<? extends UpdatableBitArray> bitMatrix, ConnectivityType connectivityType, boolean checked) {
        boolean littleEnough = bitMatrix.size() <= MAX_MEMORY_FOR_QUICKEN_VERSION;
        switch (this) {
            case DEPTH_FIRST: {
                return checked ? ConnectedObjectScanner.getDepthFirstScanner(bitMatrix, (ConnectivityType)connectivityType) : ConnectedObjectScanner.getUncheckedDepthFirstScanner(bitMatrix, (ConnectivityType)connectivityType);
            }
            case QUICKEN: {
                if (littleEnough) {
                    return checked ? ConnectedObjectScanner.getStacklessDepthFirstScanner(bitMatrix, (ConnectivityType)connectivityType) : ConnectedObjectScanner.getUncheckedStacklessDepthFirstScanner(bitMatrix, (ConnectivityType)connectivityType);
                }
            }
            case BREADTH_FIRST: {
                return checked ? ConnectedObjectScanner.getBreadthFirstScanner(bitMatrix, (ConnectivityType)connectivityType) : ConnectedObjectScanner.getUncheckedBreadthFirstScanner(bitMatrix, (ConnectivityType)connectivityType);
            }
        }
        throw new AssertionError((Object)("Unknown algorithm " + this));
    }

    static {
        MAX_MEMORY_FOR_QUICKEN_VERSION = Arrays.SystemSettings.maxTempJavaMemory();
    }
}

