/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Locale;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public final class TransformContours
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String OUTPUT_PACKED_CONTOURS = "contours";
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private double shiftX = 0.0;
    private double shiftY = 0.0;
    private boolean removeDegeneratedContours = false;

    public TransformContours() {
        this.setDefaultInputNumbers("contours");
        this.setDefaultOutputNumbers("contours");
        this.addOutputScalar("number_of_objects");
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public TransformContours setScaleX(double scaleX) {
        this.scaleX = scaleX;
        return this;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public TransformContours setScaleY(double scaleY) {
        this.scaleY = scaleY;
        return this;
    }

    public double getShiftX() {
        return this.shiftX;
    }

    public TransformContours setShiftX(double shiftX) {
        this.shiftX = shiftX;
        return this;
    }

    public double getShiftY() {
        return this.shiftY;
    }

    public TransformContours setShiftY(double shiftY) {
        this.shiftY = shiftY;
        return this;
    }

    public boolean isRemoveDegeneratedContours() {
        return this.removeDegeneratedContours;
    }

    public TransformContours setRemoveDegeneratedContours(boolean removeDegeneratedContours) {
        this.removeDegeneratedContours = removeDegeneratedContours;
        return this;
    }

    protected SNumbers processNumbers(SNumbers source) {
        Contours contours = Contours.deserialize((int[])source.toIntArray());
        long t1 = TransformContours.debugTime();
        Contours result = contours.transformContours(this.scaleX, this.scaleY, this.shiftX, this.shiftY, this.removeDegeneratedContours);
        long t2 = TransformContours.debugTime();
        TransformContours.logDebug(() -> String.format(Locale.US, "%d contours transformed to %d contours in %.3f ms, %.5f mcs/contour", contours.numberOfContours(), result.numberOfContours(), (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001 / (double)contours.numberOfContours()));
        this.getScalar("number_of_objects").setTo(result.numberOfContours());
        return SNumbers.valueOf((Contours)result);
    }
}

