/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableDoubleArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.MutableLongArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.PNumberArray;
import net.algart.contours.ContourHeader;
import net.algart.contours.Contours;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrixToNumbers;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.AbstractScanAndMeasureBoundaries;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundariesScanner;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundaryType;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.ScanAndMeasureBoundaries;
import net.algart.math.IPoint;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.Boundary2DWrapper;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.matrices.scanning.ContourLineType;
import net.algart.multimatrix.MultiMatrix;

public final class ScanAndExtractContours
extends MultiMatrixToNumbers {
    public static final String INPUT_POSITION = "position";
    public static final String OUTPUT_CONTOURS = "contours";
    public static final String OUTPUT_STRICT_AREA = "strict_area";
    public static final String OUTPUT_SEGMENT_CENTERS_AREA = "segment_centers_area";
    public static final String OUTPUT_STRICT_PERIMETER = "strict_perimeter";
    public static final String OUTPUT_SEGMENT_CENTERS_PERIMETER = "segment_centers_perimeter";
    private ConnectivityType connectivityType = ConnectivityType.STRAIGHT_ONLY;
    private BoundaryType boundaryType = BoundaryType.ALL_BOUNDARIES;
    private AbstractScanAndMeasureBoundaries.ObjectValues objectsInterpretation = AbstractScanAndMeasureBoundaries.ObjectValues.NON_ZERO_LABELS;
    private Integer frameId = null;
    private int startX = 0;
    private int startY = 0;
    private boolean optimizeCollinearSteps = false;

    public ScanAndExtractContours() {
        this.useVisibleResultParameter();
        this.setDefaultInputMat("objects");
        this.addInputNumbers(INPUT_POSITION);
        this.setDefaultOutputNumbers(OUTPUT_CONTOURS);
        this.addOutputMat("labels");
        this.addOutputNumbers("object_label");
        this.addOutputNumbers(OUTPUT_STRICT_AREA);
        this.addOutputNumbers(OUTPUT_SEGMENT_CENTERS_AREA);
        this.addOutputNumbers(OUTPUT_STRICT_PERIMETER);
        this.addOutputNumbers(OUTPUT_SEGMENT_CENTERS_PERIMETER);
        this.addOutputNumbers("internal_boundary");
        this.addOutputScalar("number_of_objects");
    }

    public ConnectivityType getConnectivityType() {
        return this.connectivityType;
    }

    public ScanAndExtractContours setConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = (ConnectivityType)ScanAndExtractContours.nonNull((Object)connectivityType);
        return this;
    }

    public BoundaryType getBoundaryType() {
        return this.boundaryType;
    }

    public ScanAndExtractContours setBoundaryType(BoundaryType boundaryType) {
        this.boundaryType = (BoundaryType)((Object)ScanAndExtractContours.nonNull((Object)((Object)boundaryType)));
        return this;
    }

    public AbstractScanAndMeasureBoundaries.ObjectValues getObjectsInterpretation() {
        return this.objectsInterpretation;
    }

    public ScanAndExtractContours setObjectsInterpretation(AbstractScanAndMeasureBoundaries.ObjectValues objectsInterpretation) {
        this.objectsInterpretation = (AbstractScanAndMeasureBoundaries.ObjectValues)((Object)ScanAndExtractContours.nonNull((Object)((Object)objectsInterpretation)));
        return this;
    }

    public Integer getFrameId() {
        return this.frameId;
    }

    public ScanAndExtractContours setFrameId(Integer frameId) {
        this.frameId = frameId;
        return this;
    }

    public int getStartX() {
        return this.startX;
    }

    public ScanAndExtractContours setStartX(int startX) {
        this.startX = startX;
        return this;
    }

    public int getStartY() {
        return this.startY;
    }

    public ScanAndExtractContours setStartY(int startY) {
        this.startY = startY;
        return this;
    }

    public boolean isOptimizeCollinearSteps() {
        return this.optimizeCollinearSteps;
    }

    public ScanAndExtractContours setOptimizeCollinearSteps(boolean optimizeCollinearSteps) {
        this.optimizeCollinearSteps = optimizeCollinearSteps;
        return this;
    }

    public SNumbers analyse(MultiMatrix source) {
        SNumbers position = this.getInputNumbers(INPUT_POSITION, true);
        IPoint originPoint = position.isProbableRectangularArea() ? position.toIRectangularArea().min() : position.toIPoint();
        return this.analyse(BoundariesScanner.toObjects(source, this.objectsInterpretation.binaryOnly()), originPoint);
    }

    public SNumbers analyse(Matrix<? extends PFixedArray> objects, IPoint originPoint) {
        if (originPoint != null && originPoint.coordCount() != objects.dimCount()) {
            throw new IllegalArgumentException("Different number of dimensions: " + originPoint.coordCount() + "-dimensional point (" + originPoint + ") and " + objects.dimCount() + "-dimensional matrix (" + objects + ")");
        }
        final long startX = originPoint == null ? (long)this.startX : originPoint.x();
        final long startY = originPoint == null ? (long)this.startY : originPoint.y();
        boolean resultLabelsRequired = this.isOutputNecessary("labels");
        MutableIntArray objectLabelArray = Arrays.SMM.newEmptyIntArray();
        MutableBitArray internalBoundaryFlags = Arrays.SMM.newEmptyBitArray();
        MutableLongArray strictArea = Arrays.SMM.newEmptyLongArray();
        MutableDoubleArray segmentCentersArea = Arrays.SMM.newEmptyDoubleArray();
        MutableIntArray contourLength = Arrays.SMM.newEmptyIntArray();
        MutableDoubleArray segmentCentersPerimeter = Arrays.SMM.newEmptyDoubleArray();
        BoundariesScanner scanner = new BoundariesScanner(objects, this.getConnectivityType(), this.getBoundaryType(), false, resultLabelsRequired, Long.MAX_VALUE);
        Boundary2DScanner boundaryScanner = scanner.getBoundaryScanner();
        final Contours contours = Contours.newInstance().setOptimizeCollinearSteps(this.optimizeCollinearSteps);
        scanner.setBoundaryMeasurer((Boundary2DScanner)new Boundary2DWrapper(boundaryScanner){

            public void next() {
                super.next();
                contours.addPoint(this.parent, startX, startY);
            }
        });
        scanner.setProcessBackgroundAsObject(this.getObjectsInterpretation().processBackgroundAsObject());
        ContourHeader header = new ContourHeader();
        if (this.frameId != null) {
            header.setFrameId(this.frameId.intValue());
        }
        while (scanner.nextBoundary()) {
            contours.openContourForAdding(header);
            scanner.scanAndProcess();
            long stepCount = boundaryScanner.stepCount();
            assert (stepCount == (long)((int)stepCount)) : "Contour2DArray.closeContour did not step count";
            header.setObjectLabel(scanner.currentLabel());
            header.setInternalContour(boundaryScanner.orientedArea() < 0L);
            contours.closeContour(header);
            if (scanner.needToAnalyseThisBoundary()) {
                objectLabelArray.addInt(scanner.currentLabel());
                internalBoundaryFlags.addBit(scanner.internalBoundary());
                strictArea.addLong(boundaryScanner.orientedArea());
                segmentCentersArea.addDouble(boundaryScanner.area(ContourLineType.SEGMENT_CENTERS_POLYLINE));
                contourLength.addLong(stepCount);
                segmentCentersPerimeter.addDouble(boundaryScanner.perimeter(ContourLineType.SEGMENT_CENTERS_POLYLINE));
                continue;
            }
            contours.removeLastContour();
        }
        ScanAndMeasureBoundaries.uploadSimpleOutputs((Executor)this, scanner, (IntArray)objectLabelArray, (BitArray)internalBoundaryFlags);
        ScanAndExtractContours.logDebug(() -> "Scanned " + scanner.objectCounter() + " contours, " + scanner.sideCounter() + " pixel sides");
        if (resultLabelsRequired) {
            this.getMat("labels").setTo((MultiMatrix)ScanAndMeasureBoundaries.getLabels(scanner));
        }
        if (this.isOutputNecessary(OUTPUT_STRICT_AREA)) {
            this.getNumbers(OUTPUT_STRICT_AREA).setTo((PNumberArray)strictArea, 1);
        }
        if (this.isOutputNecessary(OUTPUT_SEGMENT_CENTERS_AREA)) {
            this.getNumbers(OUTPUT_SEGMENT_CENTERS_AREA).setTo((PNumberArray)segmentCentersArea, 1);
        }
        if (this.isOutputNecessary(OUTPUT_STRICT_PERIMETER)) {
            this.getNumbers(OUTPUT_STRICT_PERIMETER).setTo((PNumberArray)contourLength, 1);
        }
        if (this.isOutputNecessary(OUTPUT_SEGMENT_CENTERS_PERIMETER)) {
            this.getNumbers(OUTPUT_SEGMENT_CENTERS_PERIMETER).setTo((PNumberArray)segmentCentersPerimeter, 1);
        }
        return SNumbers.valueOf((Contours)contours);
    }
}

