/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.arrays.Arrays;
import net.algart.contours.ContourHeader;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundaryParameter;
import net.algart.math.RectangularArea;

public final class RectanglesToContours
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_RECTANGLES = "rectangles";
    public static final String INPUT_OBJECT_LABEL = "object_label";
    public static final String OUTPUT_UNPACKED_CONTOURS = "contours";
    private int objectLabel = 1;
    private boolean internalContour = false;

    public RectanglesToContours() {
        this.setDefaultInputNumbers(INPUT_RECTANGLES);
        this.addInputNumbers(INPUT_OBJECT_LABEL);
        this.setDefaultOutputNumbers(OUTPUT_UNPACKED_CONTOURS);
    }

    public int getObjectLabel() {
        return this.objectLabel;
    }

    public RectanglesToContours setObjectLabel(int objectLabel) {
        this.objectLabel = objectLabel;
        return this;
    }

    public boolean isInternalContour() {
        return this.internalContour;
    }

    public RectanglesToContours setInternalContour(boolean internalContour) {
        this.internalContour = internalContour;
        return this;
    }

    protected SNumbers processNumbers(SNumbers source) {
        int[] nArray;
        source.requireBlockLength(4, INPUT_RECTANGLES);
        double[] rectangles = source.toDoubleArray();
        int[] labels = this.getInputNumbers(INPUT_OBJECT_LABEL, true).toIntArray();
        Contours contours = Contours.newInstance();
        ContourHeader header = new ContourHeader().setInternalContour(this.internalContour);
        int[] rectangularContour = new int[8];
        if (this.internalContour) {
            int[] nArray2 = new int[4];
            nArray2[0] = 6;
            nArray2[1] = 4;
            nArray2[2] = 2;
            nArray = nArray2;
            nArray2[3] = 0;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 0;
            nArray3[1] = 2;
            nArray3[2] = 4;
            nArray = nArray3;
            nArray3[3] = 6;
        }
        int[] order = nArray;
        int k = 0;
        for (int disp = 0; disp < rectangles.length; disp += 4) {
            RectangularArea r = BoundaryParameter.getRectangle(rectangles, disp);
            int minIntegerX = Arrays.round32((double)StrictMath.ceil(r.minX()));
            int minIntegerY = Arrays.round32((double)StrictMath.ceil(r.minY()));
            int maxIntegerX = Arrays.round32((double)StrictMath.floor(r.maxX()));
            int maxIntegerY = Arrays.round32((double)StrictMath.floor(r.maxY()));
            if (minIntegerX <= maxIntegerX && minIntegerY <= maxIntegerY) {
                rectangularContour[order[0]] = minIntegerX;
                rectangularContour[order[0] + 1] = minIntegerY;
                rectangularContour[order[1]] = RectanglesToContours.inc(maxIntegerX);
                rectangularContour[order[1] + 1] = minIntegerY;
                rectangularContour[order[2]] = RectanglesToContours.inc(maxIntegerX);
                rectangularContour[order[2] + 1] = RectanglesToContours.inc(maxIntegerY);
                rectangularContour[order[3]] = minIntegerX;
                rectangularContour[order[3] + 1] = RectanglesToContours.inc(maxIntegerY);
                header.setObjectLabel(labels != null && k < labels.length ? labels[k] : this.objectLabel);
                contours.addContour(header, rectangularContour);
            }
            ++k;
        }
        return SNumbers.valueOf((Contours)contours);
    }

    private static int inc(int i) {
        return i == Integer.MAX_VALUE ? Integer.MIN_VALUE : i + 1;
    }
}

