/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc.extremums;

import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.modules.cv.matrices.misc.SortedRound2DAperture;
import net.algart.executors.modules.cv.matrices.misc.extremums.ExtremumsFinder;

class MaximumsFinder
extends ExtremumsFinder {
    MaximumsFinder(float[] values, boolean[] mask, SortedRound2DAperture aperture, ExtremumsFinder.DeepTestSettings deepTestSettings, Matrix<UpdatableBitArray> resultExtremums, boolean buildListOfExtremumsXY) {
        super(values, mask, aperture, deepTestSettings, resultExtremums, buildListOfExtremumsXY, true);
    }

    @Override
    boolean horizontalCheck(int index0) {
        if (!this.mask[index0]) {
            return false;
        }
        float v0 = this.values[index0];
        for (int k = 1; k <= this.maxRadius; ++k) {
            if (!(this.mask[index0 - k] && this.values[index0 - k] > v0) && (!this.mask[index0 + k] || !(this.values[index0 + k] > v0))) continue;
            return false;
        }
        return true;
    }

    @Override
    void quickCheck(int index0) {
        if (!this.horizontalCheck(index0)) {
            return;
        }
        float v0 = this.values[index0];
        int count = 0;
        for (int k = 0; k < this.apertureCount; ++k) {
            int offset = this.apertureOffsets[k];
            int index = index0 - offset;
            if (!this.mask[index]) continue;
            if (this.values[index] > v0) {
                return;
            }
            this.neighbourOffsets[count++] = offset;
        }
        this.neighboursCount = count;
        this.processExtremum(index0, this.neighbourOffsets);
    }

    @Override
    void detailedCheck(int index0) {
        if (!this.mask[index0]) {
            return;
        }
        int x0 = index0 - this.valuesStart;
        int y0 = this.y;
        float v0 = this.values[index0];
        int dimX = this.dimX;
        int dimY = this.dimY;
        int[] dx = this.aperture.dx();
        int[] dy = this.aperture.dy();
        int count = 0;
        for (int k = 0; k < this.apertureCount; ++k) {
            int offset;
            int index;
            int x = x0 - dx[k];
            int y = y0 - dy[k];
            if (x < 0 || y < 0 || x >= dimX || y >= dimY || !this.mask[index = index0 - (offset = this.apertureOffsets[k])]) continue;
            if (this.values[index] > v0) {
                return;
            }
            this.neighbourOffsets[count++] = offset;
        }
        this.neighboursCount = count;
        this.processExtremum(index0, this.neighbourOffsets);
    }

    @Override
    float strictOppositeExtremum(int index0, int[] neighbourOffsets) {
        float extremum = this.values[index0];
        for (int k = 0; k < this.neighboursCount; ++k) {
            float value = this.values[index0 - neighbourOffsets[k]];
            if (!(value < extremum)) continue;
            extremum = value;
        }
        return extremum;
    }
}

