/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc.extremums;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.modules.cv.matrices.misc.SortedRound2DAperture;
import net.algart.executors.modules.cv.matrices.misc.extremums.MaximumsFinder;
import net.algart.executors.modules.cv.matrices.misc.extremums.MaximumsFinderWithoutMask;
import net.algart.executors.modules.cv.matrices.misc.extremums.MinimumsFinder;
import net.algart.executors.modules.cv.matrices.misc.extremums.MinimumsFinderWithoutMask;
import net.algart.executors.modules.cv.matrices.misc.extremums.OppositeExtremumFinder;

public abstract class ExtremumsFinder {
    private final boolean searchingForMaximums;
    final int dimX;
    final int dimY;
    final float[] values;
    final boolean[] mask;
    final SortedRound2DAperture aperture;
    final int apertureCount;
    final int apertureCountWithoutLine;
    final int[] apertureOffsets;
    private final SortedRound2DAperture depthAperture;
    private final double percentileLevel;
    private final double minimalDepth;
    private final boolean needOppositeExtremum;
    private final BitArray ignore;
    private final Matrix<UpdatableBitArray> extremums;
    private final boolean buildListOfExtremumsXY;
    private final MutableIntArray extremumsXY = net.algart.arrays.Arrays.SMM.newEmptyIntArray();
    final int maxRadius;
    private final int minOptimizedY;
    private final int maxOptimizedY;
    private final int minOptimizedYHorizontal;
    private final int maxOptimizedYHorizontal;
    final int[] neighbourOffsets;
    private final OppositeExtremumFinder oppositeExtremumFinder;
    int neighboursCount;
    int y;
    int valuesStart;

    ExtremumsFinder(float[] values, boolean[] mask, SortedRound2DAperture aperture, DeepTestSettings deepTestSettings, Matrix<UpdatableBitArray> resultExtremums, boolean buildListOfExtremumsXY, boolean searchingForMaximums) {
        Objects.requireNonNull(deepTestSettings, "Null deep-test settings");
        this.searchingForMaximums = searchingForMaximums;
        this.dimX = (int)resultExtremums.dimX();
        this.dimY = (int)resultExtremums.dimY();
        Objects.requireNonNull(values, "Null values");
        if ((long)values.length != resultExtremums.size()) {
            throw new IllegalArgumentException("values array length " + values.length + " does not match result extremums matrix sizes " + resultExtremums);
        }
        this.values = values;
        if (mask != null && (long)mask.length != resultExtremums.size()) {
            throw new IllegalArgumentException("mask array length " + mask.length + " does not match result extremums matrix sizes " + resultExtremums);
        }
        this.mask = mask;
        this.aperture = Objects.requireNonNull(aperture, "Null aperture");
        this.apertureCount = aperture.count();
        this.apertureCountWithoutLine = aperture.countWithoutLine();
        this.apertureOffsets = aperture.offsets();
        this.depthAperture = deepTestSettings.depthAperture;
        this.extremums = Objects.requireNonNull(resultExtremums, "Null resulting extremums matrix");
        this.percentileLevel = deepTestSettings.percentileLevel;
        this.minimalDepth = deepTestSettings.minimalDepth;
        boolean bl = this.needOppositeExtremum = this.minimalDepth > 0.0;
        if (deepTestSettings.ignore != null && !resultExtremums.dimEquals(deepTestSettings.ignore)) {
            throw new IllegalArgumentException("ignore matrix sizes " + deepTestSettings.ignore + " do not match result extremums matrix sizes " + resultExtremums);
        }
        this.ignore = deepTestSettings.ignore == null ? net.algart.arrays.Arrays.nBitCopies((long)resultExtremums.size(), (boolean)false) : (BitArray)deepTestSettings.ignore.array();
        this.buildListOfExtremumsXY = buildListOfExtremumsXY;
        this.maxRadius = aperture.maxRadius();
        this.minOptimizedYHorizontal = this.dimX == 0 ? Integer.MAX_VALUE : this.maxRadius / this.dimX + 1;
        this.maxOptimizedYHorizontal = this.dimY - 1 - this.minOptimizedYHorizontal;
        this.minOptimizedY = this.maxRadius + this.minOptimizedYHorizontal;
        this.maxOptimizedY = this.dimY - 1 - this.minOptimizedY;
        this.neighbourOffsets = new int[aperture.count()];
        this.neighboursCount = 0;
        switch (deepTestSettings.mode) {
            case PERCENTILE: {
                if (this.depthAperture != null) {
                    double level;
                    double d = level = searchingForMaximums ? 1.0 - this.percentileLevel : this.percentileLevel;
                    if (level == 0.0) {
                        this.oppositeExtremumFinder = new MinimumInDepthApertureFinder();
                        break;
                    }
                    if (level == 1.0) {
                        this.oppositeExtremumFinder = new MaximumInDepthApertureFinder();
                        break;
                    }
                    this.oppositeExtremumFinder = new PercentileInDepthApertureFinder();
                    break;
                }
                if (this.percentileLevel == 1.0) {
                    this.oppositeExtremumFinder = new StrictOppositeExtremumInMainApertureFinder();
                    break;
                }
                this.oppositeExtremumFinder = new PercentileInMainApertureFinder();
                break;
            }
            case MEAN: {
                if (this.depthAperture != null) {
                    this.oppositeExtremumFinder = new MeanInDepthApertureFinder();
                    break;
                }
                this.oppositeExtremumFinder = new MeanInMainApertureFinder();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported mode " + deepTestSettings.mode));
            }
        }
    }

    public static ExtremumsFinder getMaximumsFinder(float[] values, boolean[] mask, SortedRound2DAperture aperture, DeepTestSettings deepTestSettings, Matrix<UpdatableBitArray> resultExtremums, boolean buildListOfExtremumsXY) {
        return mask == null ? new MaximumsFinderWithoutMask(values, aperture, deepTestSettings, resultExtremums, buildListOfExtremumsXY) : new MaximumsFinder(values, mask, aperture, deepTestSettings, resultExtremums, buildListOfExtremumsXY);
    }

    public static ExtremumsFinder getMinimumsFinder(float[] values, boolean[] mask, SortedRound2DAperture aperture, DeepTestSettings deepTestSettings, Matrix<UpdatableBitArray> resultExtremums, boolean buildListOfExtremumsXY) {
        return mask == null ? new MinimumsFinderWithoutMask(values, aperture, deepTestSettings, resultExtremums, buildListOfExtremumsXY) : new MinimumsFinder(values, mask, aperture, deepTestSettings, resultExtremums, buildListOfExtremumsXY);
    }

    public MutableIntArray getExtremumsXY() {
        return this.extremumsXY;
    }

    public void processLine(int y) {
        int p;
        this.y = y;
        this.valuesStart = this.y * this.dimX;
        int pMinSimplified = this.valuesStart + this.maxRadius;
        int pMaxSimplified = this.valuesStart + this.dimX - 1 - this.maxRadius;
        for (p = this.valuesStart; p < pMinSimplified; ++p) {
            this.detailedCheck(p);
        }
        if (this.y >= this.minOptimizedY && this.y <= this.maxOptimizedY) {
            while (p <= pMaxSimplified) {
                this.quickCheck(p);
                ++p;
            }
        } else {
            while (p <= pMaxSimplified) {
                if (this.horizontalCheck(p)) {
                    this.detailedCheck(p);
                }
                ++p;
            }
        }
        int pTo = this.valuesStart + this.dimX;
        while (p < pTo) {
            this.detailedCheck(p);
            ++p;
        }
    }

    abstract boolean horizontalCheck(int var1);

    abstract void quickCheck(int var1);

    abstract void detailedCheck(int var1);

    abstract float strictOppositeExtremum(int var1, int[] var2);

    void processExtremum(int index0, int[] neighbourOffsets) {
        float extremumValue = this.values[index0];
        if (Float.isNaN(extremumValue)) {
            return;
        }
        if (this.ignore.getBit((long)index0)) {
            return;
        }
        if (this.needOppositeExtremum) {
            float opposite = this.oppositeExtremumFinder.oppositeExtremum(index0, neighbourOffsets);
            float f = this.searchingForMaximums ? extremumValue - opposite : opposite - extremumValue;
            if ((double)f < this.minimalDepth) {
                return;
            }
        }
        if (this.buildListOfExtremumsXY) {
            this.extremumsXY.addInt(index0 - this.valuesStart);
            this.extremumsXY.addInt(this.y);
        }
        ((UpdatableBitArray)this.extremums.array()).setBit((long)index0);
    }

    private static float percentileInNeighbours(double level, float[] neighbours, int neighboursCount) {
        if (neighboursCount > 0) {
            Arrays.sort(neighbours, 0, neighboursCount);
            return neighbours[(int)Math.round(level * (double)(neighboursCount - 1))];
        }
        return Float.NaN;
    }

    public static class DeepTestSettings {
        private SortedRound2DAperture depthAperture = null;
        private Mode mode = Mode.PERCENTILE;
        private double percentileLevel = 1.0;
        private double minimalDepth = 0.0;
        private Matrix<? extends BitArray> ignore = null;

        public DeepTestSettings setDepthAperture(SortedRound2DAperture depthAperture) {
            this.depthAperture = depthAperture;
            return this;
        }

        public DeepTestSettings setMode(Mode mode) {
            this.mode = Objects.requireNonNull(mode, "Null deep-testing mode");
            return this;
        }

        public DeepTestSettings setPercentileLevel(double percentileLevel) {
            if (percentileLevel < 0.0 || percentileLevel > 1.0) {
                throw new IllegalArgumentException("Illegal percentile level = " + percentileLevel + " (must be in range 0..1)");
            }
            this.percentileLevel = percentileLevel;
            return this;
        }

        public DeepTestSettings setMinimalDepth(double minimalDepth) {
            this.minimalDepth = minimalDepth;
            return this;
        }

        public DeepTestSettings setIgnore(Matrix<? extends BitArray> ignore) {
            this.ignore = ignore;
            return this;
        }

        public static enum Mode {
            PERCENTILE,
            MEAN;

        }
    }

    private class MinimumInDepthApertureFinder
    implements OppositeExtremumFinder {
        private MinimumInDepthApertureFinder() {
        }

        @Override
        public float oppositeExtremum(int index0, int[] neighbourFromMainApertureOffsets) {
            int x0 = index0 - ExtremumsFinder.this.valuesStart;
            int y0 = ExtremumsFinder.this.y;
            int dimX = ExtremumsFinder.this.dimX;
            int dimY = ExtremumsFinder.this.dimY;
            int[] dx = ExtremumsFinder.this.depthAperture.dx();
            int[] dy = ExtremumsFinder.this.depthAperture.dy();
            int[] offsets = ExtremumsFinder.this.depthAperture.offsets();
            float result = Float.POSITIVE_INFINITY;
            boolean found = false;
            int m = ExtremumsFinder.this.depthAperture.count();
            for (int k = 0; k < m; ++k) {
                float v;
                int x = x0 - dx[k];
                int y = y0 - dy[k];
                if (x < 0 || y < 0 || x >= dimX || y >= dimY) continue;
                int index = index0 - offsets[k];
                if (ExtremumsFinder.this.mask != null && !ExtremumsFinder.this.mask[index] || Float.isNaN(v = ExtremumsFinder.this.values[index])) continue;
                found = true;
                if (!(v < result)) continue;
                result = v;
            }
            return found ? result : Float.NaN;
        }
    }

    private class MaximumInDepthApertureFinder
    implements OppositeExtremumFinder {
        private MaximumInDepthApertureFinder() {
        }

        @Override
        public float oppositeExtremum(int index0, int[] neighbourFromMainApertureOffsets) {
            int x0 = index0 - ExtremumsFinder.this.valuesStart;
            int y0 = ExtremumsFinder.this.y;
            int dimX = ExtremumsFinder.this.dimX;
            int dimY = ExtremumsFinder.this.dimY;
            int[] dx = ExtremumsFinder.this.depthAperture.dx();
            int[] dy = ExtremumsFinder.this.depthAperture.dy();
            int[] offsets = ExtremumsFinder.this.depthAperture.offsets();
            float result = Float.NEGATIVE_INFINITY;
            boolean found = false;
            int m = ExtremumsFinder.this.depthAperture.count();
            for (int k = 0; k < m; ++k) {
                float v;
                int x = x0 - dx[k];
                int y = y0 - dy[k];
                if (x < 0 || y < 0 || x >= dimX || y >= dimY) continue;
                int index = index0 - offsets[k];
                if (ExtremumsFinder.this.mask != null && !ExtremumsFinder.this.mask[index] || Float.isNaN(v = ExtremumsFinder.this.values[index])) continue;
                found = true;
                if (!(v > result)) continue;
                result = v;
            }
            return found ? result : Float.NaN;
        }
    }

    private class PercentileInDepthApertureFinder
    implements OppositeExtremumFinder {
        final float[] neighbours;

        private PercentileInDepthApertureFinder() {
            this.neighbours = new float[ExtremumsFinder.this.depthAperture.count()];
        }

        @Override
        public float oppositeExtremum(int index0, int[] neighbourFromMainApertureOffsets) {
            double level = ExtremumsFinder.this.searchingForMaximums ? 1.0 - ExtremumsFinder.this.percentileLevel : ExtremumsFinder.this.percentileLevel;
            int x0 = index0 - ExtremumsFinder.this.valuesStart;
            int y0 = ExtremumsFinder.this.y;
            int dimX = ExtremumsFinder.this.dimX;
            int dimY = ExtremumsFinder.this.dimY;
            int[] dx = ExtremumsFinder.this.depthAperture.dx();
            int[] dy = ExtremumsFinder.this.depthAperture.dy();
            int[] offsets = ExtremumsFinder.this.depthAperture.offsets();
            int count = 0;
            int m = ExtremumsFinder.this.depthAperture.count();
            for (int k = 0; k < m; ++k) {
                float v;
                int x = x0 - dx[k];
                int y = y0 - dy[k];
                if (x < 0 || y < 0 || x >= dimX || y >= dimY) continue;
                int index = index0 - offsets[k];
                if (ExtremumsFinder.this.mask != null && !ExtremumsFinder.this.mask[index] || Float.isNaN(v = ExtremumsFinder.this.values[index])) continue;
                this.neighbours[count++] = v;
            }
            return ExtremumsFinder.percentileInNeighbours(level, this.neighbours, count);
        }
    }

    private class StrictOppositeExtremumInMainApertureFinder
    implements OppositeExtremumFinder {
        private StrictOppositeExtremumInMainApertureFinder() {
        }

        @Override
        public float oppositeExtremum(int index0, int[] neighbourFromMainApertureOffsets) {
            return ExtremumsFinder.this.strictOppositeExtremum(index0, neighbourFromMainApertureOffsets);
        }
    }

    private class PercentileInMainApertureFinder
    implements OppositeExtremumFinder {
        final float[] neighbours;

        private PercentileInMainApertureFinder() {
            this.neighbours = new float[ExtremumsFinder.this.apertureCount];
        }

        @Override
        public float oppositeExtremum(int index0, int[] neighbourFromMainApertureOffsets) {
            double level = ExtremumsFinder.this.searchingForMaximums ? 1.0 - ExtremumsFinder.this.percentileLevel : ExtremumsFinder.this.percentileLevel;
            float extremumValue = ExtremumsFinder.this.values[index0];
            int count = 0;
            for (int k = 0; k < ExtremumsFinder.this.neighboursCount; ++k) {
                float v = ExtremumsFinder.this.values[index0 - neighbourFromMainApertureOffsets[k]];
                if (Float.isNaN(v)) continue;
                assert (!ExtremumsFinder.this.searchingForMaximums ? v >= extremumValue : v <= extremumValue) : "Strange neighbour value = " + v + " for extremum " + extremumValue + ", searchingForMaximums=" + ExtremumsFinder.this.searchingForMaximums + ", neighboursCount=" + ExtremumsFinder.this.neighboursCount + ", x=" + (index0 - ExtremumsFinder.this.valuesStart) + ", y=" + ExtremumsFinder.this.y;
                this.neighbours[count++] = v;
            }
            return ExtremumsFinder.percentileInNeighbours(level, this.neighbours, count);
        }
    }

    private class MeanInDepthApertureFinder
    implements OppositeExtremumFinder {
        private MeanInDepthApertureFinder() {
        }

        @Override
        public float oppositeExtremum(int index0, int[] neighbourFromMainApertureOffsets) {
            int x0 = index0 - ExtremumsFinder.this.valuesStart;
            int y0 = ExtremumsFinder.this.y;
            int dimX = ExtremumsFinder.this.dimX;
            int dimY = ExtremumsFinder.this.dimY;
            int[] dx = ExtremumsFinder.this.depthAperture.dx();
            int[] dy = ExtremumsFinder.this.depthAperture.dy();
            int[] offsets = ExtremumsFinder.this.depthAperture.offsets();
            int count = 1;
            double sum = ExtremumsFinder.this.values[index0];
            int m = ExtremumsFinder.this.depthAperture.count();
            for (int k = 0; k < m; ++k) {
                int x = x0 - dx[k];
                int y = y0 - dy[k];
                if (x < 0 || y < 0 || x >= dimX || y >= dimY) continue;
                int index = index0 - offsets[k];
                if (ExtremumsFinder.this.mask != null && !ExtremumsFinder.this.mask[index]) continue;
                sum += (double)ExtremumsFinder.this.values[index];
                ++count;
            }
            return (float)(sum / (double)count);
        }
    }

    private class MeanInMainApertureFinder
    implements OppositeExtremumFinder {
        private MeanInMainApertureFinder() {
        }

        @Override
        public float oppositeExtremum(int index0, int[] neighbourFromMainApertureOffsets) {
            float extremumValue = ExtremumsFinder.this.values[index0];
            int count = 1;
            double sum = extremumValue;
            for (int k = 0; k < ExtremumsFinder.this.neighboursCount; ++k) {
                sum += (double)ExtremumsFinder.this.values[index0 - neighbourFromMainApertureOffsets[k]];
                ++count;
            }
            return (float)(sum / (double)count);
        }
    }
}

