/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.math.IPoint;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;

public final class SortedRound2DAperture {
    public static final int MAX_SIZE = 10000;
    private final int dimX;
    private final int[] dx;
    private final int[] dy;
    private final int[] offsets;
    private final int[] hypotSqr;
    private final int count;
    private final int countWithoutLine;
    private final int maxRadius;
    private final boolean sortedByIncreasingRadius;

    private SortedRound2DAperture(int apertureSize, long dimX, boolean boundary, boolean specialOrderForAxes) {
        if (apertureSize < 0) {
            throw new IllegalArgumentException("Zero or negative aperture size = " + apertureSize);
        }
        if (apertureSize >= 10000) {
            throw new IllegalArgumentException("Too large aperture size = " + apertureSize + " > 10000");
        }
        if (dimX < 0L) {
            throw new IllegalArgumentException("Negative dimX = " + dimX);
        }
        if (dimX > 2147463647L) {
            throw new IllegalArgumentException("Too large dimX = " + dimX + " > 2147463647");
        }
        this.dimX = (int)dimX;
        Pattern pattern = MorphologyFilter.Shape.SPHERE.newPattern(2, apertureSize);
        if (boundary) {
            pattern = SortedRound2DAperture.boundary(pattern);
        }
        ArrayList points = new ArrayList(pattern.roundedPoints());
        this.sortedByIncreasingRadius = !specialOrderForAxes;
        Collections.sort(points, (o1, o2) -> {
            if (specialOrderForAxes) {
                if (o1.x() == 0L && o2.x() != 0L) {
                    return -1;
                }
                if (o1.x() != 0L && o2.x() == 0L) {
                    return 1;
                }
                if (o1.y() == 0L && o2.y() != 0L) {
                    return 1;
                }
                if (o1.y() != 0L && o2.y() == 0L) {
                    return -1;
                }
                return Double.compare(o2.distanceFromOrigin(), o1.distanceFromOrigin());
            }
            return Double.compare(o1.distanceFromOrigin(), o2.distanceFromOrigin());
        });
        this.count = points.size();
        this.dx = new int[this.count];
        this.dy = new int[this.count];
        this.offsets = new int[this.count];
        this.hypotSqr = new int[this.count];
        int k = 0;
        int minXAtZeroY = 0;
        int maxXAtZeroY = 0;
        for (IPoint point : points) {
            if (point.isOrigin()) continue;
            int dx = (int)point.x();
            int dy = (int)point.y();
            if (dy == 0) {
                assert (dx != 0);
                minXAtZeroY = Math.min(minXAtZeroY, dx);
                maxXAtZeroY = Math.max(maxXAtZeroY, dx);
            }
            this.dx[k] = dx;
            this.dy[k] = dy;
            long offset = (long)this.dy[k] * dimX + (long)this.dx[k];
            if (offset != (long)((int)offset)) {
                throw new IllegalArgumentException("Too large aperture: offsets > Integer.MAX_VALUE");
            }
            this.offsets[k] = (int)offset;
            this.hypotSqr[k] = dx * dx + dy * dy;
            ++k;
        }
        if (maxXAtZeroY + minXAtZeroY != 0) {
            throw new AssertionError((Object)("Asymmetric pattern generator " + MorphologyFilter.Shape.SPHERE));
        }
        assert (maxXAtZeroY <= 10000) : "Strange pattern generator " + MorphologyFilter.Shape.SPHERE;
        this.maxRadius = maxXAtZeroY;
        if (!specialOrderForAxes) {
            this.countWithoutLine = this.count;
        } else {
            int i;
            this.countWithoutLine = this.count - 2 * maxXAtZeroY;
            for (i = 0; i < 2 * maxXAtZeroY; ++i) {
                if (this.dx[i] != 0) {
                    throw new AssertionError((Object)"Problem while sorting or pattern generator");
                }
            }
            for (i = this.countWithoutLine; i < this.count; ++i) {
                if (this.dy[i] != 0) {
                    throw new AssertionError((Object)"Problem while sorting");
                }
            }
        }
    }

    public static SortedRound2DAperture getCircle(int apertureSize, long dimX) {
        return new SortedRound2DAperture(apertureSize, dimX, false, false);
    }

    public static SortedRound2DAperture getRing(int apertureSize, long dimX) {
        return new SortedRound2DAperture(apertureSize, dimX, true, false);
    }

    public static SortedRound2DAperture getCircleWithSpeciallyOrderedPointsAtAxes(int apertureSize, long dimX) {
        return new SortedRound2DAperture(apertureSize, dimX, false, true);
    }

    public int dimX() {
        return this.dimX;
    }

    public int[] dx() {
        return this.dx;
    }

    public int[] dy() {
        return this.dy;
    }

    public int[] offsets() {
        return this.offsets;
    }

    public int hypotSqr(int k) {
        return this.hypotSqr[k];
    }

    public int count() {
        return this.count;
    }

    public int countWithoutLine() {
        return this.countWithoutLine;
    }

    public int maxRadius() {
        return this.maxRadius;
    }

    public boolean isSortedByIncreasingRadius() {
        return this.sortedByIncreasingRadius;
    }

    private static Pattern boundary(Pattern main) {
        Pattern erosion = main.minkowskiSubtract(MorphologyOperation.crossPattern(main.dimCount()));
        if (erosion == null) {
            return main;
        }
        LinkedHashSet points = new LinkedHashSet(main.roundedPoints());
        points.removeAll(erosion.roundedPoints());
        return Patterns.newIntegerPattern(points);
    }
}

