/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.derivatives;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFloatingArray;
import net.algart.executors.modules.cv.matrices.derivatives.DerivativeOperation;
import net.algart.executors.modules.cv.matrices.derivatives.HessianOperation;
import net.algart.executors.modules.cv.matrices.derivatives.MultichannelDerivativesFilter;
import net.algart.matrices.linearfiltering.Convolution;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class HessianEigenValuesAndVectors
extends MultichannelDerivativesFilter {
    public static final String OUTPUT_LAMBDA_1 = "lambda1";
    public static final String OUTPUT_LAMBDA_2 = "lambda2";
    public static final String OUTPUT_LAMBDA_1_PLUS = "lambda1_plus";
    public static final String OUTPUT_LAMBDA_2_PLUS = "lambda2_plus";
    public static final String OUTPUT_LAMBDA_1_MINUS = "lambda1_minus";
    public static final String OUTPUT_LAMBDA_2_MINUS = "lambda2_minus";
    public static final String OUTPUT_1_X = "vx1";
    public static final String OUTPUT_1_Y = "vy1";
    public static final String OUTPUT_2_X = "vx2";
    public static final String OUTPUT_2_Y = "vy2";
    public static final String OUTPUT_GRADIENT_SCALAR_PRODUCT_1 = "gradient_v1_scalar_product";
    public static final String OUTPUT_GRADIENT_SCALAR_PRODUCT_2 = "gradient_v2_scalar_product";
    private static final Map<String, HessianOperation> HESSIAN_OPERATIONS = new LinkedHashMap<String, HessianOperation>();
    private boolean orderEigenValuesByMagnitude = false;
    private boolean stableEigenVectorsSignumX = false;
    private boolean normalizeEigenVectors = false;

    public HessianEigenValuesAndVectors() {
        this.useVisibleResultParameter();
        this.removeOutputPort(DEFAULT_OUTPUT_PORT);
        for (String port : HESSIAN_OPERATIONS.keySet()) {
            this.addOutputMat(port);
        }
    }

    public boolean isOrderEigenValuesByMagnitude() {
        return this.orderEigenValuesByMagnitude;
    }

    public HessianEigenValuesAndVectors setOrderEigenValuesByMagnitude(boolean orderEigenValuesByMagnitude) {
        this.orderEigenValuesByMagnitude = orderEigenValuesByMagnitude;
        return this;
    }

    public boolean isStableEigenVectorsSignumX() {
        return this.stableEigenVectorsSignumX;
    }

    public HessianEigenValuesAndVectors setStableEigenVectorsSignumX(boolean stableEigenVectorsSignumX) {
        this.stableEigenVectorsSignumX = stableEigenVectorsSignumX;
        return this;
    }

    public boolean isNormalizeEigenVectors() {
        return this.normalizeEigenVectors;
    }

    public HessianEigenValuesAndVectors setNormalizeEigenVectors(boolean normalizeEigenVectors) {
        this.normalizeEigenVectors = normalizeEigenVectors;
        return this;
    }

    public void process(Map<HessianOperation, MultiMatrix2D> results, MultiMatrix2D source) {
        source = this.preprocess(source);
        List sourceChannels = source.allChannels();
        Convolution convolution = this.createConvolution();
        Class<? extends PFloatingArray> type = HessianEigenValuesAndVectors.floatingType(source.elementType());
        LinkedHashMap resultChannels = new LinkedHashMap();
        boolean gradientVectorNecessary = false;
        for (HessianOperation hessianOperation : results.keySet()) {
            resultChannels.put(hessianOperation, new ArrayList());
            gradientVectorNecessary |= hessianOperation.additionalVectorRequired();
        }
        for (Matrix matrix : sourceChannels) {
            Matrix<? extends PFloatingArray> dy;
            Matrix<? extends PFloatingArray> dx;
            Matrix<? extends PFloatingArray> d2dx2 = DerivativeOperation.D2_DX2.process(type, convolution, (Matrix<? extends PArray>)matrix);
            Matrix<? extends PFloatingArray> d2dy2 = DerivativeOperation.D2_DY2.process(type, convolution, (Matrix<? extends PArray>)matrix);
            Matrix<? extends PFloatingArray> d2dxdy = DerivativeOperation.D2_DXDY.process(type, convolution, (Matrix<? extends PArray>)matrix);
            if (gradientVectorNecessary) {
                dx = DerivativeOperation.DX.process(type, convolution, (Matrix<? extends PArray>)matrix);
                dy = DerivativeOperation.DY.process(type, convolution, (Matrix<? extends PArray>)matrix);
            } else {
                dx = null;
                dy = null;
            }
            for (Map.Entry entry : resultChannels.entrySet()) {
                HessianOperation operation = (HessianOperation)((Object)entry.getKey());
                ((List)entry.getValue()).add(operation.asOperation(DoubleArray.class, d2dx2, d2dy2, d2dxdy, dx, dy, this.orderEigenValuesByMagnitude, this.stableEigenVectorsSignumX, this.normalizeEigenVectors));
            }
        }
        for (Map.Entry entry : resultChannels.entrySet()) {
            results.put((HessianOperation)((Object)entry.getKey()), MultiMatrix.valueOf2DMono(this.combineResult(source.arrayType(), (List)entry.getValue())));
        }
    }

    @Override
    public MultiMatrix2D process(MultiMatrix2D source) {
        LinkedHashMap<HessianOperation, MultiMatrix2D> results = new LinkedHashMap<HessianOperation, MultiMatrix2D>();
        for (Map.Entry<String, HessianOperation> entry : HESSIAN_OPERATIONS.entrySet()) {
            if (!this.isOutputNecessary(entry.getKey())) continue;
            results.put(entry.getValue(), null);
        }
        this.process(results, source);
        for (Map.Entry<String, HessianOperation> entry : HESSIAN_OPERATIONS.entrySet()) {
            MultiMatrix2D result = (MultiMatrix2D)results.get((Object)entry.getValue());
            if (result == null) continue;
            this.getMat(entry.getKey()).setTo((MultiMatrix)result);
        }
        return null;
    }

    protected boolean resultRequired() {
        return false;
    }

    static {
        HESSIAN_OPERATIONS.put(OUTPUT_LAMBDA_1, HessianOperation.LAMBDA_1);
        HESSIAN_OPERATIONS.put(OUTPUT_LAMBDA_2, HessianOperation.LAMBDA_2);
        HESSIAN_OPERATIONS.put(OUTPUT_LAMBDA_1_PLUS, HessianOperation.LAMBDA_1_PLUS);
        HESSIAN_OPERATIONS.put(OUTPUT_LAMBDA_2_PLUS, HessianOperation.LAMBDA_2_PLUS);
        HESSIAN_OPERATIONS.put(OUTPUT_LAMBDA_1_MINUS, HessianOperation.LAMBDA_1_MINUS);
        HESSIAN_OPERATIONS.put(OUTPUT_LAMBDA_2_MINUS, HessianOperation.LAMBDA_2_MINUS);
        HESSIAN_OPERATIONS.put(OUTPUT_1_X, HessianOperation.VECTOR_1_X);
        HESSIAN_OPERATIONS.put(OUTPUT_1_Y, HessianOperation.VECTOR_1_Y);
        HESSIAN_OPERATIONS.put(OUTPUT_2_X, HessianOperation.VECTOR_2_X);
        HESSIAN_OPERATIONS.put(OUTPUT_2_Y, HessianOperation.VECTOR_2_Y);
        HESSIAN_OPERATIONS.put(OUTPUT_GRADIENT_SCALAR_PRODUCT_1, HessianOperation.VECTOR_1_SCALAR_PRODUCT);
        HESSIAN_OPERATIONS.put(OUTPUT_GRADIENT_SCALAR_PRODUCT_2, HessianOperation.VECTOR_2_SCALAR_PRODUCT);
    }
}

