/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.derivatives;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.PowerFunc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CombiningMatricesMetric {
    SINGLE_CHANNEL{

        @Override
        <T extends PArray> Matrix<? extends T> perform(Class<? extends T> requiredType, List<Matrix<? extends PArray>> matrices, double[] weights) {
            Matrix<? extends PArray> m = matrices.get(0);
            return Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{weights[0]}), requiredType, m);
        }
    }
    ,
    SINGLE_CHANNEL_PLUS_HALF{

        @Override
        <T extends PArray> Matrix<? extends T> perform(Class<? extends T> requiredType, List<Matrix<? extends PArray>> matrices, double[] weights) {
            Matrix<? extends PArray> m = matrices.get(0);
            double maxValue = Arrays.maxPossibleValue(requiredType, (double)1.0);
            return Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)(0.5 * maxValue), (double[])new double[]{weights[0]}), requiredType, m);
        }
    }
    ,
    EUCLIDEAN{

        @Override
        <T extends PArray> Matrix<? extends T> perform(Class<? extends T> requiredType, List<Matrix<? extends PArray>> matrices, double[] weights) {
            if (matrices.size() == 1) {
                return SUM_OF_ABSOLUTE_VALUES.perform(requiredType, matrices, weights);
            }
            ArrayList<Matrix> sqr = new ArrayList<Matrix>();
            for (Matrix<? extends PArray> matrix : matrices) {
                sqr.add(Matrices.asFuncMatrix((Func)PowerFunc.getInstance((double)2.0), DoubleArray.class, matrix));
            }
            Matrix sum = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])CombiningMatricesMetric.sqr(weights)), DoubleArray.class, sqr);
            return Matrices.asFuncMatrix((Func)PowerFunc.getInstance((double)0.5), requiredType, (Matrix)sum);
        }
    }
    ,
    NORMALIZED_EUCLIDEAN{

        @Override
        <T extends PArray> Matrix<? extends T> perform(Class<? extends T> requiredType, List<Matrix<? extends PArray>> matrices, double[] weights) {
            if (matrices.size() == 1) {
                return SUM_OF_ABSOLUTE_VALUES.perform(requiredType, matrices, weights);
            }
            ArrayList<Matrix> sqr = new ArrayList<Matrix>();
            for (Matrix<? extends PArray> matrix : matrices) {
                sqr.add(Matrices.asFuncMatrix((Func)PowerFunc.getInstance((double)2.0), DoubleArray.class, matrix));
            }
            Matrix sum = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])CombiningMatricesMetric.mul(CombiningMatricesMetric.sqr(weights), 1.0 / (double)matrices.size())), DoubleArray.class, sqr);
            return Matrices.asFuncMatrix((Func)PowerFunc.getInstance((double)0.5), requiredType, (Matrix)sum);
        }
    }
    ,
    SUM_OF_ABSOLUTE_VALUES{

        @Override
        <T extends PArray> Matrix<? extends T> perform(Class<? extends T> requiredType, List<Matrix<? extends PArray>> matrices, double[] weights) {
            ArrayList<Matrix> abs = new ArrayList<Matrix>();
            for (Matrix<? extends PArray> matrix : matrices) {
                abs.add(Matrices.asFuncMatrix((Func)Func.ABS, DoubleArray.class, matrix));
            }
            return Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])CombiningMatricesMetric.abs(weights)), requiredType, abs);
        }
    }
    ,
    MEAN_ABSOLUTE_VALUE{

        @Override
        <T extends PArray> Matrix<? extends T> perform(Class<? extends T> requiredType, List<Matrix<? extends PArray>> matrices, double[] weights) {
            ArrayList<Matrix> abs = new ArrayList<Matrix>();
            for (Matrix<? extends PArray> matrix : matrices) {
                abs.add(Matrices.asFuncMatrix((Func)Func.ABS, DoubleArray.class, matrix));
            }
            return Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])CombiningMatricesMetric.mul(CombiningMatricesMetric.abs(weights), 1.0 / (double)matrices.size())), requiredType, abs);
        }
    }
    ,
    MAX_ABSOLUTE_VALUE{

        @Override
        <T extends PArray> Matrix<? extends T> perform(Class<? extends T> requiredType, List<Matrix<? extends PArray>> matrices, double[] weights) {
            if (matrices.size() == 1) {
                return SUM_OF_ABSOLUTE_VALUES.perform(requiredType, matrices, weights);
            }
            ArrayList<Matrix> abs = new ArrayList<Matrix>();
            for (Matrix<? extends PArray> matrix : matrices) {
                Matrix m = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{weights[abs.size()]}), DoubleArray.class, matrix);
                abs.add(Matrices.asFuncMatrix((Func)Func.ABS, DoubleArray.class, (Matrix)m));
            }
            return Matrices.asFuncMatrix((Func)Func.MAX, requiredType, abs);
        }
    };


    abstract <T extends PArray> Matrix<? extends T> perform(Class<? extends T> var1, List<Matrix<? extends PArray>> var2, double[] var3);

    public boolean isSingleChannel() {
        return this == SINGLE_CHANNEL || this == SINGLE_CHANNEL_PLUS_HALF;
    }

    public <T extends PArray> Matrix<? extends T> combine(Class<? extends T> requiredType, List<Matrix<? extends PArray>> matrices, double[] weights, double additionalMultiplier) {
        Objects.requireNonNull(matrices, "Null matrices");
        Objects.requireNonNull(weights, "Null weights");
        double[] appendedWeights = new double[matrices.size()];
        for (int i = 0; i < appendedWeights.length; ++i) {
            appendedWeights[i] = (i >= weights.length ? 1.0 : weights[i]) * additionalMultiplier;
        }
        return this.perform(requiredType, matrices, appendedWeights);
    }

    private static double[] sqr(double[] weights) {
        double[] result = new double[weights.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = weights[k] * weights[k];
        }
        return result;
    }

    private static double[] abs(double[] weights) {
        double[] result = new double[weights.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = Math.abs(weights[k]);
        }
        return result;
    }

    private static double[] mul(double[] weights, double multiplier) {
        double[] result = new double[weights.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = weights[k] * multiplier;
        }
        return result;
    }
}

