/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.ShortArray;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.opencv.matrices.filtering.Median;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.external.MatrixIO;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class MedianTestAndFinalizingWhileGc {
    private static void test(Path sourceFile, Path targetFile) throws IOException {
        ArrayList<Matrix> image = new ArrayList<Matrix>(MatrixIO.readImage((Path)sourceFile));
        for (int i = 0; i < image.size(); ++i) {
            Matrix m = (Matrix)image.get(i);
            m = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{257.0}), ShortArray.class, (Matrix)m);
            image.set(i, m);
        }
        Median median = new Median();
        median.setKernelSize(5);
        median.getInputMatContainer().setTo((MultiMatrix)MultiMatrix.valueOf2DRGBA(image));
        median.execute();
        Mat resMat = O2SMat.toMat((SMat)median.getMat());
        opencv_imgcodecs.imwrite((String)targetFile.toString(), (Mat)resMat);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length < 2) {
            System.out.printf("Usage: %s source_image target_image%n", Median.class.getName());
            return;
        }
        Path sourceFile = Paths.get(args[0], new String[0]);
        Path targetFile = Paths.get(args[1], new String[0]);
        MedianTestAndFinalizingWhileGc.test(sourceFile, targetFile);
        System.gc();
        Thread.sleep(100L);
        System.gc();
        System.gc();
    }
}

