/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.thresholds;

import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.Histogram;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.math.functions.Func;
import net.algart.math.functions.RectangularFunc;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class BestBoundaryThreshold
extends MultiMatrix2DFilter {
    private double alpha = 0.0;
    private double gamma = 1.0;
    private boolean invert = false;

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = BestBoundaryThreshold.positive((double)gamma);
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        Matrix intensity = Arrays.SMM.newByteMatrix(source.dimensions());
        Matrices.copy(null, (Matrix)intensity, (Matrix)source.toPrecisionIfNot(Byte.TYPE).intensityChannel());
        long[] intensityIntegral = new long[256];
        long[] boundaryHistogram = new long[256];
        int thresholdMax = this.findThreshold((Matrix<? extends ByteArray>)intensity, this.alpha, this.gamma, intensityIntegral, boundaryHistogram);
        BestBoundaryThreshold.logDebug(() -> "Best-boundary threshold, alpha = " + this.alpha + ", gamma = " + this.gamma + "; optimal threshold found at " + thresholdMax + " (" + (double)thresholdMax / 255.0 + ") for " + source);
        double inValue = this.invert ? 1.0 : 0.0;
        double outValue = this.invert ? 0.0 : 1.0;
        RectangularFunc f = RectangularFunc.getInstance((double)0.0, (double)thresholdMax, (double)inValue, (double)outValue);
        Matrix result = Matrices.asFuncMatrix((Func)f, BitArray.class, (Matrix)intensity);
        return MultiMatrix.valueOf2DMono((Matrix)result);
    }

    public int findThreshold(Matrix<? extends ByteArray> m, double alpha, double gamma) {
        return this.findThreshold(m, alpha, gamma, new long[256], new long[256]);
    }

    private int findThreshold(Matrix<? extends ByteArray> m, double alpha, double gamma, long[] intensityIntegral, long[] boundaryHistogram) {
        ByteArray bytes = (ByteArray)m.array();
        long[] intensityHistogram = new long[256];
        Arrays.histogramOf((PArray)bytes, (long[])intensityHistogram, (double)0.0, (double)256.0);
        long totalArea = Histogram.sumOf((long[])intensityHistogram);
        BestBoundaryThreshold.boundaryHistogram(bytes, m.dimX(), m.dimY(), boundaryHistogram);
        double addition = alpha * ((double)m.dimX() + (double)m.dimY());
        int result = 0;
        double maxQuality = Double.NEGATIVE_INFINITY;
        long bestAreaOfBlackOrWhiteObjects = -1L;
        long numberOfZeroPixels = 0L;
        for (int threshMax = 0; threshMax < 256; ++threshMax) {
            long lengthOfBoundary;
            double quality;
            intensityIntegral[threshMax] = numberOfZeroPixels += intensityHistogram[threshMax];
            long areaOfBlackOrWhiteObjects = Math.min(numberOfZeroPixels, totalArea - numberOfZeroPixels);
            if (areaOfBlackOrWhiteObjects == 0L || !((quality = (double)areaOfBlackOrWhiteObjects / Math.pow(addition + (double)(lengthOfBoundary = boundaryHistogram[threshMax]), gamma)) > maxQuality)) continue;
            bestAreaOfBlackOrWhiteObjects = areaOfBlackOrWhiteObjects;
            maxQuality = quality;
            result = threshMax;
        }
        if (LOGGABLE_DEBUG) {
            BestBoundaryThreshold.logDebug((String)("Best-boundary threshold found at " + result + ": area of objects " + bestAreaOfBlackOrWhiteObjects + ", boundary length " + boundaryHistogram[result] + ", quality " + maxQuality));
        }
        return result;
    }

    private static void boundaryHistogram(ByteArray bytes, long dimX, long dimY, long[] boundaryHistogram) {
        if (dimX > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Matrix width = " + dimX + " is larger than 2^31-1");
        }
        byte[] line1 = new byte[(int)dimX];
        byte[] line2 = new byte[(int)dimX];
        long[] xMinHistogram = new long[256];
        long[] xMaxHistogram = new long[256];
        long[] yMinHistogram = new long[256];
        long[] yMaxHistogram = new long[256];
        bytes.getData(0L, (Object)line2);
        long y = 1L;
        long disp = dimX;
        while (y < dimY) {
            byte[] temp = line2;
            line2 = line1;
            line1 = temp;
            bytes.getData(disp, (Object)line2);
            for (int x = 1; x < line2.length; ++x) {
                int a = line2[x] & 0xFF;
                int b = line2[x - 1] & 0xFF;
                int c = line1[x] & 0xFF;
                if (a < b) {
                    int n = a;
                    xMinHistogram[n] = xMinHistogram[n] + 1L;
                    int n2 = b;
                    xMaxHistogram[n2] = xMaxHistogram[n2] + 1L;
                } else {
                    int n = b;
                    xMinHistogram[n] = xMinHistogram[n] + 1L;
                    int n3 = a;
                    xMaxHistogram[n3] = xMaxHistogram[n3] + 1L;
                }
                if (a < c) {
                    int n = a;
                    yMinHistogram[n] = yMinHistogram[n] + 1L;
                    int n4 = c;
                    yMaxHistogram[n4] = yMaxHistogram[n4] + 1L;
                    continue;
                }
                int n = c;
                yMinHistogram[n] = yMinHistogram[n] + 1L;
                int n5 = a;
                yMaxHistogram[n5] = yMaxHistogram[n5] + 1L;
            }
            ++y;
            disp += dimX;
        }
        long minIntegral = 0L;
        long maxIntegral = 0L;
        for (int k = 0; k < 256; ++k) {
            boundaryHistogram[k] = (minIntegral += xMinHistogram[k] + yMinHistogram[k]) - (maxIntegral += xMaxHistogram[k] + yMaxHistogram[k]);
        }
    }
}

