/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Objects;
import net.algart.arrays.ArrayComparator32;
import net.algart.arrays.ArrayExchanger32;
import net.algart.arrays.ArraySelector;
import net.algart.arrays.ArraySorter;
import net.algart.arrays.ByteArraySelector;
import net.algart.arrays.JArrays;
import net.algart.executors.modules.cv.matrices.objects.labels.PercentilesFinder;

class PercentilesFinderForSeparateChannels
implements PercentilesFinder {
    private static final boolean ACCURATE_TRUNCATED_MEAN = true;
    static final int MIN_LENGTH_FOR_USING_BYTE_SELECTOR = 128;
    final float[][][] percentilesByChannels;
    final float[][] truncatedMeansByChannels;
    private final int numberOfChannels;
    final int numberOfResultChannels;
    final double[][] levels;
    final double[][] sortedLevels;
    final int[][] unsortedLevelsIndexes;
    final boolean needTruncatedMeans;
    final int lowTruncatedMeanIndex;
    final int highTruncatedMeanIndex;
    byte[][] threadBytePercentiles;
    ByteArraySelector[] threadByteArraySelectors;

    PercentilesFinderForSeparateChannels(int numberOfChannels, int numberOfResultChannels, int maxLabel, double[][] levelsByChannels, int lowTruncatedMeanIndex, int highTruncatedMeanIndex) {
        Objects.requireNonNull(levelsByChannels, "Null levels");
        if (numberOfResultChannels <= 0) {
            throw new IllegalArgumentException("Zero or negative number of actual channels");
        }
        if (numberOfChannels < numberOfResultChannels) {
            throw new IllegalArgumentException("Number of channels (" + numberOfChannels + ") must be >= number of actual channels (" + numberOfResultChannels + ")");
        }
        if (levelsByChannels.length < numberOfResultChannels) {
            throw new IllegalArgumentException("Percentile levels are specified only for " + levelsByChannels.length + " channels from " + numberOfResultChannels);
        }
        this.needTruncatedMeans = lowTruncatedMeanIndex >= 0 && highTruncatedMeanIndex >= 0;
        this.lowTruncatedMeanIndex = lowTruncatedMeanIndex;
        this.highTruncatedMeanIndex = highTruncatedMeanIndex;
        this.truncatedMeansByChannels = this.needTruncatedMeans ? new float[numberOfResultChannels][maxLabel] : null;
        this.numberOfChannels = numberOfChannels;
        this.numberOfResultChannels = numberOfResultChannels;
        this.percentilesByChannels = new float[numberOfResultChannels][][];
        this.levels = new double[numberOfResultChannels][];
        this.sortedLevels = new double[numberOfResultChannels][];
        this.unsortedLevelsIndexes = new int[numberOfResultChannels][];
        for (int c = 0; c < numberOfResultChannels; ++c) {
            this.levels[c] = (double[])levelsByChannels[c].clone();
            double[] sorted = (double[])this.levels[c].clone();
            int[] indexes = new int[sorted.length];
            JArrays.fillIntProgression((int[])indexes, (int)0, (int)1);
            ArraySorter.getQuickSorter().sort(0, sorted.length, (ArrayComparator32)new JArrays.DoubleArrayComparator(sorted), (ArrayExchanger32)new JArrays.DoubleAndIndexArrayExchanger(sorted, indexes));
            for (int k = 0; k < indexes.length; ++k) {
                assert (this.levels[c][indexes[k]] == sorted[k]);
            }
            this.sortedLevels[c] = sorted;
            this.unsortedLevelsIndexes[c] = indexes;
            this.percentilesByChannels[c] = new float[sorted.length][maxLabel];
        }
    }

    @Override
    public float[][][] percentilesByChannels() {
        return this.percentilesByChannels;
    }

    @Override
    public float[][] truncatedMeansByChannels() {
        return this.truncatedMeansByChannels;
    }

    @Override
    public void preprocess(Class<?> elementType, int numberOfTasks) {
        if (elementType == Byte.TYPE) {
            int maxNumberOfLevels = 0;
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                maxNumberOfLevels = Math.max(maxNumberOfLevels, this.levels[c].length);
            }
            this.threadBytePercentiles = new byte[numberOfTasks][maxNumberOfLevels];
            this.threadByteArraySelectors = new ByteArraySelector[numberOfTasks];
            for (int k = 0; k < numberOfTasks; ++k) {
                this.threadByteArraySelectors[k] = new ByteArraySelector();
            }
        }
    }

    @Override
    public void processPixels(int objectLabel, byte[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        if (numberOfPixels >= 128) {
            for (int c = 0; c < this.numberOfResultChannels; ++c) {
                this.percentilesInChannelForBytes(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.sortedLevels[c], this.unsortedLevelsIndexes[c], this.threadBytePercentiles[threadIndex], this.threadByteArraySelectors[threadIndex]);
            }
            return;
        }
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            this.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    void percentilesInChannel(int resultDisp, byte[] objectPixels, int numberOfPixels, float[][] percentiles, float[] truncatedMeans, double[] levels, double[] sortedLevels) {
        if (levels.length == 0) {
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        if (numberOfPixels == 0) {
            for (int k = 0; k < levels.length; ++k) {
                percentiles[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        ArraySelector.getQuickSelector().select(sortedLevels, objectPixels, numberOfPixels);
        int indexLow = -1;
        int indexHigh = -1;
        for (int k = 0; k < levels.length; ++k) {
            int percentileIndex = ArraySelector.percentileIndex((double)levels[k], (int)numberOfPixels);
            if (k == this.lowTruncatedMeanIndex) {
                indexLow = percentileIndex;
            } else if (k == this.highTruncatedMeanIndex) {
                indexHigh = percentileIndex;
            }
            percentiles[k][resultDisp] = objectPixels[percentileIndex] & 0xFF;
        }
        if (this.needTruncatedMeans) {
            double mean;
            if (indexLow == -1) {
                mean = Double.NaN;
            } else if (indexHigh == -1 || indexHigh == indexLow) {
                mean = objectPixels[indexLow] & 0xFF;
            } else {
                double low = objectPixels[indexLow] & 0xFF;
                double high = objectPixels[indexHigh] & 0xFF;
                if (low > high) {
                    mean = Double.NaN;
                } else if (low == high) {
                    mean = low;
                } else {
                    mean = 0.0;
                    int count = 0;
                    for (int k = 0; k < numberOfPixels; ++k) {
                        double v = objectPixels[k] & 0xFF;
                        if (!(v >= low) || !(v <= high)) continue;
                        mean += v;
                        ++count;
                    }
                    mean /= (double)count;
                }
            }
            truncatedMeans[resultDisp] = (float)mean;
        }
    }

    @Override
    public void processPixels(int objectLabel, short[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            this.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    void percentilesInChannel(int resultDisp, short[] objectPixels, int numberOfPixels, float[][] percentiles, float[] truncatedMeans, double[] levels, double[] sortedLevels) {
        if (levels.length == 0) {
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        if (numberOfPixels == 0) {
            for (int k = 0; k < levels.length; ++k) {
                percentiles[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        ArraySelector.getQuickSelector().select(sortedLevels, objectPixels, numberOfPixels);
        int indexLow = -1;
        int indexHigh = -1;
        for (int k = 0; k < levels.length; ++k) {
            int percentileIndex = ArraySelector.percentileIndex((double)levels[k], (int)numberOfPixels);
            if (k == this.lowTruncatedMeanIndex) {
                indexLow = percentileIndex;
            } else if (k == this.highTruncatedMeanIndex) {
                indexHigh = percentileIndex;
            }
            percentiles[k][resultDisp] = objectPixels[percentileIndex] & 0xFFFF;
        }
        if (this.needTruncatedMeans) {
            double mean;
            if (indexLow == -1) {
                mean = Double.NaN;
            } else if (indexHigh == -1 || indexHigh == indexLow) {
                mean = objectPixels[indexLow] & 0xFFFF;
            } else {
                double low = objectPixels[indexLow] & 0xFFFF;
                double high = objectPixels[indexHigh] & 0xFFFF;
                if (low > high) {
                    mean = Double.NaN;
                } else if (low == high) {
                    mean = low;
                } else {
                    mean = 0.0;
                    int count = 0;
                    for (int k = 0; k < numberOfPixels; ++k) {
                        double v = objectPixels[k] & 0xFFFF;
                        if (!(v >= low) || !(v <= high)) continue;
                        mean += v;
                        ++count;
                    }
                    mean /= (double)count;
                }
            }
            truncatedMeans[resultDisp] = (float)mean;
        }
    }

    @Override
    public void processPixels(int objectLabel, int[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            this.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    void percentilesInChannel(int resultDisp, int[] objectPixels, int numberOfPixels, float[][] percentiles, float[] truncatedMeans, double[] levels, double[] sortedLevels) {
        if (levels.length == 0) {
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        if (numberOfPixels == 0) {
            for (int k = 0; k < levels.length; ++k) {
                percentiles[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        ArraySelector.getQuickSelector().select(sortedLevels, objectPixels, numberOfPixels);
        int indexLow = -1;
        int indexHigh = -1;
        for (int k = 0; k < levels.length; ++k) {
            int percentileIndex = ArraySelector.percentileIndex((double)levels[k], (int)numberOfPixels);
            if (k == this.lowTruncatedMeanIndex) {
                indexLow = percentileIndex;
            } else if (k == this.highTruncatedMeanIndex) {
                indexHigh = percentileIndex;
            }
            percentiles[k][resultDisp] = objectPixels[percentileIndex];
        }
        if (this.needTruncatedMeans) {
            double mean;
            if (indexLow == -1) {
                mean = Double.NaN;
            } else if (indexHigh == -1 || indexHigh == indexLow) {
                mean = objectPixels[indexLow];
            } else {
                double low = objectPixels[indexLow];
                double high = objectPixels[indexHigh];
                if (low > high) {
                    mean = Double.NaN;
                } else if (low == high) {
                    mean = low;
                } else {
                    mean = 0.0;
                    int count = 0;
                    for (int k = 0; k < numberOfPixels; ++k) {
                        double v = objectPixels[k];
                        if (!(v >= low) || !(v <= high)) continue;
                        mean += v;
                        ++count;
                    }
                    mean /= (double)count;
                }
            }
            truncatedMeans[resultDisp] = (float)mean;
        }
    }

    @Override
    public void processPixels(int objectLabel, float[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            this.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    void percentilesInChannel(int resultDisp, float[] objectPixels, int numberOfPixels, float[][] percentiles, float[] truncatedMeans, double[] levels, double[] sortedLevels) {
        if (levels.length == 0) {
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        if (numberOfPixels == 0) {
            for (int k = 0; k < levels.length; ++k) {
                percentiles[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        ArraySelector.getQuickSelector().select(sortedLevels, objectPixels, numberOfPixels);
        int indexLow = -1;
        int indexHigh = -1;
        for (int k = 0; k < levels.length; ++k) {
            int percentileIndex = ArraySelector.percentileIndex((double)levels[k], (int)numberOfPixels);
            if (k == this.lowTruncatedMeanIndex) {
                indexLow = percentileIndex;
            } else if (k == this.highTruncatedMeanIndex) {
                indexHigh = percentileIndex;
            }
            percentiles[k][resultDisp] = objectPixels[percentileIndex];
        }
        if (this.needTruncatedMeans) {
            double mean;
            if (indexLow == -1) {
                mean = Double.NaN;
            } else if (indexHigh == -1 || indexHigh == indexLow) {
                mean = objectPixels[indexLow];
            } else {
                double low = objectPixels[indexLow];
                double high = objectPixels[indexHigh];
                if (low > high) {
                    mean = Double.NaN;
                } else if (low == high) {
                    mean = low;
                } else {
                    mean = 0.0;
                    int count = 0;
                    for (int k = 0; k < numberOfPixels; ++k) {
                        double v = objectPixels[k];
                        if (!(v >= low) || !(v <= high)) continue;
                        mean += v;
                        ++count;
                    }
                    mean /= (double)count;
                }
            }
            truncatedMeans[resultDisp] = (float)mean;
        }
    }

    @Override
    public void processPixels(int objectLabel, double[][] objectPixelsByChannels, int numberOfPixels, int threadIndex) {
        if (objectLabel == 0) {
            return;
        }
        int resultDisp = objectLabel - 1;
        for (int c = 0; c < this.numberOfResultChannels; ++c) {
            this.percentilesInChannel(resultDisp, objectPixelsByChannels[c], numberOfPixels, this.percentilesByChannels[c], this.needTruncatedMeans ? this.truncatedMeansByChannels[c] : null, this.levels[c], this.sortedLevels[c]);
        }
    }

    void percentilesInChannel(int resultDisp, double[] objectPixels, int numberOfPixels, float[][] percentiles, float[] truncatedMeans, double[] levels, double[] sortedLevels) {
        if (levels.length == 0) {
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        if (numberOfPixels == 0) {
            for (int k = 0; k < levels.length; ++k) {
                percentiles[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        ArraySelector.getQuickSelector().select(sortedLevels, objectPixels, numberOfPixels);
        int indexLow = -1;
        int indexHigh = -1;
        for (int k = 0; k < levels.length; ++k) {
            int percentileIndex = ArraySelector.percentileIndex((double)levels[k], (int)numberOfPixels);
            if (k == this.lowTruncatedMeanIndex) {
                indexLow = percentileIndex;
            } else if (k == this.highTruncatedMeanIndex) {
                indexHigh = percentileIndex;
            }
            percentiles[k][resultDisp] = (float)objectPixels[percentileIndex];
        }
        if (this.needTruncatedMeans) {
            double mean;
            if (indexLow == -1) {
                mean = Double.NaN;
            } else if (indexHigh == -1 || indexHigh == indexLow) {
                mean = objectPixels[indexLow];
            } else {
                double low = objectPixels[indexLow];
                double high = objectPixels[indexHigh];
                if (low > high) {
                    mean = Double.NaN;
                } else if (low == high) {
                    mean = low;
                } else {
                    mean = 0.0;
                    int count = 0;
                    for (int k = 0; k < numberOfPixels; ++k) {
                        double v = objectPixels[k];
                        if (!(v >= low) || !(v <= high)) continue;
                        mean += v;
                        ++count;
                    }
                    mean /= (double)count;
                }
            }
            truncatedMeans[resultDisp] = (float)mean;
        }
    }

    void percentilesInChannelForBytes(int resultDisp, byte[] objectPixels, int numberOfPixels, float[][] percentiles, float[] truncatedMeans, double[] sortedLevels, int[] unsortedLevelsIndexes, byte[] bytePercentiles, ByteArraySelector selector) {
        if (this.levels.length == 0) {
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        if (numberOfPixels == 0) {
            for (int k = 0; k < sortedLevels.length; ++k) {
                percentiles[k][resultDisp] = Float.NaN;
            }
            if (this.needTruncatedMeans) {
                truncatedMeans[resultDisp] = Float.NaN;
            }
            return;
        }
        selector.select(bytePercentiles, sortedLevels, objectPixels, numberOfPixels);
        int kLow = -1;
        int kHigh = -1;
        for (int k = 0; k < sortedLevels.length; ++k) {
            int unsortedIndex = unsortedLevelsIndexes[k];
            if (unsortedIndex == this.lowTruncatedMeanIndex) {
                kLow = k;
            } else if (unsortedIndex == this.highTruncatedMeanIndex) {
                kHigh = k;
            }
            percentiles[unsortedIndex][resultDisp] = bytePercentiles[k] & 0xFF;
        }
        if (this.needTruncatedMeans) {
            double mean;
            if (kLow == -1) {
                mean = Double.NaN;
            } else if (kHigh == -1 || kHigh == kLow) {
                mean = bytePercentiles[kLow] & 0xFF;
            } else {
                double low = bytePercentiles[kLow] & 0xFF;
                double high = bytePercentiles[kHigh] & 0xFF;
                if (low > high) {
                    mean = Double.NaN;
                } else if (low == high) {
                    mean = low;
                } else {
                    mean = 0.0;
                    int count = 0;
                    for (int k = 0; k < numberOfPixels; ++k) {
                        double v = objectPixels[k] & 0xFF;
                        if (!(v >= low) || !(v <= high)) continue;
                        mean += v;
                        ++count;
                    }
                    mean /= (double)count;
                }
            }
            truncatedMeans[resultDisp] = (float)mean;
        }
    }
}

