/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.executors.modules.cv.matrices.objects.labels.LabelsProcessor;

public final class LabelsListsBuilder
extends LabelsProcessor {
    private final int[] labels;
    private final int[] lists;
    private final int[][] threadListHeads;
    private final int[][] threadListTailsIncreased;
    private final int[][] requestedListHeads;
    private final int[][] requestedListTails;
    private int[] listHeads;
    private int maxLabel = -1;

    private LabelsListsBuilder(int[] labels, int[] lists) {
        super((Array)SimpleMemoryModel.asUpdatableIntArray((int[])Objects.requireNonNull(labels, "Null labels")));
        assert (labels.length == lists.length);
        this.labels = labels;
        this.lists = lists;
        this.requestedListHeads = LabelsListsBuilder.requestClearedIntArrays(this.numberOfTasks());
        this.requestedListTails = LabelsListsBuilder.requestClearedIntArrays(this.numberOfTasks());
        this.threadListHeads = (int[][])this.requestedListHeads.clone();
        this.threadListTailsIncreased = (int[][])this.requestedListTails.clone();
    }

    public static LabelsListsBuilder getInstance(int[] labels, int[] lists) {
        return new LabelsListsBuilder(labels, lists);
    }

    @Override
    public void close() {
        LabelsListsBuilder.releaseAndClearIntArrays(this.requestedListTails, this.maxLabel + 1);
        LabelsListsBuilder.releaseAndClearIntArrays(this.requestedListHeads, this.maxLabel + 1);
    }

    public int[] listHeads() {
        return this.listHeads;
    }

    public int maxLabel() {
        return this.maxLabel;
    }

    @Override
    protected void processSubArr(int p, int count, int threadIndex) {
        int k;
        int[] listHeads = this.threadListHeads[threadIndex];
        int[] listTailsIncreased = this.threadListTailsIncreased[threadIndex];
        int kMax = k + count;
        for (k = p; k < kMax; ++k) {
            int label = this.labels[k];
            if (label <= 0) continue;
            if (label >= listHeads.length) {
                listHeads = LabelsListsBuilder.ensureCapacityForLabel(listHeads, label);
                listTailsIncreased = LabelsListsBuilder.ensureCapacityForLabel(listTailsIncreased, label);
            }
            this.lists[k] = listHeads[label];
            listHeads[label] = k;
            if (listTailsIncreased[label] != 0) continue;
            listTailsIncreased[label] = k + 1;
            this.lists[k] = -1;
        }
        this.threadListHeads[threadIndex] = listHeads;
        this.threadListTailsIncreased[threadIndex] = listTailsIncreased;
    }

    protected void finish() {
        int maxLabel = 0;
        for (int[] threadTails : this.threadListTailsIncreased) {
            int last = 0;
            for (int k = threadTails.length - 1; k >= 0; --k) {
                if (threadTails[k] <= 0) continue;
                last = k;
                break;
            }
            maxLabel = Math.max(maxLabel, last);
        }
        this.maxLabel = maxLabel;
        this.listHeads = new int[maxLabel + 1];
        assert (this.threadListHeads.length == this.threadListTailsIncreased.length);
        for (int index = 0; index < this.threadListHeads.length; ++index) {
            if (this.threadListHeads[index].length != this.threadListTailsIncreased[index].length) {
                throw new AssertionError((Object)"Non-synchronous lengths of heads/tails arrays");
            }
        }
        int[] nonEmptyHeads = new int[this.threadListHeads.length];
        int[] nonEmptyTails = new int[this.threadListTailsIncreased.length];
        for (int label = 0; label <= maxLabel; ++label) {
            int nonEmptyCount = 0;
            for (int index = 0; index < this.threadListHeads.length; ++index) {
                int[] tailsIncreased = this.threadListTailsIncreased[index];
                if (label >= tailsIncreased.length || tailsIncreased[label] <= 0) continue;
                nonEmptyHeads[nonEmptyCount] = this.threadListHeads[index][label];
                nonEmptyTails[nonEmptyCount] = tailsIncreased[label] - 1;
                ++nonEmptyCount;
            }
            for (int k = 1; k < nonEmptyCount; ++k) {
                int previousTail = nonEmptyTails[k - 1];
                if (previousTail < 0 || previousTail >= this.lists.length) {
                    throw new AssertionError((Object)("List tail #" + (k - 1) + " from " + nonEmptyCount + " (maximally from " + this.threadListHeads.length + ") = " + previousTail + " is out of range 0.." + (this.lists.length - 1) + "; label " + label + "/" + maxLabel + "; non-empty heads: " + Arrays.toString(Arrays.copyOfRange(nonEmptyHeads, 0, nonEmptyCount)) + "; non-empty tails: " + Arrays.toString(Arrays.copyOfRange(nonEmptyTails, 0, nonEmptyCount))));
                }
                assert (this.lists[previousTail] == -1);
                this.lists[previousTail] = nonEmptyHeads[k];
            }
            this.listHeads[label] = nonEmptyCount > 0 ? nonEmptyHeads[0] : -1;
        }
    }
}

