/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.matrices.scanning.Boundary2DProjectionMeasurer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ThirdProjectionValue {
    NONE{

        @Override
        Double thirdProjectionValue(Boundary2DProjectionMeasurer measurer, int projectionIndex, double pixelSize) {
            return null;
        }
    }
    ,
    ANGLE{

        @Override
        Double thirdProjectionValue(Boundary2DProjectionMeasurer measurer, int projectionIndex, double pixelSize) {
            return ThirdProjectionValue.normalizeGreater180(Math.toDegrees(measurer.startAngleInRadians()) + (double)projectionIndex * 180.0 / (double)measurer.numberOfDirections());
        }
    }
    ,
    INDEX{

        @Override
        Double thirdProjectionValue(Boundary2DProjectionMeasurer measurer, int projectionIndex, double pixelSize) {
            return projectionIndex;
        }
    };


    abstract Double thirdProjectionValue(Boundary2DProjectionMeasurer var1, int var2, double var3);

    public int oneIfExist() {
        return this == NONE ? 0 : 1;
    }

    private static double normalizeGreater180(double greater180) {
        return greater180 >= 180.0 ? greater180 - 180.0 : greater180;
    }
}

