/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Locale;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.Matrix;
import net.algart.contours.ContourFiller;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.UnpackContours;
import net.algart.math.IPoint;
import net.algart.math.IRectangularArea;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class FillContours
extends MultiMatrix2DFilter
implements ReadOnlyExecutionInput {
    public static final String RECTANGLE = "rectangle";
    public static final String INPUT_BACKGROUND = "background";
    public static final String INPUT_CONTOURS = "contours";
    public static final String INPUT_LABELS_MAP = "labels_map";
    public static final String INPUT_RECTANGLE = "rectangle";
    public static final String OUTPUT_LABELS = "labels";
    private boolean doAction = true;
    private Class<?> elementType = Integer.TYPE;
    private boolean needToProcessDiagonals = true;
    private boolean cacheUnpackedContours = false;
    private boolean zeroResultForEmptyContours = false;
    private int startX = 0;
    private int startY = 0;
    private int sizeX = 1000;
    private int sizeY = 1000;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;
    private Integer defaultFiller = null;
    private final UnpackContours unpacker = new UnpackContours().setCacheLastContours(true);

    public FillContours() {
        this.setDefaultInputMat(INPUT_BACKGROUND);
        this.addInputNumbers(INPUT_CONTOURS);
        this.addInputNumbers(INPUT_LABELS_MAP);
        this.addInputNumbers("rectangle");
        this.setDefaultOutputMat(OUTPUT_LABELS);
        this.addOutputScalar("number_of_objects");
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public FillContours setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public final Class<?> getElementType() {
        return this.elementType;
    }

    public FillContours setElementType(Class<?> elementType) {
        this.elementType = (Class)FillContours.nonNull(elementType, (String)"element type");
        return this;
    }

    public FillContours setElementType(String elementType) {
        this.setElementType(MultiMatrixGenerator.elementType((String)elementType));
        return this;
    }

    public boolean isNeedToProcessDiagonals() {
        return this.needToProcessDiagonals;
    }

    public FillContours setNeedToProcessDiagonals(boolean needToProcessDiagonals) {
        this.needToProcessDiagonals = needToProcessDiagonals;
        return this;
    }

    public boolean isCacheUnpackedContours() {
        return this.cacheUnpackedContours;
    }

    public FillContours setCacheUnpackedContours(boolean cacheUnpackedContours) {
        this.cacheUnpackedContours = cacheUnpackedContours;
        return this;
    }

    public boolean isZeroResultForEmptyContours() {
        return this.zeroResultForEmptyContours;
    }

    public FillContours setZeroResultForEmptyContours(boolean zeroResultForEmptyContours) {
        this.zeroResultForEmptyContours = zeroResultForEmptyContours;
        return this;
    }

    public int getStartX() {
        return this.startX;
    }

    public FillContours setStartX(int startX) {
        this.startX = startX;
        return this;
    }

    public int getStartY() {
        return this.startY;
    }

    public FillContours setStartY(int startY) {
        this.startY = startY;
        return this;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public FillContours setSizeX(int sizeX) {
        this.sizeX = FillContours.positive((int)sizeX);
        return this;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public FillContours setSizeY(int sizeY) {
        this.sizeY = FillContours.positive((int)sizeY);
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public FillContours setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)FillContours.nonNull((Object)indexingBase);
        return this;
    }

    public Integer getDefaultFiller() {
        return this.defaultFiller;
    }

    public FillContours setDefaultFiller(Integer defaultFiller) {
        this.defaultFiller = defaultFiller;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D background) {
        SNumbers inputContours = this.getInputNumbers(INPUT_CONTOURS, !this.doAction);
        return this.process(background, inputContours.toIntArrayOrReference());
    }

    public MultiMatrix2D process(MultiMatrix2D background, int[] serializedContours) {
        long t4;
        MultiMatrix2D result;
        long sizeX;
        long startY;
        Contours contours;
        if (!this.doAction) {
            this.getScalar("number_of_objects").setTo(0);
            return null;
        }
        Objects.requireNonNull(serializedContours, "Null serializedContours");
        long t1 = FillContours.debugTime();
        boolean useUnpacker = this.cacheUnpackedContours;
        if (useUnpacker) {
            this.unpacker.setNeedToProcessDiagonals(this.needToProcessDiagonals);
            contours = this.unpacker.unpackContours(serializedContours);
        } else {
            contours = Contours.deserialize((int[])serializedContours);
        }
        this.getScalar("number_of_objects").setTo(contours.numberOfContours());
        long t2 = FillContours.debugTime();
        if (contours.isEmpty() && !this.zeroResultForEmptyContours) {
            return null;
        }
        SNumbers area = this.getInputNumbers("rectangle", true);
        IRectangularArea rectangle = area.isProbableRectangularArea() ? area.toIRectangularArea() : null;
        IPoint position = rectangle != null ? rectangle.min() : area.toIPoint();
        long startX = position != null ? position.x() : (long)this.startX;
        long l = startY = position != null ? position.y() : (long)this.startY;
        long l2 = background != null ? background.dimX() : (sizeX = rectangle != null ? rectangle.sizeX() : (long)this.sizeX);
        long sizeY = background != null ? background.dimY() : (rectangle != null ? rectangle.sizeY() : (long)this.sizeY);
        int[] labelsMap = this.getInputNumbers(INPUT_LABELS_MAP, true).toIntArray();
        ContourFiller contourFiller = ContourFiller.newInstance((Contours)contours, this.elementType, (long)startX, (long)startY, (long)sizeX, (long)sizeY).setNeedToUnpack(!useUnpacker).setNeedToUnpackDiagonals(this.needToProcessDiagonals);
        long t3 = FillContours.debugTime();
        if (sizeX == 0L || sizeY == 0L) {
            result = MultiMatrix.valueOf2DMono((Matrix)Arrays.SMM.newIntMatrix(new long[]{sizeX, sizeY}));
            t4 = t3;
        } else {
            contourFiller.setLabelsMap(labelsMap);
            contourFiller.setIndexingBase(this.indexingBase.start);
            if (this.defaultFiller != null) {
                int filler = this.defaultFiller;
                contourFiller.setLabelToFillerDefault(label -> filler);
            }
            contourFiller.findAndSortNecessaryContours();
            t4 = FillContours.debugTime();
            contourFiller.fillNecessaryContours();
            result = MultiMatrix.valueOf2DMono((Matrix)contourFiller.getLabels());
        }
        long t5 = FillContours.debugTime();
        FillContours.logDebug(() -> String.format(Locale.US, "Filling %d contours from %d total contours in %.3f ms = %.3f %s + %.3f creating filler + %.3f preparing + %.3f filling", contourFiller.numberOfNecessaryContours(), contours.numberOfContours(), (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, useUnpacker ? "cached unpacking" : "loading", (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
        return result;
    }

    protected boolean allowUninitializedInput() {
        return true;
    }

    protected boolean resultRequired() {
        return false;
    }
}

