/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import net.algart.arrays.ByteArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.cv.matrices.drawing.DrawPattern;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.opencv.common.MatFilter;
import net.algart.executors.modules.opencv.matrices.segmentation.Watershed;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;
import org.bytedeco.opencv.opencv_core.Mat;

public final class WatershedNearestPixels
extends MatFilter {
    public static final String INPUT_SAMPLE_IMAGE = "sample_image";
    public static final String INPUT_POSITIONS = "positions";
    public static final String OUTPUT_LABELS = "labels";
    private int dimX = 100;
    private int dimY = 100;

    public WatershedNearestPixels() {
        this.setDefaultInputMat(INPUT_SAMPLE_IMAGE);
        this.addInputNumbers(INPUT_POSITIONS);
        this.setDefaultOutputMat(OUTPUT_LABELS);
    }

    public int getDimX() {
        return this.dimX;
    }

    public WatershedNearestPixels setDimX(int dimX) {
        this.dimX = WatershedNearestPixels.positive((int)dimX);
        return this;
    }

    public int getDimY() {
        return this.dimY;
    }

    public WatershedNearestPixels setDimY(int dimY) {
        this.dimY = WatershedNearestPixels.positive((int)dimY);
        return this;
    }

    @Override
    public Mat process(Mat source) {
        return this.process(source, this.getInputNumbers(INPUT_POSITIONS));
    }

    public Mat process(Mat source, SNumbers positions) {
        int dimX = source == null ? this.dimX : source.cols();
        int dimY = source == null ? this.dimY : source.rows();
        return this.process(dimX, dimY, positions);
    }

    public Mat process(int dimX, int dimY, SNumbers positions) {
        positions = positions.columnRange(0, 2);
        MultiMatrix2D dummy = MultiMatrix.of2DMono((Matrix)Matrices.constantMatrix((double)0.0, ByteArray.class, (long[])new long[]{dimX, dimY}));
        DrawPattern drawPattern = new DrawPattern();
        drawPattern.setClearSource(true).setPattern(MorphologyFilter.Shape.CUBE, 1);
        drawPattern.putNumbers(INPUT_POSITIONS, positions);
        MultiMatrix2D points = drawPattern.process((MultiMatrix)dummy).asMultiMatrix2D();
        Watershed watershed = new Watershed();
        watershed.setSeedingMode(Watershed.SeedingMode.CONNECTED_COMPONENTS_ONLY);
        watershed.setValuesOnBoundaries(Watershed.ValuesOnBoundaries.NEAREST_LABEL);
        return watershed.process(null, O2SMat.toMat(points));
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }
}

