/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.ml;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.algart.executors.modules.opencv.matrices.ml.MLKind;
import net.algart.json.Jsons;

public final class MLMetadataJson {
    public static final String APP_NAME = "machine-learning";
    public static final String CURRENT_VERSION = "1.0";
    public static final String METADATA_FILE_SUFFIX = ".meta";
    private Path mlMetadataJsonFile = null;
    private String version = "1.0";
    private MLKind modelKind = null;
    private String createdBy = null;
    private JsonObject parameters = null;

    public MLMetadataJson() {
    }

    private MLMetadataJson(JsonObject json, Function<String, Optional<MLKind>> modelNameToKind, Path file) {
        if (!MLMetadataJson.isMLMetadataJson(json)) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + file) + " is not a metadata for ML statistical model mapping configuration: no \"app\":\"machine-learning\" element");
        }
        Objects.requireNonNull(modelNameToKind, "Null modelNameToKind function");
        this.mlMetadataJsonFile = file;
        this.version = json.getString("version", CURRENT_VERSION);
        String modelKind = json.getString("model_kind", null);
        if (modelKind != null) {
            this.modelKind = modelNameToKind.apply(modelKind).orElse(null);
            Jsons.requireNonNull((Object)this.modelKind, (JsonObject)json, (String)"model_kind", (Path)file);
        }
        this.createdBy = json.getString("created_by", null);
        this.parameters = json.getJsonObject("parameters");
    }

    public static MLMetadataJson read(Path mlMetadataJsonFile, Function<String, Optional<MLKind>> modelNameToKind) throws IOException {
        Objects.requireNonNull(mlMetadataJsonFile, "Null mlMetadataJsonFile");
        Objects.requireNonNull(modelNameToKind, "Null modelNameToKind function");
        JsonObject json = Jsons.readJson((Path)mlMetadataJsonFile);
        return new MLMetadataJson(json, modelNameToKind, mlMetadataJsonFile);
    }

    public static MLMetadataJson readIfValid(Path mlMetadataJsonFile, Function<String, Optional<MLKind>> modelNameToKind) throws IOException {
        Objects.requireNonNull(mlMetadataJsonFile, "Null mlMetadataJsonFile");
        Objects.requireNonNull(modelNameToKind, "Null modelNameToKind function");
        JsonObject json = Jsons.readJson((Path)mlMetadataJsonFile);
        if (!MLMetadataJson.isMLMetadataJson(json)) {
            return null;
        }
        return new MLMetadataJson(json, modelNameToKind, mlMetadataJsonFile);
    }

    public void write(Path mlMetadataJsonFile, OpenOption ... options) throws IOException {
        Objects.requireNonNull(mlMetadataJsonFile, "Null mlMetadataJsonFile");
        Files.write(mlMetadataJsonFile, Jsons.toPrettyString((JsonObject)this.toJson()).getBytes(StandardCharsets.UTF_8), options);
    }

    public static Path metadataFile(Path mainModelFile) throws IOException {
        Objects.requireNonNull(mainModelFile, "Null mainModelFile");
        return MLMetadataJson.metadataFile(mainModelFile.toString());
    }

    public static Path metadataFile(String mainModelFile) throws IOException {
        Objects.requireNonNull(mainModelFile, "Null mainModelFile");
        return Paths.get(mainModelFile + METADATA_FILE_SUFFIX, new String[0]);
    }

    public static MLMetadataJson of(JsonObject mlMetadataJson, Function<String, Optional<MLKind>> modelNameToKind) {
        Objects.requireNonNull(modelNameToKind, "Null modelNameToKind function");
        return new MLMetadataJson(mlMetadataJson, modelNameToKind, null);
    }

    public static boolean isMLMetadataJson(JsonObject mlMetadataJson) {
        Objects.requireNonNull(mlMetadataJson, "Null mapping JSON");
        return APP_NAME.equals(mlMetadataJson.getString("app", null));
    }

    public Path getMLMetadataJsonFile() {
        return this.mlMetadataJsonFile;
    }

    public String getVersion() {
        return this.version;
    }

    public MLMetadataJson setVersion(String version) {
        this.version = version;
        return this;
    }

    public MLKind getModelKind() {
        return this.modelKind;
    }

    public MLMetadataJson setModelKind(MLKind modelKind) {
        this.modelKind = modelKind;
        return this;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public MLMetadataJson setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public JsonObject getParameters() {
        return this.parameters;
    }

    public MLMetadataJson setParameters(JsonObject parameters) {
        this.parameters = parameters;
        return this;
    }

    public final JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("app", APP_NAME);
        builder.add("version", this.version);
        if (this.modelKind != null) {
            builder.add("model_kind", this.modelKind.modelName());
        }
        if (this.createdBy != null) {
            builder.add("created_by", this.createdBy);
        }
        if (this.parameters != null) {
            builder.add("parameters", (JsonValue)this.parameters);
        }
        return builder.build();
    }

    public String jsonString() {
        return Jsons.toPrettyString((JsonObject)this.toJson());
    }

    public String toString() {
        return "MLMetadataJson{mlMetadataJsonFile=" + this.mlMetadataJsonFile + ", version='" + this.version + "', modelKind=" + this.modelKind + ", createdBy='" + this.createdBy + "', parameters=" + this.parameters + "}";
    }
}

