/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.geometry;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.UMat;

public final class SubMatrix
extends UMatFilter
implements ReadOnlyExecutionInput {
    private int left = 0;
    private int top = 0;
    private int right = 0;
    private int bottom = 0;
    private int width = 0;
    private int height = 0;
    private String outsideColor = "#FFFFFF";

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getOutsideColor() {
        return this.outsideColor;
    }

    public void setOutsideColor(String outsideColor) {
        this.outsideColor = (String)SubMatrix.nonNull((Object)outsideColor);
    }

    @Override
    public Mat process(Mat source) {
        int height;
        int right = this.right >= 0 ? this.right : source.cols() - 1 + this.right;
        int bottom = this.bottom >= 0 ? this.bottom : source.rows() - 1 + this.bottom;
        int width = this.width > 0 ? this.width : right - this.left + 1;
        int n = height = this.height > 0 ? this.height : bottom - this.top + 1;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Empty or negative-size result matrix " + width + "x" + height);
        }
        Mat result = new Mat(height, width, source.type());
        int xFrom = Math.max(this.left, 0);
        int yFrom = Math.max(this.top, 0);
        int xTo = Math.min(this.left + width, source.cols());
        int yTo = Math.min(this.top + height, source.rows());
        int w = xTo - xFrom;
        int h = yTo - yFrom;
        if (w > 0 && h > 0) {
            try (Scalar scalar = OTools.scalarBGRA(this.outsideColor, OTools.maxPossibleValue(source));
                 Rect sourceRect = new Rect(xFrom, yFrom, w, h);
                 Rect resultRect = new Rect(xFrom - this.left, yFrom - this.top, w, h);){
                if (w < width || h < height) {
                    result.put(scalar);
                }
                try (Mat s = source.apply(sourceRect);
                     Mat r = result.apply(resultRect);){
                    s.copyTo(r);
                }
            }
        }
        return result;
    }

    @Override
    public UMat process(UMat source) {
        int height;
        int right = this.right >= 0 ? this.right : source.cols() - 1 + this.right;
        int bottom = this.bottom >= 0 ? this.bottom : source.rows() - 1 + this.bottom;
        int width = this.width > 0 ? this.width : right - this.left + 1;
        int n = height = this.height > 0 ? this.height : bottom - this.top + 1;
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Empty or negative-size result matrix " + width + "x" + height);
        }
        UMat result = new UMat(height, width, source.type());
        int xFrom = Math.max(this.left, 0);
        int yFrom = Math.max(this.top, 0);
        int xTo = Math.min(this.left + width, source.cols());
        int yTo = Math.min(this.top + height, source.rows());
        int w = xTo - xFrom;
        int h = yTo - yFrom;
        if (w > 0 && h > 0) {
            try (Scalar scalar = OTools.scalarBGRA(this.outsideColor, OTools.maxPossibleValue(source));
                 Rect sourceRect = new Rect(xFrom, yFrom, w, h);
                 Rect resultRect = new Rect(xFrom - this.left, yFrom - this.top, w, h);){
                if (w < width || h < height) {
                    result.put(scalar);
                }
                try (UMat s = source.apply(sourceRect);
                     UMat r = result.apply(resultRect);){
                    s.copyTo(r);
                }
            }
        }
        return result;
    }
}

