/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.common;

import net.algart.executors.modules.opencv.common.MatFilter;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public abstract class UMatFilter
extends MatFilter {
    protected UMatFilter() {
    }

    @Override
    public void process() {
        if (!this.useGPU()) {
            super.process();
            return;
        }
        UMat source = O2SMat.toUMat(this.getInputMat(this.allowUninitializedInput()), this.allowInputPackedBits());
        UMat result = this.processWithCompression(source);
        this.setOutputTo(result);
    }

    public UMat processWithCompression(UMat source) {
        this.sourceDimX = source != null ? source.cols() : -1;
        this.sourceDimY = source != null ? source.rows() : -1;
        UMat compressedSource = this.compressOriginal(source);
        this.setStartProcessingTimeStamp();
        UMat compressedResult = this.process(compressedSource);
        this.setEndProcessingTimeStamp();
        UMat result = this.stretchToOriginal(compressedResult);
        if (result != compressedResult) {
            compressedResult.close();
            if (compressedSource != null) {
                compressedSource.close();
            }
        }
        return result;
    }

    public void setOutputTo(UMat result) {
        if (this.packOutputBits()) {
            this.getMat().setTo((MultiMatrix)O2SMat.toBinaryMatrix(result));
        } else {
            O2SMat.setTo(this.getMat(), result);
        }
    }

    public abstract UMat process(UMat var1);

    public final UMat compressOriginal(UMat mat) {
        if (mat == null || this.optimizingScale <= 1.0) {
            return mat;
        }
        UMat result = new UMat();
        double fxy = 1.0 / this.optimizingScale;
        try (Size size = new Size();){
            opencv_imgproc.resize((UMat)mat, (UMat)result, (Size)size, (double)fxy, (double)fxy, (int)this.compressionInterpolation.code());
        }
        return result;
    }

    public final UMat stretchToOriginal(UMat mat) {
        if (mat == null || this.optimizingScale <= 1.0 || this.sourceDimX == mat.cols() && this.sourceDimY == mat.rows()) {
            return mat;
        }
        UMat result = new UMat();
        try (Size size = new Size(this.sourceDimX, this.sourceDimY);){
            opencv_imgproc.resize((UMat)mat, (UMat)result, (Size)size, (double)0.0, (double)0.0, (int)this.stretchingInterpolation.code());
        }
        return result;
    }
}

