/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.pixels;

import java.util.ArrayList;
import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class SetPixels
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_PIXEL_VALUES = "pixel_values";
    public static final String INPUT_MASK = "mask";
    public static final String INPUT_BACKGROUND = "background";
    private Class<?> elementType = Float.TYPE;
    private boolean rawPixelValues = false;
    private boolean supposeMaskAlwaysTrue = false;

    public SetPixels() {
        this.setDefaultInputNumbers(INPUT_PIXEL_VALUES);
        this.addInputMat(INPUT_MASK);
        this.addInputMat(INPUT_BACKGROUND);
        this.addOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public final Class<?> getElementType() {
        return this.elementType;
    }

    public SetPixels setElementType(Class<?> elementType) {
        this.elementType = (Class)SetPixels.nonNull(elementType, (String)"element type");
        return this;
    }

    public SetPixels setElementType(String elementType) {
        this.setElementType(MultiMatrixGenerator.elementType((String)elementType));
        return this;
    }

    public boolean isRawPixelValues() {
        return this.rawPixelValues;
    }

    public SetPixels setRawPixelValues(boolean rawPixelValues) {
        this.rawPixelValues = rawPixelValues;
        return this;
    }

    public boolean isSupposeMaskAlwaysTrue() {
        return this.supposeMaskAlwaysTrue;
    }

    public SetPixels setSupposeMaskAlwaysTrue(boolean supposeMaskAlwaysTrue) {
        this.supposeMaskAlwaysTrue = supposeMaskAlwaysTrue;
        return this;
    }

    public void process() {
        SNumbers source = this.getInputNumbers();
        MultiMatrix2D mask = this.getInputMat(INPUT_MASK, true).toMultiMatrix2D();
        MultiMatrix2D background = this.getInputMat(INPUT_BACKGROUND, true).toMultiMatrix2D();
        this.setStartProcessingTimeStamp();
        MultiMatrix2D result = this.process(source, mask, background);
        this.setEndProcessingTimeStamp();
        this.getMat().setTo((MultiMatrix)result);
    }

    public MultiMatrix2D process(SNumbers pixels, long dimX, long dimY, MultiMatrix2D background) {
        Matrix mask = Matrices.matrix((Array)Arrays.nBitCopies((long)(dimX * dimY), (boolean)true), (long[])new long[]{dimX, dimY});
        return this.process(pixels, MultiMatrix.of2DMono((Matrix)mask), background);
    }

    public MultiMatrix2D process(SNumbers pixels, MultiMatrix2D mask, MultiMatrix2D background) {
        BitArray maskArray;
        long[] dimensions;
        Objects.requireNonNull(pixels, "Null pixels");
        if (mask == null && background == null) {
            throw new IllegalArgumentException("At least one of images \"mask\" or \"background\" must be initialized");
        }
        long[] lArray = dimensions = mask != null ? mask.dimensions() : background.dimensions();
        if (mask == null) {
            mask = MultiMatrix.of2DMono((Matrix)Matrices.constantMatrix((double)1.0, BitArray.class, (long[])dimensions));
        }
        if (background != null && !mask.dimEquals((MultiMatrix)background)) {
            throw new IllegalArgumentException("The mask and background multi-matrix dimensions mismatch: " + mask + " and " + background);
        }
        if (mask.size() != (long)((int)mask.size())) {
            throw new TooLargeArrayException("Too large matrix: " + mask);
        }
        int numberOfChannels = pixels.getBlockLength();
        BitArray bitArray = maskArray = this.supposeMaskAlwaysTrue ? Arrays.nBitCopies((long)mask.size(), (boolean)true) : (BitArray)mask.nonZeroAnyChannelMatrix().array();
        if (background != null) {
            background = background.asPrecision(Float.TYPE);
            if (numberOfChannels == 1) {
                background = background.asMono();
            }
        }
        float[] data = pixels.toFloatArray();
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        for (int channelIndex = 0; channelIndex < numberOfChannels; ++channelIndex) {
            Matrix channel = Arrays.SMM.newFloatMatrix(dimensions);
            UpdatablePArray channelArray = (UpdatablePArray)channel.array();
            if (background != null && channelIndex < background.numberOfChannels()) {
                channelArray.copy(background.channel(channelIndex).array());
            }
            int disp = channelIndex;
            if (this.rawPixelValues) {
                double mult = 1.0 / Arrays.maxPossibleValue((Class)Arrays.type(PArray.class, this.elementType), (double)1.0);
                long n = channelArray.length();
                for (long j = 0L; j < n && disp < data.length; ++j) {
                    if (!maskArray.getBit(j)) continue;
                    channelArray.setDouble(j, (double)data[disp] * mult);
                    disp += numberOfChannels;
                }
            } else {
                long n = channelArray.length();
                for (long j = 0L; j < n && disp < data.length; ++j) {
                    if (!maskArray.getBit(j)) continue;
                    channelArray.setDouble(j, (double)data[disp]);
                    disp += numberOfChannels;
                }
            }
            result.add(Matrices.clone((Matrix)Matrices.asPrecision((Matrix)channel, this.elementType)));
        }
        return MultiMatrix.of2D(result);
    }
}

