/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.FirstNonZeroCalculator;

abstract class FirstNonZeroCalculator1Channels
extends FirstNonZeroCalculator {
    FirstNonZeroCalculator1Channels(int[] labels) {
        super(labels, 1);
    }

    static class ForDoubles
    extends FirstNonZeroCalculator1Channels {
        private final double[] data0;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForDoubles.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0.0) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroFloatValues = new float[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroFloatValues[disp] = (float)this.data0[index];
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    static class ForFloats
    extends FirstNonZeroCalculator1Channels {
        private final float[] data0;

        public ForFloats(int[] labels, float[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForFloats.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0.0f) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroFloatValues = new float[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroFloatValues[disp] = this.data0[index];
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    static class ForInts
    extends FirstNonZeroCalculator1Channels {
        private final int[] data0;

        public ForInts(int[] labels, int[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForInts.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroIntValues[disp] = this.data0[index];
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    static class ForShorts
    extends FirstNonZeroCalculator1Channels {
        private final short[] data0;

        public ForShorts(int[] labels, short[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForShorts.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroIntValues[disp] = this.data0[index] & 0xFFFF;
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }

    static class ForBytes
    extends FirstNonZeroCalculator1Channels {
        private final byte[] data0;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels);
            this.data0 = data[0];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            int[] firstNonZeroIndexesIncreased = this.threadFirstNonZeroIndexesIncreased[threadIndex];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    firstNonZeroIndexesIncreased = ForBytes.ensureCapacityForLabel(firstNonZeroIndexesIncreased, label);
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                if (firstNonZeroIndexesIncreased[label] != 0 || this.data0[k] == 0) continue;
                firstNonZeroIndexesIncreased[label] = k + 1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
            this.threadFirstNonZeroIndexesIncreased[threadIndex] = firstNonZeroIndexesIncreased;
        }

        @Override
        protected void finish() {
            super.finish();
            this.firstNonZeroIntValues = new int[this.firstNonZeroIndexes.length * this.numberOfChannels];
            int label = 0;
            int disp = 0;
            while (label < this.firstNonZeroIndexes.length) {
                int index = this.firstNonZeroIndexes[label];
                if (index >= 0) {
                    this.firstNonZeroIntValues[disp] = this.data0[index] & 0xFF;
                }
                ++label;
                disp += this.numberOfChannels;
            }
        }
    }
}

