/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsCalculator;

abstract class CardinalitiesAndSumsCalculator3Channels
extends CardinalitiesAndSumsCalculator {
    CardinalitiesAndSumsCalculator3Channels(int[] labels) {
        super(labels, 3);
    }

    static class ForDoubles
    extends CardinalitiesAndSumsCalculator3Channels {
        private final double[] data0;
        private final double[] data1;
        private final double[] data2;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + this.data0[k];
                int n3 = label;
                sums1[n3] = sums1[n3] + this.data1[k];
                int n4 = label;
                sums2[n4] = sums2[n4] + this.data2[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForFloats
    extends CardinalitiesAndSumsCalculator3Channels {
        private final float[] data0;
        private final float[] data1;
        private final float[] data2;

        public ForFloats(int[] labels, float[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)this.data0[k];
                int n3 = label;
                sums1[n3] = sums1[n3] + (double)this.data1[k];
                int n4 = label;
                sums2[n4] = sums2[n4] + (double)this.data2[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForInts
    extends CardinalitiesAndSumsCalculator3Channels {
        private final int[] data0;
        private final int[] data1;
        private final int[] data2;

        public ForInts(int[] labels, int[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)this.data0[k];
                int n3 = label;
                sums1[n3] = sums1[n3] + (double)this.data1[k];
                int n4 = label;
                sums2[n4] = sums2[n4] + (double)this.data2[k];
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForShorts
    extends CardinalitiesAndSumsCalculator3Channels {
        private final short[] data0;
        private final short[] data1;
        private final short[] data2;

        public ForShorts(int[] labels, short[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)(this.data0[k] & 0xFFFF);
                int n3 = label;
                sums1[n3] = sums1[n3] + (double)(this.data1[k] & 0xFFFF);
                int n4 = label;
                sums2[n4] = sums2[n4] + (double)(this.data2[k] & 0xFFFF);
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForBytes
    extends CardinalitiesAndSumsCalculator3Channels {
        private final byte[] data0;
        private final byte[] data1;
        private final byte[] data2;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sums2 = sums[2];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sums2 = sums[2];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                int n2 = label;
                sums0[n2] = sums0[n2] + (double)(this.data0[k] & 0xFF);
                int n3 = label;
                sums1[n3] = sums1[n3] + (double)(this.data1[k] & 0xFF);
                int n4 = label;
                sums2[n4] = sums2[n4] + (double)(this.data2[k] & 0xFF);
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }
}

