/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.video;

import net.algart.executors.api.data.Port;
import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.O2SMat;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;
import org.bytedeco.opencv.opencv_video.BackgroundSubtractor;

public abstract class AbstractBackgroundSubtractor
extends VoidResultUMatFilter {
    public static final String OUTPUT_BACKGROUND = "background";
    private boolean reset = true;
    private boolean detectShadows = true;
    private volatile BackgroundSubtractor subtractor = null;
    private volatile Mat background = null;

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public AbstractBackgroundSubtractor() {
        this.addOutputMat(OUTPUT_BACKGROUND);
    }

    public boolean isDetectShadows() {
        return this.detectShadows;
    }

    public void setDetectShadows(boolean detectShadows) {
        this.detectShadows = detectShadows;
    }

    public Mat getBackground() {
        return this.background;
    }

    @Override
    public void process(Mat result, Mat source) {
        Port backgroundPort = this.getOutputPort(OUTPUT_BACKGROUND);
        if (this.subtractor == null || this.reset) {
            if (this.subtractor != null) {
                this.subtractor.close();
            }
            this.subtractor = this.createBackgroundSubtractor();
        }
        this.subtractor.apply(source, result);
        if (backgroundPort != null && backgroundPort.isConnected()) {
            if (this.background != null) {
                this.background.close();
            }
            this.createBackground();
            this.subtractor.getBackgroundImage(this.background);
            O2SMat.setTo(this.getMat(OUTPUT_BACKGROUND), this.background);
        }
    }

    @Override
    public void process(UMat result, UMat source) {
        Port backgroundPort = this.getOutputPort(OUTPUT_BACKGROUND);
        if (this.subtractor == null || this.reset) {
            if (this.subtractor != null) {
                this.subtractor.close();
            }
            this.subtractor = this.createBackgroundSubtractor();
        }
        this.subtractor.apply(source, result);
        if (backgroundPort != null && backgroundPort.isConnected()) {
            if (this.background != null) {
                this.background.close();
            }
            this.createBackground();
            this.subtractor.getBackgroundImage(this.background);
            O2SMat.setTo(this.getMat(OUTPUT_BACKGROUND), this.background);
        }
    }

    @Override
    public void close() {
        if (this.subtractor != null) {
            this.subtractor.close();
            this.subtractor = null;
        }
        if (this.background != null) {
            this.background.close();
            this.background = null;
        }
        super.close();
    }

    abstract BackgroundSubtractor createBackgroundSubtractor();

    private void createBackground() {
        this.background = new Mat();
    }
}

