/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import net.algart.executors.modules.opencv.matrices.segmentation.AbstractSuperpixel;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class SuperpixelSLIC
extends AbstractSuperpixel {
    private SlicAlgorithm slicAlgorithm = SlicAlgorithm.SLICO;
    private int regionSize = 10;
    private double ruler = 10.0;
    private int enforceLabelConnectivityMinElementSize = 0;
    private int numberOfIterations = 10;

    public SlicAlgorithm getSlicAlgorithm() {
        return this.slicAlgorithm;
    }

    public void setSlicAlgorithm(SlicAlgorithm slicAlgorithm) {
        this.slicAlgorithm = (SlicAlgorithm)((Object)SuperpixelSLIC.nonNull((Object)((Object)slicAlgorithm)));
    }

    public int getRegionSize() {
        return this.regionSize;
    }

    public void setRegionSize(int regionSize) {
        this.regionSize = SuperpixelSLIC.nonNegative((int)regionSize);
    }

    public double getRuler() {
        return this.ruler;
    }

    public void setRuler(double ruler) {
        this.ruler = ruler;
    }

    public int getEnforceLabelConnectivityMinElementSize() {
        return this.enforceLabelConnectivityMinElementSize;
    }

    public void setEnforceLabelConnectivityMinElementSize(int enforceLabelConnectivityMinElementSize) {
        this.enforceLabelConnectivityMinElementSize = SuperpixelSLIC.nonNegative((int)enforceLabelConnectivityMinElementSize);
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public void setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = SuperpixelSLIC.positive((int)numberOfIterations);
    }

    @Override
    public Mat process(Mat source) {
        Mat result = new Mat();
        try (org.bytedeco.opencv.opencv_ximgproc.SuperpixelSLIC superpixel = opencv_ximgproc.createSuperpixelSLIC((Mat)source, (int)this.slicAlgorithm.code, (int)this.regionSize, (float)((float)this.ruler));){
            superpixel.iterate(this.numberOfIterations);
            SuperpixelSLIC.logDebug(() -> "Superpixel SLIC found " + superpixel.getNumberOfSuperpixels() + " superpixels; algorithm " + this.slicAlgorithm + ", regionSize " + this.regionSize + ", ruler " + this.ruler + " (source: " + source + ")");
            if (this.enforceLabelConnectivityMinElementSize > 0) {
                superpixel.enforceLabelConnectivity(this.enforceLabelConnectivityMinElementSize);
            }
            superpixel.getLabels(result);
            this.makeLabelsPositiveIfRequired(result);
            this.setToOutputBoundaries((Mat boundaries, Mat labels, boolean needThick) -> superpixel.getLabelContourMask(boundaries, this.drawingBoundariesStyle.thickBoundaries), source, result);
        }
        return result;
    }

    @Override
    public UMat process(UMat source) {
        UMat result = new UMat();
        try (org.bytedeco.opencv.opencv_ximgproc.SuperpixelSLIC superpixel = opencv_ximgproc.createSuperpixelSLIC((UMat)source, (int)this.slicAlgorithm.code, (int)this.regionSize, (float)((float)this.ruler));){
            superpixel.iterate(this.numberOfIterations);
            SuperpixelSLIC.logDebug(() -> "Superpixel SLIC found " + superpixel.getNumberOfSuperpixels() + " superpixels; algorithm " + this.slicAlgorithm + ", regionSize " + this.regionSize + ", ruler " + this.ruler + " (source: " + source + ")");
            if (this.enforceLabelConnectivityMinElementSize > 0) {
                superpixel.enforceLabelConnectivity(this.enforceLabelConnectivityMinElementSize);
            }
            superpixel.getLabels(result);
            this.makeLabelsPositiveIfRequired(result);
            this.setToOutputBoundaries((Mat boundaries, Mat labels, boolean needThick) -> superpixel.getLabelContourMask(boundaries, this.drawingBoundariesStyle.thickBoundaries), source, result);
        }
        return result;
    }

    public static enum SlicAlgorithm {
        SLIC(100),
        SLICO(101),
        MSLIC(102);

        private final int code;

        private SlicAlgorithm(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

